/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.dataimport;

import com.luna.insight.core.catalog.iface.IEntityField;
import com.luna.insight.core.catalog.iface.IEntityType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SourceImportEntity {
    public static final char LAST_UNICODE_CHAR = '\uffff';
    private long entityID;
    private IEntityType entityType;
    private List entityFieldValues;
    private List relatedSourceEntities = new ArrayList();
    private Set relatedIDs = new HashSet();
    private Set referencedBy = new HashSet();
    private Object record;
    private boolean failedMediaProcessing = false;

    public static SourceImportEntity getByEntityType(List list, IEntityType iEntityType) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            SourceImportEntity sourceImportEntity = (SourceImportEntity)iterator.next();
            if (sourceImportEntity.entityType != iEntityType) continue;
            return sourceImportEntity;
        }
        return null;
    }

    public SourceImportEntity(IEntityType iEntityType, List list, long l) throws IllegalArgumentException {
        if (iEntityType == null || list == null) {
            throw new IllegalArgumentException();
        }
        this.entityType = iEntityType;
        this.entityFieldValues = list;
        this.entityID = l;
    }

    public void addRelatedSourceEntity(SourceImportEntity sourceImportEntity) {
        Long l = new Long(sourceImportEntity.getEntityID());
        if (!this.relatedIDs.contains(l)) {
            this.relatedSourceEntities.add(sourceImportEntity);
            this.relatedIDs.add(l);
            sourceImportEntity.addReferencedBy(new Long(this.entityID));
        }
    }

    public List getEntityFieldValues() {
        return this.entityFieldValues;
    }

    public long getEntityID() {
        return this.entityID;
    }

    public IEntityType getEntityType() {
        return this.entityType;
    }

    public boolean isPrimaryType() {
        return this.entityType.isPrimaryType();
    }

    public List getRelatedSourceEntities() {
        return this.relatedSourceEntities;
    }

    protected IEntityField getEntityField(int n) {
        return (IEntityField)((Object[])this.entityFieldValues.get(n))[0];
    }

    protected String getEntityFieldValue(int n) {
        return (String)((Object[])this.entityFieldValues.get(n))[1];
    }

    protected StringBuffer getKeyString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.entityFieldValues.size(); ++i) {
            stringBuffer.append(this.getEntityField(i).getName()).append('\uffff').append(this.getEntityFieldValue(i)).append('\uffff');
        }
        return stringBuffer;
    }

    public boolean equals(Object object) {
        return this.getKeyString().toString().equals(((SourceImportEntity)object).getKeyString().toString());
    }

    public int hashCode() {
        return this.getKeyString().toString().hashCode();
    }

    public Set getReferencedBy() {
        return this.referencedBy;
    }

    public boolean isReferencedBy(SourceImportEntity sourceImportEntity) {
        return this.referencedBy.contains(new Long(sourceImportEntity.getEntityID()));
    }

    public void addReferencedBy(Long l) {
        this.referencedBy.add(l);
    }

    public Object getRecord() {
        return this.record;
    }

    public void setRecord(Object object) {
        this.record = object;
    }

    public Set setFailedMediaProcessing() {
        HashSet<Long> hashSet = new HashSet<Long>();
        Long l = new Long(this.entityID);
        hashSet.add(l);
        Iterator iterator = this.relatedSourceEntities.iterator();
        while (iterator.hasNext()) {
            SourceImportEntity sourceImportEntity = (SourceImportEntity)iterator.next();
            sourceImportEntity.unlinkFrom(l, hashSet);
            iterator.remove();
        }
        this.failedMediaProcessing = true;
        return hashSet;
    }

    private void unlinkFrom(Long l, Set set) {
        this.referencedBy.remove(l);
        if (this.referencedBy.size() == 0) {
            Long l2 = new Long(this.entityID);
            set.add(l2);
            Iterator iterator = this.relatedSourceEntities.iterator();
            while (iterator.hasNext()) {
                SourceImportEntity sourceImportEntity = (SourceImportEntity)iterator.next();
                sourceImportEntity.unlinkFrom(l2, set);
                iterator.remove();
            }
        }
    }

    public boolean isFailedMediaProcessing() {
        return this.failedMediaProcessing;
    }
}

