/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.dataimport;

import com.luna.insight.core.dataimport.DataImportConstants;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.EnhancedProperties;
import java.io.File;
import java.util.Properties;

public class DataImportParams
implements DataImportConstants {
    private char separator = (char)9;
    private long maxFileSize = 1500000000L;
    private String jdbcDriverName = "sun.jdbc.odbc.JdbcOdbcDriver";
    private String jdbcDriverPrefix = "jdbc:odbc:";
    private String jdbcUrl = "";
    private String username = "";
    private String password = "";
    private String sqlStatement = "SELECT * FROM ";
    private String lineBreakEscape = "~LF~";
    private String carriageReturnEscape = "~CR~";
    private String doubleQuoteExcape = "\"\"";
    private String fileExtension = ".csv";
    private String fileEncoding = DataImportConstants.DEFAULT_FILE_ENCODING;
    private String xmlFileName;
    private Properties props = new Properties();

    public DataImportParams() {
    }

    public DataImportParams(EnhancedProperties enhancedProperties) {
        if (enhancedProperties != null) {
            this.separator = enhancedProperties.getCharProperty("separator", '\t');
            this.maxFileSize = enhancedProperties.getLongProperty("maxFileSize", 1500000000L);
            this.jdbcDriverName = enhancedProperties.getProperty("JDBCDriverName", "sun.jdbc.odbc.JdbcOdbcDriver");
            this.jdbcDriverPrefix = enhancedProperties.getProperty("JDBCUrlPrefix", "jdbc:odbc:");
            this.jdbcUrl = enhancedProperties.getProperty("databaseConnect", "");
            this.username = enhancedProperties.getProperty("username", "");
            this.password = enhancedProperties.getProperty("password", "");
            this.sqlStatement = enhancedProperties.getProperty("sqlStatement", "SELECT * FROM ");
            this.lineBreakEscape = enhancedProperties.getProperty("lineBreakEscape", "~LF~");
            this.carriageReturnEscape = enhancedProperties.getProperty("carriageReturnEscape", "~CR~");
            this.doubleQuoteExcape = enhancedProperties.getProperty("doubleQouteEscape", "\"\"");
            this.fileExtension = enhancedProperties.getProperty("fileExtension", ".csv");
            this.fileEncoding = enhancedProperties.getProperty("charset", DataImportConstants.DEFAULT_FILE_ENCODING);
        }
    }

    public String getCarriageReturnEscape() {
        return this.carriageReturnEscape;
    }

    public String getDoubleQuoteExcape() {
        return this.doubleQuoteExcape;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public String getJdbcDriverName() {
        return this.jdbcDriverName;
    }

    public String getJdbcDriverPrefix() {
        return this.jdbcDriverPrefix;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getLineBreakEscape() {
        return this.lineBreakEscape;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public String getPassword() {
        return this.password;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getSqlStatement() {
        return this.sqlStatement;
    }

    public String getUsername() {
        return this.username;
    }

    public String getXmlFileName() {
        return this.xmlFileName;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setCarriageRetureEscape(String string) {
        this.carriageReturnEscape = string;
        this.props.put("carriageReturnEscape", string);
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    public void setFileEncoding(String string) {
        this.fileEncoding = string;
        if (string == null) {
            this.props.remove("charset");
        } else {
            this.props.put("charset", string);
        }
    }

    public void setDBDriverProfile(String string, String string2, String string3, String string4) {
        String string5;
        String string6;
        if (string == "mssql") {
            string6 = "jdbc:inetdae7:";
            string5 = "com.inet.tds.TdsDriver";
        } else if (string == "oracle") {
            string6 = "jdbc:oracle:thin:";
            string5 = "oracle.jdbc.driver.OracleDriver";
        } else if (string == "db2") {
            string6 = "jdbc:db2:";
            string5 = "com.ibm.db2.jcc.DB2Driver";
        } else {
            string6 = "jdbc:odbc:";
            string5 = "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        this.setDBDriverProfile(string6, string5, string2, string3, string4);
    }

    public void setDBDriverProfile(String string, String string2, String string3, String string4, String string5) {
        this.setJdbcDriverPrefix(string);
        this.setJdbcDriverName(string2);
        this.setJdbcUrl(this.getJdbcDriverPrefix() + string3);
        this.setUsername(string4);
        this.setPassword(string5);
    }

    public void setDoubleQuoteExcape(String string) {
        this.doubleQuoteExcape = string;
        this.props.put("doubleQouteEscape", string);
    }

    public void setFileDriverProfile(File file, String string) {
        this.setJdbcDriverPrefix("jdbc:relique:csv:");
        this.setJdbcDriverName("org.relique.jdbc.csv.CsvDriver");
        this.setSeparator(string);
        String string2 = CoreUtilities.getFileFirstName(file.getName());
        String string3 = file.getParentFile().toString();
        this.xmlFileName = string3 + "\\" + string2 + ".xml";
        this.setJdbcUrl(this.getJdbcDriverPrefix() + string3);
        String string4 = CoreUtilities.getFileExtension(file);
        this.setFileExtension(string4);
        this.setSqlStatement("Select * from " + string2);
    }

    public void setFileExtension(String string) {
        this.fileExtension = string;
        this.props.put("fileExtension", string);
    }

    public void setJdbcDriverName(String string) {
        this.jdbcDriverName = string;
    }

    public void setJdbcDriverPrefix(String string) {
        this.jdbcDriverPrefix = string;
    }

    public void setJdbcUrl(String string) {
        this.jdbcUrl = string;
    }

    public void setLineBreakEscape(String string) {
        this.lineBreakEscape = string;
        this.props.put("lineBreakEscape", string);
    }

    public void setMaxFileSize(long l) {
        this.maxFileSize = l;
    }

    public void setPassword(String string) {
        this.password = string;
        this.props.put("password", string);
    }

    public void setSeparator(String string) {
        this.separator = string.charAt(0);
        this.props.put("separator", string);
    }

    public void setSqlStatement(String string) {
        this.sqlStatement = string;
    }

    public void setUsername(String string) {
        this.username = string;
        this.props.put("username", string);
    }
}

