/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog.iface.junit;

import com.luna.insight.core.catalog.CatalogTemplate;
import com.luna.insight.core.catalog.TemplateEntityField;
import com.luna.insight.core.catalog.TemplateEntityType;
import com.luna.insight.core.catalog.iface.BaseEntityField;
import com.luna.insight.core.catalog.iface.BaseEntityType;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class BaseTemplateTester
extends TestCase {
    CatalogTemplate template = null;
    BaseEntityType type1 = null;
    BaseEntityType type2 = null;
    BaseEntityField field1 = null;
    BaseEntityField field2 = null;
    String templateName = "Test Template.";

    protected void setUp() throws Exception {
        super.setUp();
        this.template = new CatalogTemplate(this.templateName);
    }

    private void createTemplateElements() {
        this.type1 = TemplateEntityType.createTemplateEntityType(this.template, "type1");
        this.field1 = TemplateEntityField.createTemplateEntityfield(this.template, BaseEntityField.SHORT_TEXT, "field1");
        this.type2 = TemplateEntityType.createTemplateEntityType(this.template, "type2");
        this.field2 = TemplateEntityField.createTemplateEntityfield(this.template, BaseEntityField.NUMERIC, "field2");
    }

    private void setTemplateStructure() {
        this.field1.setParentEntityType(this.type1);
        this.template.setPrimaryEntityType(this.type1);
        this.field2.setParentEntityType(this.type2);
        this.type2.setParentEntityType(this.template.getPrimaryEntityType());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBaseTemplate() {
        BaseTemplateTester.assertEquals((String)this.templateName, (String)this.template.getTemplateName());
    }

    public void testGetTemplateID() {
        BaseTemplateTester.assertEquals((int)this.template.getTemplateID(), (int)-1);
    }

    public void testSetTemplateID() {
        this.template.setTemplateID(20);
        BaseTemplateTester.assertEquals((int)this.template.getTemplateID(), (int)20);
    }

    public void testGetTemplateName() {
        this.testBaseTemplate();
    }

    public void testGetVersion() {
        BaseTemplateTester.assertNull((Object)this.template.getVersion());
    }

    public void testSetVersion() {
        this.template.setVersion("test");
        BaseTemplateTester.assertEquals((String)this.template.getVersion(), (String)"test");
    }

    public void testGetVersionInfo() {
        BaseTemplateTester.assertEquals((String)this.template.getVersionInfo(), (String)"");
    }

    public void testSetVersionInfo() {
        this.template.setVersionInfo(null);
        this.testGetVersionInfo();
        this.template.setVersionInfo("test");
        BaseTemplateTester.assertEquals((String)this.template.getVersionInfo(), (String)"test");
    }

    public void testGetDescriptionURL() {
        BaseTemplateTester.assertEquals((String)this.template.getDescriptionURL(), (String)"");
    }

    public void testSetDescriptionURL() {
        this.template.setDescriptionURL(null);
        this.testGetDescriptionURL();
        this.template.setDescriptionURL("test");
        BaseTemplateTester.assertEquals((String)this.template.getDescriptionURL(), (String)"test");
    }

    public void testGetCreatorID() {
        BaseTemplateTester.assertEquals((int)this.template.getCreatorID(), (int)0);
    }

    public void testSetCreatorID() {
        this.template.setCreatorID(20);
        BaseTemplateTester.assertEquals((int)this.template.getCreatorID(), (int)20);
    }

    public void testIsPublished() {
        BaseTemplateTester.assertEquals((boolean)false, (boolean)this.template.isPublished());
    }

    public void testSetPublished() {
        this.template.setPublished(true);
        BaseTemplateTester.assertEquals((boolean)true, (boolean)this.template.isPublished());
    }

    public void testIsTemporary() {
        BaseTemplateTester.assertTrue((boolean)this.template.isTemporary());
    }

    public void testSetPersonalCollectionTemplate() {
        this.template.setPersonalCollectionTemplate(true);
        BaseTemplateTester.assertTrue((boolean)this.template.isPersonalCollectionTemplate());
    }

    public void testIsPersonalCollectionTemplate() {
        BaseTemplateTester.assertTrue((!this.template.isPersonalCollectionTemplate() ? 1 : 0) != 0);
    }

    public void testGetPrimaryEntityType() {
        BaseTemplateTester.assertNull((Object)this.template.getPrimaryEntityType());
    }

    public void testSetPrimaryEntityType() {
        TemplateEntityType templateEntityType = TemplateEntityType.createTemplateEntityType(this.template, "test type");
        BaseTemplateTester.assertTrue((String)"Failed to create primary type", (templateEntityType != null ? 1 : 0) != 0);
        TemplateEntityType templateEntityType2 = TemplateEntityType.createTemplateEntityType(this.template, "test type");
        BaseTemplateTester.assertTrue((String)"Created duplicate error types", (templateEntityType2 == null ? 1 : 0) != 0);
        BaseTemplateTester.assertEquals((int)1, (int)this.template.setPrimaryEntityType(templateEntityType2));
        CatalogTemplate catalogTemplate = new CatalogTemplate("other");
        TemplateEntityType templateEntityType3 = TemplateEntityType.createTemplateEntityType(catalogTemplate, "other");
        BaseTemplateTester.assertEquals((int)1, (int)this.template.setPrimaryEntityType(templateEntityType3));
        this.template.setPrimaryEntityType(templateEntityType);
        BaseTemplateTester.assertSame((Object)this.template.getPrimaryEntityType(), (Object)templateEntityType);
        TemplateEntityType templateEntityType4 = TemplateEntityType.createTemplateEntityType(this.template, "other");
        BaseTemplateTester.assertEquals((int)2, (int)this.template.setPrimaryEntityType(templateEntityType4));
    }

    public void testCalculateDisplayOrders() {
    }

    public void testGetLinkedTypes() {
        this.createTemplateElements();
        this.setTemplateStructure();
        Set set = this.template.getLinkedTypes();
        BaseTemplateTester.assertEquals((int)2, (int)set.size());
        BaseTemplateTester.assertTrue((boolean)set.contains(this.type1));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.type2));
    }

    public void testGetLinkedFields() {
        this.createTemplateElements();
        this.setTemplateStructure();
        Set set = this.template.getLinkedFields();
        BaseTemplateTester.assertEquals((int)2, (int)set.size());
        BaseTemplateTester.assertTrue((boolean)set.contains(this.field1));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.field2));
    }

    public void testGetLinkedElements() {
        this.createTemplateElements();
        this.setTemplateStructure();
        Set set = this.template.getLinkedElements();
        BaseTemplateTester.assertEquals((int)4, (int)set.size());
        BaseTemplateTester.assertTrue((boolean)set.contains(this.type1));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.type2));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.field1));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.field2));
    }

    public void testElementStructure() {
        this.createTemplateElements();
        this.setTemplateStructure();
        List list = this.template.getPrimaryEntityType().getElements();
        BaseTemplateTester.assertTrue((boolean)list.get(0).equals(this.field1));
        BaseTemplateTester.assertTrue((boolean)list.get(1).equals(this.type2));
        BaseTemplateTester.assertTrue((boolean)((BaseEntityType)list.get(1)).getElements().get(0).equals(this.field2));
    }

    public void testTemplateCopy() {
        this.createTemplateElements();
        this.setTemplateStructure();
        CatalogTemplate catalogTemplate = CatalogTemplate.createCatalogTemplate(this.template, "CopyTemplate", true);
        BaseTemplateTester.assertNotNull((Object)catalogTemplate);
    }

    public void testRemoveElement() {
        this.createTemplateElements();
        this.setTemplateStructure();
        BaseTemplateTester.assertFalse((boolean)this.template.removeElement(this.type1));
        BaseTemplateTester.assertFalse((boolean)this.template.removeElement(this.type2));
        Set set = this.template.getLinkedElements();
        BaseTemplateTester.assertEquals((int)4, (int)set.size());
        BaseTemplateTester.assertTrue((boolean)set.contains(this.type1));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.type2));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.field1));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.field2));
        BaseTemplateTester.assertTrue((boolean)this.template.removeElement(this.field1));
        BaseTemplateTester.assertTrue((boolean)this.template.removeElement(this.field2));
        set = this.template.getLinkedElements();
        BaseTemplateTester.assertEquals((int)2, (int)set.size());
        BaseTemplateTester.assertTrue((boolean)set.contains(this.type1));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.type2));
        BaseTemplateTester.assertTrue((boolean)this.template.removeElement(this.type2));
        set = this.template.getLinkedElements();
        BaseTemplateTester.assertEquals((int)1, (int)set.size());
        BaseTemplateTester.assertTrue((boolean)set.contains(this.type1));
        BaseTemplateTester.assertFalse((boolean)this.template.removeElement(this.type1));
    }

    public void testGetThumbnailOptionEntityFields() {
        this.createTemplateElements();
        this.setTemplateStructure();
        Set set = this.template.getThumbnailOptionEntityFields();
        BaseTemplateTester.assertEquals((int)2, (int)set.size());
        BaseTemplateTester.assertTrue((boolean)set.contains(this.field1));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.field2));
    }

    public void testGetSortOptionEntityFields() {
        this.createTemplateElements();
        this.setTemplateStructure();
        Set set = this.template.getSortOptionEntityFields();
        BaseTemplateTester.assertEquals((int)2, (int)set.size());
        BaseTemplateTester.assertTrue((boolean)set.contains(this.field1));
        BaseTemplateTester.assertTrue((boolean)set.contains(this.field2));
    }

    public void testGetEntityFieldByName() {
        this.createTemplateElements();
        this.setTemplateStructure();
        BaseTemplateTester.assertSame((Object)this.field1, (Object)this.template.getLinkedEntityFieldByName(this.field1.getName()));
        BaseTemplateTester.assertSame((Object)this.field2, (Object)this.template.getLinkedEntityFieldByName("field2"));
    }

    public void testGetEntityFieldByDisplayName() {
        this.createTemplateElements();
        this.setTemplateStructure();
        BaseTemplateTester.assertSame((Object)this.field1, (Object)this.template.getLinkedEntityFieldByDisplayName(this.field1.getDisplayName()));
        BaseTemplateTester.assertSame((Object)this.field2, (Object)this.template.getLinkedEntityFieldByDisplayName("field2"));
    }

    private void getAndSetThumbnailOrSortFields(boolean bl) {
        boolean bl2;
        this.createTemplateElements();
        this.setTemplateStructure();
        BaseEntityField[] baseEntityFieldArray = bl ? this.template.getThumbnailFields() : this.template.getSortFields();
        BaseTemplateTester.assertEquals((int)4, (int)baseEntityFieldArray.length);
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < baseEntityFieldArray.length; ++i) {
            if (baseEntityFieldArray[i] == this.field1) {
                bl3 = true;
                continue;
            }
            if (baseEntityFieldArray[i] != this.field2) continue;
            bl4 = true;
        }
        BaseTemplateTester.assertTrue((boolean)bl3);
        BaseTemplateTester.assertTrue((boolean)bl4);
        TemplateEntityField templateEntityField = TemplateEntityField.createTemplateEntityfield(this.template, BaseEntityField.LONG_TEXT, "nonthumb");
        templateEntityField.setParentEntityType(this.type2);
        baseEntityFieldArray = bl ? this.template.getThumbnailFields() : this.template.getSortFields();
        BaseTemplateTester.assertEquals((int)4, (int)baseEntityFieldArray.length);
        bl3 = false;
        bl4 = false;
        boolean bl5 = false;
        for (bl2 = false; bl2 < baseEntityFieldArray.length; bl2 += 1) {
            if (baseEntityFieldArray[bl2] == this.field1) {
                bl3 = true;
                continue;
            }
            if (baseEntityFieldArray[bl2] == this.field2) {
                bl4 = true;
                continue;
            }
            if (baseEntityFieldArray[bl2] != templateEntityField) continue;
            bl5 = true;
        }
        BaseTemplateTester.assertTrue((boolean)bl3);
        BaseTemplateTester.assertTrue((boolean)bl4);
        BaseTemplateTester.assertFalse((boolean)bl5);
        if (bl) {
            this.template.setThumbnailFields(new BaseEntityField[]{this.field1, null, null, null});
        } else {
            this.template.setSortFields(new BaseEntityField[]{this.field1, null, null, null});
        }
        baseEntityFieldArray = bl ? this.template.getThumbnailFields() : this.template.getSortFields();
        BaseTemplateTester.assertEquals((int)4, (int)baseEntityFieldArray.length);
        BaseTemplateTester.assertSame((Object)baseEntityFieldArray[0], (Object)this.field1);
        bl2 = false;
        try {
            if (bl) {
                this.template.setThumbnailFields(new BaseEntityField[]{templateEntityField, null, null, null});
            } else {
                this.template.setSortFields(new BaseEntityField[]{templateEntityField, null, null, null});
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl2 = true;
        }
        BaseTemplateTester.assertTrue((boolean)bl2);
    }

    public void testGetAndSetThumbnailFields() {
        this.getAndSetThumbnailOrSortFields(true);
    }

    public void testGetAntSetSortFields() {
        this.getAndSetThumbnailOrSortFields(false);
    }
}

