/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog.iface;

import com.luna.insight.core.catalog.edit.EntityTypeEdit;
import com.luna.insight.core.catalog.iface.BaseEntityField;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.BaseTemplateElement;
import com.luna.insight.core.catalog.iface.IEntityType;
import com.luna.insight.core.catalog.iface.ITemplate;
import com.luna.insight.core.catalog.iface.ITemplateElement;
import com.luna.insight.core.catalog.utils.TemplateCompareException;
import com.luna.insight.core.util.CoreUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class BaseEntityType
extends BaseTemplateElement
implements Serializable,
IEntityType {
    public static final int MAX_ENTITY_ID_COLLUMN_NAME_LENGTH = 50;
    public static final int DEPENDENT_ATTRIBUTE = 0;
    public static final int VOCAB_ATTRIBUTE = 1;
    protected int fieldGroupType = 2;
    protected int restrictionLevel = 0;
    protected boolean isVocabulary = false;
    protected boolean isDependent = false;
    protected boolean isDupeCheckEnabled = false;
    protected boolean isRefCheckEnabled = false;
    protected int tableID = -1;
    protected String entityIDColumnName;
    private List elements = new ArrayList();

    protected BaseEntityType(BaseTemplate baseTemplate, int n, String string, String string2) {
        this.template = baseTemplate;
        this.id = n;
        this.name = string;
        this.displayName = string2;
    }

    public String getEntityIDColumnName() {
        if (this.entityIDColumnName != null) {
            return this.entityIDColumnName;
        }
        String string = this.name;
        if (string.length() > 48) {
            string = string.substring(0, 48);
        }
        return string + "ID";
    }

    public void setEntityIDColumnName(String string) {
        this.entityIDColumnName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getElements() {
        Object object = this.template.getTemplateStructureLock();
        synchronized (object) {
            return Collections.unmodifiableList(this.elements);
        }
    }

    public int getFieldGroupType() {
        return this.fieldGroupType;
    }

    public void setFieldGroupType(int n) {
        this.fieldGroupType = n;
    }

    public int getRestrictionLevel() {
        return this.restrictionLevel;
    }

    public void setRestrictionLevel(int n) {
        this.restrictionLevel = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isVocabulary() {
        Object object = this.template.getTemplateStructureLock();
        synchronized (object) {
            return this.isVocabulary && this.elements.size() == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setVocabulary(boolean bl) {
        Object object = this.template.getTemplateStructureLock();
        synchronized (object) {
            if (this.isVocabularyEligible()) {
                this.isVocabulary = bl;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDependent() {
        Object object = this.template.getTemplateStructureLock();
        synchronized (object) {
            return this.isDependent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean setDependent(boolean bl) {
        Object object = this.template.getTemplateStructureLock();
        synchronized (object) {
            if (this.isDependentEligible()) {
                this.isDependent = bl;
                return true;
            }
            return false;
        }
    }

    public void setDependentImport(boolean bl) {
        this.isDependent = bl;
    }

    public boolean isDupeCheckEnabled() {
        return this.isDupeCheckEnabled;
    }

    public void setDupeCheckEnabled(boolean bl) {
        this.isDupeCheckEnabled = bl;
    }

    public boolean isRefCheckEnabled() {
        return this.isRefCheckEnabled;
    }

    public void setRefCheckEnabled(boolean bl) {
        this.isRefCheckEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isPrimaryType() {
        Object object = this.template.getTemplateStructureLock();
        synchronized (object) {
            return this.template.getPrimaryEntityType() == this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getRelatedEntityTypes() {
        Object object = this.template.getTemplateStructureLock();
        synchronized (object) {
            ArrayList<BaseTemplateElement> arrayList = new ArrayList<BaseTemplateElement>();
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                BaseTemplateElement baseTemplateElement = (BaseTemplateElement)iterator.next();
                if (!(baseTemplateElement instanceof BaseEntityType)) continue;
                arrayList.add(baseTemplateElement);
            }
            return Collections.unmodifiableList(arrayList);
        }
    }

    private final int addRelatedEntityType(int n, BaseEntityType baseEntityType) {
        if (this.template.getPrimaryEntityType() == null) {
            return 11;
        }
        if (this.isVocabulary()) {
            return 3;
        }
        BaseEntityType baseEntityType2 = this;
        do {
            if (baseEntityType2 != baseEntityType) continue;
            return 5;
        } while (null != (baseEntityType2 = baseEntityType2.parentType));
        if (this.isDependent() && baseEntityType.isDependent()) {
            return 6;
        }
        if (baseEntityType.parentType == null || baseEntityType.parentType != this) {
            baseEntityType.previousParentType = baseEntityType.parentType;
            baseEntityType.parentType = this;
            this.elements.add(n, baseEntityType);
            this.template.linkedTypes.add(baseEntityType);
            return 0;
        }
        baseEntityType.previousParentType = null;
        int n2 = this.elements.indexOf(baseEntityType);
        if (n != n2) {
            this.elements.remove(n2);
            this.elements.add(n, baseEntityType);
        }
        return 0;
    }

    private final int addEntityField(int n, BaseEntityField baseEntityField) {
        if (this.isVocabulary()) {
            return 13;
        }
        if (baseEntityField.parentType == null || baseEntityField.parentType != this) {
            baseEntityField.previousParentType = baseEntityField.parentType;
            baseEntityField.parentType = this;
            this.elements.add(n, baseEntityField);
            this.template.linkedFields.add(baseEntityField);
            return 0;
        }
        baseEntityField.previousParentType = null;
        int n2 = this.elements.indexOf(baseEntityField);
        if (n != n2) {
            this.elements.remove(n2);
            this.elements.add(n, baseEntityField);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getEntityFields() {
        Object object = this.template.getTemplateStructureLock();
        synchronized (object) {
            ArrayList<BaseTemplateElement> arrayList = new ArrayList<BaseTemplateElement>();
            Iterator iterator = this.elements.iterator();
            while (iterator.hasNext()) {
                BaseTemplateElement baseTemplateElement = (BaseTemplateElement)iterator.next();
                if (!(baseTemplateElement instanceof BaseEntityField)) continue;
                arrayList.add(baseTemplateElement);
            }
            return Collections.unmodifiableList(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDependentEligible() {
        Object object = this.template.getTemplateStructureLock();
        synchronized (object) {
            boolean bl = true;
            if (this.parentType != null) {
                if (this.parentType.isDependent) {
                    bl = false;
                }
                Iterator iterator = this.elements.iterator();
                while (iterator.hasNext() && bl) {
                    BaseTemplateElement baseTemplateElement = (BaseTemplateElement)iterator.next();
                    if (!(baseTemplateElement instanceof BaseEntityType) || !((BaseEntityType)baseTemplateElement).isDependent()) continue;
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }
    }

    public final boolean isVocabularyEligible() {
        return true;
    }

    public int getTableID() {
        return this.tableID;
    }

    public void setTableID(int n) {
        this.tableID = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        Object object = this.template.getTemplateStructureLock();
        synchronized (object) {
            return this.elements.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int addChild(int n, BaseTemplateElement baseTemplateElement) throws IndexOutOfBoundsException {
        Object object = this.getTemplateStructureLock();
        synchronized (object) {
            if (n < 0 || n > this.getSize()) {
                throw new IndexOutOfBoundsException();
            }
            int n2 = 0;
            n2 = baseTemplateElement instanceof BaseEntityType ? this.addRelatedEntityType(n, (BaseEntityType)baseTemplateElement) : (baseTemplateElement instanceof BaseEntityField ? this.addEntityField(n, (BaseEntityField)baseTemplateElement) : 12);
            if (n2 == 0) {
                if (baseTemplateElement.previousParentType != null) {
                    baseTemplateElement.previousParentType.removeElement(baseTemplateElement);
                    if (baseTemplateElement.previousParentType.isVocabulary() && !baseTemplateElement.previousParentType.isVocabularyEligible()) {
                        baseTemplateElement.previousParentType.isVocabulary = false;
                    }
                }
                this.template.displayOrdersUpToDate = false;
            }
            return n2;
        }
    }

    protected final void removeElement(BaseTemplateElement baseTemplateElement) {
        this.elements.remove(baseTemplateElement);
    }

    protected final int calculateDisplayOrders(int n) {
        this.setDisplayOrder(n += 10);
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            BaseTemplateElement baseTemplateElement = (BaseTemplateElement)iterator.next();
            if (baseTemplateElement instanceof BaseEntityField) {
                baseTemplateElement.setDisplayOrder(n += 10);
                continue;
            }
            n = ((BaseEntityType)baseTemplateElement).calculateDisplayOrders(n);
        }
        return n;
    }

    public String toString() {
        ++this.toStringIndentLevel;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[this.toStringIndentLevel * 2];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        stringBuffer.append(cArray);
        if (this.parentType == null) {
            stringBuffer.append("PRIMARY TYPE (" + this.name + ")\n");
        } else {
            stringBuffer.append("CHILD TYPE (" + this.name + " <- " + this.parentType.name + ")\n");
        }
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            BaseTemplateElement baseTemplateElement = (BaseTemplateElement)iterator.next();
            baseTemplateElement.toStringIndentLevel = this.toStringIndentLevel;
            stringBuffer.append(baseTemplateElement);
        }
        stringBuffer.append(cArray).append("END TYPE (" + this.name + ")\n");
        --this.toStringIndentLevel;
        return stringBuffer.toString();
    }

    public void setUnvalidatedAttribute(int n, Object object) {
        switch (n) {
            case 0: {
                this.isDependent = (Boolean)object;
                break;
            }
            case 1: {
                this.isVocabulary = (Boolean)object;
            }
        }
    }

    public List getChangedValues(ITemplate iTemplate, ITemplate iTemplate2, boolean bl, ITemplateElement iTemplateElement) throws TemplateCompareException {
        ArrayList<EntityTypeEdit> arrayList = new ArrayList<EntityTypeEdit>();
        if (iTemplateElement == null || iTemplateElement.getClass().hashCode() != this.getClass().hashCode() || iTemplateElement.getID() != this.getID()) {
            throw new TemplateCompareException("invalid source object");
        }
        BaseEntityType baseEntityType = (BaseEntityType)iTemplateElement;
        EntityTypeEdit entityTypeEdit = new EntityTypeEdit(8, baseEntityType, this);
        if (bl) {
            if (this.getDisplayOrder() != baseEntityType.getDbDisplayOrder()) {
                entityTypeEdit.addChange(0, this.getDisplayOrder());
            }
        } else if (this.getDisplayOrder() != baseEntityType.getDisplayOrder()) {
            entityTypeEdit.addChange(0, this.getDisplayOrder());
        }
        if (!CoreUtilities.isEqual(this.name, baseEntityType.name)) {
            entityTypeEdit.addChange(2, this.name);
        }
        if (!CoreUtilities.isEqual(this.displayName, baseEntityType.displayName)) {
            entityTypeEdit.addChange(1, this.displayName);
        }
        if (this.fieldGroupType != baseEntityType.fieldGroupType) {
            entityTypeEdit.addChange(201, this.fieldGroupType);
        }
        if (this.restrictionLevel != baseEntityType.restrictionLevel) {
            entityTypeEdit.addChange(202, this.restrictionLevel);
        }
        if (this.isVocabulary != baseEntityType.isVocabulary) {
            entityTypeEdit.addChange(203, this.isVocabulary);
        }
        if (this.isDependent != baseEntityType.isDependent) {
            entityTypeEdit.addChange(204, this.isDependent);
        }
        if (this.isDupeCheckEnabled != baseEntityType.isDupeCheckEnabled) {
            entityTypeEdit.addChange(205, this.isDupeCheckEnabled);
        }
        if (this.isRefCheckEnabled != baseEntityType.isRefCheckEnabled) {
            entityTypeEdit.addChange(206, this.isRefCheckEnabled);
        }
        if (this.tableID != baseEntityType.tableID) {
            entityTypeEdit.addChange(207, this.tableID);
        }
        if (!CoreUtilities.isEqual(this.entityIDColumnName, baseEntityType.entityIDColumnName)) {
            entityTypeEdit.addChange(208, this.entityIDColumnName);
        }
        if (entityTypeEdit.getPropertyChanges() != null) {
            arrayList.add(entityTypeEdit);
        }
        if (this.parentType != null && ((BaseTemplateElement)iTemplateElement).parentType != null && this.parentType.getID() != ((BaseTemplateElement)iTemplateElement).parentType.getID()) {
            arrayList.add(new EntityTypeEdit(6, baseEntityType, this));
        }
        return arrayList;
    }
}

