/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.mip.FuzzyDateMachine;

import edu.berkeley.mip.FuzzyDateMachine.Controller;
import edu.berkeley.mip.FuzzyDateMachine.FzStringReader;
import edu.berkeley.mip.FuzzyDateMachine.JulianPair;
import edu.berkeley.mip.FuzzyDateMachine.SqlFuzzyDate;
import edu.berkeley.mip.FuzzyDateMachine.Yylex;
import edu.berkeley.mip.FuzzyDateMachine.parser;
import java_cup.runtime.Symbol;

public class SybEngine {
    static parser theParser = new parser();
    static Controller theController = Controller.getInstance();

    private SybEngine() {
    }

    public static boolean contains(JulianPair julianPair, JulianPair julianPair2) {
        return theController.contains(julianPair, julianPair2);
    }

    public static boolean contains(JulianPair julianPair, SqlFuzzyDate sqlFuzzyDate) {
        return theController.contains(julianPair, sqlFuzzyDate);
    }

    public static boolean contains(SqlFuzzyDate sqlFuzzyDate, JulianPair julianPair) {
        return theController.contains(sqlFuzzyDate, julianPair);
    }

    public static boolean contains(SqlFuzzyDate sqlFuzzyDate, SqlFuzzyDate sqlFuzzyDate2) {
        return theController.contains(sqlFuzzyDate, sqlFuzzyDate2);
    }

    public static void eval(String string) {
        try {
            System.err.println("eval... " + string);
            JulianPair julianPair = SybEngine.getJulianPair(string);
            if (julianPair != null) {
                System.err.println("got Fuzzy date: " + string + " start: " + julianPair.startJulian + " end: " + julianPair.endJulian);
            } else {
                System.err.println("parser returned null for: " + string);
            }
        }
        catch (Exception exception) {
            theParser.done_parsing();
            System.err.println("parse failed for: " + string);
            System.err.println("Exception is: " + exception.getClass().getName());
            System.err.println("msg is: " + exception);
            exception.printStackTrace();
        }
    }

    public static synchronized SqlFuzzyDate getFuzzyDate(String string) throws Exception {
        JulianPair julianPair = SybEngine.getJulianPair(string);
        return new SqlFuzzyDate(string, julianPair.startJulian, julianPair.endJulian);
    }

    public static synchronized int[] getFuzzyDateValues(String string) throws Exception {
        int[] nArray = new int[2];
        JulianPair julianPair = SybEngine.getJulianPair(string);
        nArray[0] = julianPair.startJulian;
        nArray[1] = julianPair.endJulian;
        return nArray;
    }

    public static synchronized JulianPair getJulianPair(String string) throws Exception {
        FzStringReader fzStringReader = null;
        try {
            fzStringReader = new FzStringReader(string);
        }
        catch (Exception exception) {
            System.err.println("Couldn't make stringreader: " + exception);
            return null;
        }
        Yylex yylex = null;
        try {
            yylex = new Yylex(fzStringReader);
        }
        catch (Exception exception) {
            System.err.println("Couldn't make lexer: " + exception);
            return null;
        }
        try {
            theParser.setScanner(yylex);
        }
        catch (Exception exception) {
            System.err.println("Couldn't setScanner(): " + exception);
            return null;
        }
        try {
            Symbol symbol2 = theParser.parse();
            JulianPair julianPair = theParser.getJulianPair();
            if (julianPair != null) {
                return julianPair;
            }
            throw new Exception("parser returned null for: " + string);
        }
        catch (Exception exception) {
            theParser.done_parsing();
            throw new Exception("parse failed for: " + string);
        }
    }

    public static boolean intersects(JulianPair julianPair, JulianPair julianPair2) {
        return theController.intersects(julianPair, julianPair2);
    }

    public static boolean intersects(JulianPair julianPair, SqlFuzzyDate sqlFuzzyDate) {
        return theController.intersects(julianPair, sqlFuzzyDate);
    }

    public static boolean intersects(SqlFuzzyDate sqlFuzzyDate, JulianPair julianPair) {
        return theController.intersects(sqlFuzzyDate, julianPair);
    }

    public static boolean intersects(SqlFuzzyDate sqlFuzzyDate, SqlFuzzyDate sqlFuzzyDate2) {
        return theController.intersects(sqlFuzzyDate, sqlFuzzyDate2);
    }
}

