/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.usergroup;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.usergroup.IPAddressRangeElement;
import java.util.StringTokenizer;
import java.util.Vector;

public class IPAddressCollection {
    public static final String ALL_IP_ADDRESSES = "0.0.0.0 - 255.255.255.255";
    public Vector validRanges = new Vector();

    public IPAddressCollection(String string) {
        if (string != null) {
            this.parseIntoRangeElements(string);
        } else {
            IPAddressCollection.debugOut("In constructor, range value given is NULL.");
        }
    }

    public void parseIntoRangeElements(String string) {
        this.validRanges = IPAddressCollection.getParsedRangeElements(string);
    }

    private static Vector getParsedRangeElements(String string) {
        Vector<IPAddressRangeElement> vector = new Vector<IPAddressRangeElement>();
        StringTokenizer stringTokenizer = new StringTokenizer(InsightUtilities.removeAllWhiteSpace(string), ",");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "-");
                String string2 = null;
                String string3 = null;
                try {
                    string2 = stringTokenizer2.nextToken();
                }
                catch (Exception exception) {
                    string2 = null;
                }
                try {
                    string3 = stringTokenizer2.nextToken();
                }
                catch (Exception exception) {
                    string3 = null;
                }
                vector.addElement(new IPAddressRangeElement(string2, string3));
            }
        }
        catch (Exception exception) {
            IPAddressCollection.debugOut("Exception in parseIntoRangeElements(): " + exception);
            vector = null;
        }
        return vector;
    }

    public static boolean isValidIPAddressRangeList(String string) {
        return IPAddressCollection.getParsedRangeElements(string) != null;
    }

    public boolean isIPAddressInRange(String string) {
        if (this.validRanges == null) {
            return false;
        }
        for (int i = 0; i < this.validRanges.size(); ++i) {
            IPAddressRangeElement iPAddressRangeElement = (IPAddressRangeElement)this.validRanges.elementAt(i);
            if (!iPAddressRangeElement.isIPAddressInRange(string)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(IPAddressCollection iPAddressCollection) {
        if (iPAddressCollection == null) {
            return false;
        }
        if (iPAddressCollection.validRanges == null && this.validRanges != null) {
            return false;
        }
        if (iPAddressCollection.validRanges == null && this.validRanges == null) {
            return true;
        }
        if (iPAddressCollection.validRanges != null && this.validRanges != null && iPAddressCollection.validRanges.size() == this.validRanges.size()) {
            for (int i = 0; i < this.validRanges.size(); ++i) {
                IPAddressRangeElement iPAddressRangeElement;
                IPAddressRangeElement iPAddressRangeElement2 = (IPAddressRangeElement)this.validRanges.elementAt(i);
                if (iPAddressRangeElement2.equals(iPAddressRangeElement = (IPAddressRangeElement)iPAddressCollection.validRanges.elementAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "";
        try {
            if (this.validRanges != null && this.validRanges.size() > 0) {
                for (int i = 0; i < this.validRanges.size(); ++i) {
                    if (i > 0) {
                        string = string + ", ";
                    }
                    string = string + (IPAddressRangeElement)this.validRanges.elementAt(i);
                }
            }
        }
        catch (Exception exception) {
            IPAddressCollection.debugOut("Exception in toString(): " + exception);
            string = null;
        }
        if (string == null || string.length() == 0) {
            string = "IPAddressCollection: Ranges not valid.";
        }
        return string;
    }

    protected static void debugOut(String string) {
        Debug.debugOut("IPAddressCollection: " + string);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("IPAddressRangeElement: " + string, n);
    }
}

