/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mvi;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.mvi.MultiviewImageSlide;
import java.io.Serializable;
import java.util.Vector;

public class MultiviewImageSeries
implements Serializable,
Cloneable,
CollectionKey {
    static final long serialVersionUID = 1162509076581008237L;
    protected int seriesID = 0;
    protected int groupID = 0;
    protected Vector slides = new Vector();
    protected boolean readOnly = false;
    protected boolean changes = false;

    public MultiviewImageSeries(int n) {
        this.groupID = n;
    }

    public static void debugOut(String string) {
        MultiviewImageSeries.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MVISeries: " + string, n);
    }

    public Object clone() {
        return InsightUtilities.deepCopy(this);
    }

    public int getSeriesID() {
        return this.seriesID;
    }

    public void setSeriesID(int n) {
        this.seriesID = n;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public void setGroupID(int n) {
        this.groupID = n;
    }

    public long getObjectID() {
        MultiviewImageSlide multiviewImageSlide = this.getFirstImage();
        if (multiviewImageSlide != null) {
            return multiviewImageSlide.getObjectID();
        }
        return -1L;
    }

    public long getImageID() {
        MultiviewImageSlide multiviewImageSlide = this.getFirstImage();
        if (multiviewImageSlide != null) {
            return multiviewImageSlide.getImageID();
        }
        return -1L;
    }

    public Vector getSlides() {
        return this.slides;
    }

    public void addMultiviewImageSlide(MultiviewImageSlide multiviewImageSlide) {
        this.slides.addElement(multiviewImageSlide);
    }

    public MultiviewImageSlide getFirstImage() {
        if (this.slides != null && this.slides.size() > 0) {
            return (MultiviewImageSlide)this.slides.firstElement();
        }
        return null;
    }

    public void setFirstImage(MultiviewImageSlide multiviewImageSlide) {
        this.slides.insertElementAt(multiviewImageSlide, 0);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean hasChanged() {
        return this.changes;
    }

    public void changed() {
        this.changes = true;
    }

    public void setChanges(boolean bl) {
        this.changes = bl;
    }

    public void trimToSize() {
        if (this.slides != null) {
            this.slides.trimToSize();
        }
    }

    public void removeSlide(MultiviewImageSlide multiviewImageSlide) {
        this.slides.removeElement(multiviewImageSlide);
        for (int i = 0; i < this.slides.size(); ++i) {
            MultiviewImageSlide multiviewImageSlide2 = (MultiviewImageSlide)this.slides.elementAt(i);
            for (int j = 0; j < 4; ++j) {
                if (multiviewImageSlide2.getSlide(j) != multiviewImageSlide) continue;
                multiviewImageSlide2.setSlide(null, j);
            }
        }
    }

    public String getInstitutionID() {
        MultiviewImageSlide multiviewImageSlide = this.getFirstImage();
        if (multiviewImageSlide != null) {
            return multiviewImageSlide.getInstitutionID();
        }
        return "";
    }

    public String getCollectionID() {
        MultiviewImageSlide multiviewImageSlide = this.getFirstImage();
        if (multiviewImageSlide != null) {
            return multiviewImageSlide.getCollectionID();
        }
        return "";
    }

    public String getVCID() {
        MultiviewImageSlide multiviewImageSlide = this.getFirstImage();
        if (multiviewImageSlide != null) {
            return multiviewImageSlide.getVCID();
        }
        return "NA";
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }
}

