/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.mvi;

import com.luna.insight.server.Debug;
import com.luna.insight.server.io.InsightPkgRemoverOutputStream;
import com.luna.insight.server.io.InsightPkgSetterInputStream;
import com.luna.insight.server.mvi.MultiviewImageSeries;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public class MultiviewImageFileManager
implements FilenameFilter {
    public static final String COMPONENT_NAME = "MultiviewImageFileManager";
    public static final String COMPONENT_CODE = "MVIFM";
    public static final String MVI_FILE_EXT = "mvi";
    public static final String GROUP_PREFIX = "Group-";
    public static final String IMAGE_PREFIX = "Image-";
    public static final String SERIES_PREFIX = "MviSeries-";
    protected String mviFilePath = "Multi-View-Image-Files";

    public MultiviewImageFileManager(String string) {
        if (string != null) {
            this.mviFilePath = string;
        }
    }

    public Vector getMviSerieses(int n) {
        this.debugOut("in getMviSerieses().");
        Vector<MultiviewImageSeries> vector = new Vector<MultiviewImageSeries>();
        String string = this.getDirectoryPath(n);
        this.debugOut("Retrieving available mvi serieses for " + string);
        File file = new File(string);
        String[] stringArray = file.list(this);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                MultiviewImageSeries multiviewImageSeries;
                String string2 = stringArray[i];
                if (!string2.endsWith(".mvi") || (multiviewImageSeries = this.getMultiviewImage(string + string2)) == null) continue;
                vector.addElement(multiviewImageSeries);
            }
        }
        return vector;
    }

    public MultiviewImageSeries getMultiviewImage(int n, long l, int n2) {
        this.debugOut("in getMviSeries().");
        String string = this.getFilePath(n, l, n2);
        return this.getMultiviewImage(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public MultiviewImageSeries getMultiviewImage(String string) {
        MultiviewImageSeries multiviewImageSeries;
        block12: {
            multiviewImageSeries = null;
            this.debugOut("Finding file at " + string);
            File file = new File(string);
            if (file.exists()) {
                FileInputStream fileInputStream = null;
                fileInputStream = new FileInputStream(file);
                InsightPkgSetterInputStream insightPkgSetterInputStream = new InsightPkgSetterInputStream(fileInputStream);
                multiviewImageSeries = (MultiviewImageSeries)insightPkgSetterInputStream.readObject();
                insightPkgSetterInputStream.close();
                fileInputStream.close();
                Object var7_7 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    break block12;
                }
                catch (IOException iOException) {}
                break block12;
                {
                    catch (Exception exception) {
                        this.debugOut("Exception in getMultiviewImage(): " + exception);
                        Object var7_8 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            break block12;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return multiviewImageSeries;
    }

    public boolean saveMultiviewImage(MultiviewImageSeries multiviewImageSeries) {
        return this.saveMultiviewImage(multiviewImageSeries, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveMultiviewImage(MultiviewImageSeries multiviewImageSeries, boolean bl) {
        Object object;
        Object object2;
        this.debugOut("in saveMultiviewImage().");
        int n = 0;
        String string = this.getFilePath(multiviewImageSeries.getGroupID(), multiviewImageSeries.getImageID(), n);
        File file = new File(string);
        if (file.exists()) {
            if (!bl) return false;
            file.delete();
        } else {
            object2 = this.getDirectoryPath(multiviewImageSeries.getGroupID());
            object = new File((String)object2);
            ((File)object).mkdirs();
        }
        try {
            object2 = new FileOutputStream(file);
            object = InsightPkgRemoverOutputStream.getInstance((OutputStream)object2);
            multiviewImageSeries.setChanges(false);
            ((ObjectOutputStream)object).writeObject(multiviewImageSeries);
            ((ObjectOutputStream)object).close();
            ((FileOutputStream)object2).close();
            return file.exists();
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveMultiviewImage(): " + exception);
            return false;
        }
    }

    public boolean deleteMultiviewImage(int n, long l, int n2) {
        return this.deleteMultiviewImage(n, l, n2, true);
    }

    public boolean deleteMultiviewImage(int n, long l, int n2, boolean bl) {
        this.debugOut("in deleteMultiviewImage().");
        String string = this.getFilePath(n, l, n2);
        this.debugOut("Finding file at " + string);
        File file = new File(string);
        if (file.exists() && !bl) {
            return false;
        }
        boolean bl2 = file.delete();
        if (bl2) {
            this.debugOut(string + " successfully deleted.");
        } else {
            this.debugOut(string + " not deleted.");
        }
        return bl2;
    }

    public void copyMultiviewImages(int n, int n2) {
        String string = this.getDirectoryPath(n);
        File file = new File(string);
        String[] stringArray = file.list(this);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                MultiviewImageSeries multiviewImageSeries;
                String string2 = stringArray[i];
                if (!string2.endsWith(".mvi") || (multiviewImageSeries = this.getMultiviewImage(string + string2)) == null) continue;
                multiviewImageSeries.setGroupID(n2);
                this.saveMultiviewImage(multiviewImageSeries);
            }
        }
    }

    public void deleteAllMultiviewImages(int n) {
        String string = this.getDirectoryPath(n);
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string + stringArray[i]);
                file2.delete();
            }
        }
        file.delete();
    }

    public boolean accept(File file, String string) {
        return string != null && string.endsWith(".mvi");
    }

    protected String getDirectoryPath(int n) {
        return this.mviFilePath + File.separator + this.getGroupHeader(n) + File.separator;
    }

    protected String getFilePath(int n, long l, int n2) {
        return this.getDirectoryPath(n) + this.getImageHeader(l) + "-" + this.getSeriesHeader(n2) + "." + MVI_FILE_EXT;
    }

    protected String getGroupHeader(int n) {
        return GROUP_PREFIX + n;
    }

    protected String getImageHeader(long l) {
        return IMAGE_PREFIX + l;
    }

    protected String getSeriesHeader(int n) {
        return SERIES_PREFIX + n;
    }

    protected synchronized void debugOut(String string) {
        Debug.debugOut("MVIFM: " + string, 2);
    }

    protected synchronized void debugOut(String string, int n) {
        Debug.debugOut("MVIFM: " + string, n);
    }
}

