/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.links;

import com.luna.insight.server.Debug;
import com.luna.insight.server.MutableInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LinkInventoryTracker {
    protected Hashtable inventory = new Hashtable();

    public static void debugOut(String string) {
        LinkInventoryTracker.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("LinkInventoryTracker: " + string, n);
    }

    public boolean isInInventory(String string) {
        if (string == null) {
            return false;
        }
        return this.inventory.containsKey(string);
    }

    public void addToInventory(String string, int n) {
        if (string != null) {
            MutableInteger mutableInteger = (MutableInteger)this.inventory.get(string);
            if (mutableInteger == null) {
                mutableInteger = new MutableInteger();
                this.inventory.put(string, mutableInteger);
            }
            mutableInteger.addToValue(n);
        }
    }

    public void removeFromInventory(String string, int n) {
        MutableInteger mutableInteger;
        if (string != null && (mutableInteger = (MutableInteger)this.inventory.get(string)) != null) {
            mutableInteger.addToValue(-1 * n);
        }
    }

    public void wipeFromInventory(String string) {
        if (string != null) {
            this.inventory.remove(string);
        }
    }

    public Vector getLinkCodesWithFragment(String string) {
        Vector<String> vector = new Vector<String>();
        if (string != null) {
            Enumeration enumeration = this.inventory.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.indexOf(string) <= -1) continue;
                vector.addElement(string2);
            }
        }
        return vector;
    }

    public void wipeFromInventoryByFragment(String string) {
        if (string != null) {
            Vector vector = this.getLinkCodesWithFragment(string);
            for (int i = 0; i < vector.size(); ++i) {
                this.wipeFromInventory((String)vector.elementAt(i));
            }
        }
    }
}

