/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.links;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyDistributor;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.links.LinkAuthorshipInfo;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class LinkData
implements Serializable,
CollectionKey {
    static final long serialVersionUID = 311351730724317057L;
    public static final int COLLECTION = 0;
    public static final int USER_GROUP = 1;
    public static final int LOCAL_DISK = 2;
    public String institutionID;
    public String collectionID;
    public String vcID;
    public long objectIDLong;
    public long imageID;
    public Rectangle region = null;
    public Color color = null;
    public int saveLocation = 0;
    public String groupName = null;
    public String groupCodeKey = null;
    public LinkAuthorshipInfo authorshipInfo = null;
    protected String groupSignature = null;
    private int objectID = 0;

    public LinkData() {
    }

    public LinkData(CollectionKey collectionKey, long l, long l2) {
        this(collectionKey, l, l2, null, null);
    }

    public LinkData(CollectionKey collectionKey, long l, long l2, Rectangle rectangle) {
        this(collectionKey, l, l2, rectangle, null);
    }

    public LinkData(CollectionKey collectionKey, long l, long l2, Rectangle rectangle, Color color) {
        this(collectionKey, l, l2, rectangle, color, 0, null, null, null);
    }

    public LinkData(CollectionKey collectionKey, long l, long l2, Rectangle rectangle, Color color, int n, String string, String string2, LinkAuthorshipInfo linkAuthorshipInfo) {
        this.collectionID = collectionKey.getCollectionID();
        this.institutionID = collectionKey.getInstitutionID();
        this.vcID = collectionKey.getVCID();
        this.objectIDLong = l;
        this.imageID = l2;
        this.region = rectangle;
        this.color = color;
        this.saveLocation = n;
        this.groupName = string;
        this.groupCodeKey = string2;
        this.authorshipInfo = linkAuthorshipInfo;
    }

    public void setRegion(Rectangle rectangle) {
        this.region = rectangle;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setSaveLocation(int n) {
        this.saveLocation = n;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public void setGroupCodeKey(String string) {
        this.groupCodeKey = string;
    }

    public void setAuthorshipInfo(LinkAuthorshipInfo linkAuthorshipInfo) {
        this.authorshipInfo = linkAuthorshipInfo;
    }

    public void setGroupSignature(String string) {
        this.groupSignature = string;
    }

    public long getObjectID() {
        return this.objectIDLong;
    }

    public long getImageID() {
        return this.imageID;
    }

    public Rectangle getRegion() {
        return this.region;
    }

    public Color getColor() {
        return this.color;
    }

    public int getSaveLocation() {
        return this.saveLocation;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupCodeKey() {
        return this.groupCodeKey;
    }

    public String getGroupSignature() {
        return this.groupSignature;
    }

    public LinkAuthorshipInfo getAuthorshipInfo() {
        if (this.authorshipInfo == null) {
            this.authorshipInfo = new LinkAuthorshipInfo();
        }
        return this.authorshipInfo;
    }

    public boolean equals(Object object) {
        if (object instanceof LinkData) {
            LinkData linkData = (LinkData)object;
            return CollectionKeyDistributor.keysAgree(this, linkData) && this.getObjectID() == linkData.getObjectID() && this.getImageID() == linkData.getImageID() && this.getRegion() != null && linkData.getRegion() != null && this.getRegion().equals(linkData.getRegion());
        }
        return super.equals(object);
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        if (this.vcID == null) {
            this.vcID = "NA";
        }
        return this.vcID;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.objectIDLong == 0L) {
            this.objectIDLong = this.objectID;
        }
    }
}

