/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.io;

import com.luna.insight.server.Debug;
import com.luna.insight.server.io.ClassDescriptionFilter;
import com.luna.insight.server.io.InsightPkgStreamConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class InsightPkgSetterInputStream
extends ObjectInputStream
implements InsightPkgStreamConstants {
    protected boolean readingClassDescriptor = false;
    protected String lastClassName = null;
    protected boolean readingSerialVersionID = false;

    public static void debugOut(String string) {
        InsightPkgSetterInputStream.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("InsightPkgSetterInputStream: " + string, n);
    }

    public InsightPkgSetterInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        this.readingClassDescriptor = true;
        ObjectStreamClass objectStreamClass = super.readClassDescriptor();
        return objectStreamClass;
    }

    public String readUTF() throws IOException {
        String string = super.readUTF();
        if (this.readingClassDescriptor) {
            string = this.lastClassName = ClassDescriptionFilter.getValidClassName(string);
            this.readingClassDescriptor = false;
            this.readingSerialVersionID = true;
        }
        return string;
    }

    public long readLong() throws IOException {
        long l = super.readLong();
        if (this.readingSerialVersionID) {
            this.readingSerialVersionID = false;
            l = ClassDescriptionFilter.getSerialVersionUID(this.lastClassName, l);
            InsightPkgSetterInputStream.debugOut("Class " + this.lastClassName + " serialVersionUID: " + l);
        }
        return l;
    }
}

