/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.io.Serializable;
import java.util.Hashtable;

public class MedePrivileges
implements Serializable {
    static final long serialVersionUID = 3824177613634569319L;
    public static final int ENTITY_READ = 1;
    public static final int ENTITY_EDIT = 3;
    public static final int ENTITY_ADD = 5;
    public static final int ENTITY_DELETE = 9;
    public static final int ENTITY_TO_ENTITY_MAPPING = 17;
    public static final int ENTITY_TO_MEDIA_MAPPING = 33;
    public static final int MEDIA_PROCESSING = 65;
    public static final int VC_EDIT = 128;
    public static final String APPROVAL_LEVEL_KEY = "approval-level";
    public static final String MEDE_USER_ID_KEY = "mede-user-ID";
    public static final String PERMISSIONS_KEY = "permissions";
    protected int approvalLevel = -1;
    protected int medeUserID = -1;
    protected int entityPermissions = 0;
    protected boolean entityRead = false;
    protected boolean entityEdit = false;
    protected boolean entityAdd = false;
    protected boolean entityDelete = false;
    protected boolean entityToEntityMapping = false;
    protected boolean entityToMediaMapping = false;
    protected boolean mediaProcessing = false;
    protected boolean virtualCollectionEdit = false;
    protected int invertedCommitLevel = 100;
    protected int sourceCommitLevel = 100;

    public static void debugOut(String string) {
        MedePrivileges.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MedePrivileges: " + string, n);
    }

    public static boolean hasMedePrivilege(int n, int n2) {
        return (n & n2) == n2;
    }

    public static int removePrivileges(int n, int n2) {
        return n & n - n2;
    }

    public static int addPrivileges(int n, int n2) {
        return n | n2;
    }

    public MedePrivileges() {
    }

    public MedePrivileges(Hashtable hashtable) {
        try {
            this.approvalLevel = (Integer)hashtable.get(APPROVAL_LEVEL_KEY);
            this.medeUserID = (Integer)hashtable.get(MEDE_USER_ID_KEY);
            this.entityPermissions = (Integer)hashtable.get(PERMISSIONS_KEY);
        }
        catch (Exception exception) {
            MedePrivileges.debugOut("Exception constructing MedePrivileges from Hashtable:\n" + InsightUtilities.getStackTrace(exception));
        }
        this.loadPermissions();
    }

    public void loadPermissions() {
        this.loadPermissions(this.entityPermissions);
    }

    public void loadPermissions(int n) {
        this.entityPermissions = n;
        this.entityRead = this.hasEntityPermission(1);
        this.entityEdit = this.hasEntityPermission(3);
        this.entityAdd = this.hasEntityPermission(5);
        this.entityDelete = this.hasEntityPermission(9);
        this.entityToEntityMapping = this.hasEntityPermission(17);
        this.entityToMediaMapping = this.hasEntityPermission(33);
        this.mediaProcessing = this.hasEntityPermission(65);
        this.virtualCollectionEdit = this.hasEntityPermission(128);
    }

    public void updatePermissions() {
        this.entityPermissions = 0;
        if (this.entityRead) {
            this.entityPermissions |= 1;
        }
        if (this.entityEdit) {
            this.entityPermissions |= 3;
        }
        if (this.entityAdd) {
            this.entityPermissions |= 5;
        }
        if (this.entityDelete) {
            this.entityPermissions |= 9;
        }
        if (this.entityToEntityMapping) {
            this.entityPermissions |= 0x11;
        }
        if (this.entityToMediaMapping) {
            this.entityPermissions |= 0x21;
        }
        if (this.mediaProcessing) {
            this.entityPermissions |= 0x41;
        }
        if (this.virtualCollectionEdit) {
            this.entityPermissions |= 0x80;
        }
    }

    public boolean hasEntityPermission(int n) {
        return (this.entityPermissions & n) == n;
    }

    public int getMedeUserID() {
        return this.medeUserID;
    }

    public int getApprovalLevel() {
        return this.approvalLevel;
    }

    public boolean entityReadPriv() {
        return this.entityRead;
    }

    public boolean entityEditPriv() {
        return this.entityEdit;
    }

    public boolean entityAddPriv() {
        return this.entityAdd;
    }

    public boolean entityDeletePriv() {
        return this.entityDelete;
    }

    public boolean entityMapPriv() {
        return this.entityToEntityMapping;
    }

    public boolean entityMediaMapPriv() {
        return this.entityToMediaMapping;
    }

    public boolean mediaProcessingPriv() {
        return this.mediaProcessing;
    }

    public boolean vcEditPriv() {
        return this.virtualCollectionEdit;
    }

    public int getInvertedCommitLevel() {
        return this.invertedCommitLevel;
    }

    public int getSourceCommitLevel() {
        return this.sourceCommitLevel;
    }

    public boolean canSourceCommit() {
        return this.approvalLevel >= this.sourceCommitLevel;
    }

    public boolean canInvertedCommit() {
        return this.approvalLevel >= this.invertedCommitLevel;
    }

    public boolean canFullyCommit() {
        return this.canInvertedCommit() && this.canSourceCommit();
    }

    public void setSourceCommitLevel(int n) {
        this.sourceCommitLevel = n;
    }

    public void setInvertedCommitLevel(int n) {
        this.invertedCommitLevel = n;
    }
}

