/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.SimpleDate;
import com.luna.insight.server.inscribe.Entity;
import com.luna.insight.server.inscribe.EntityFieldChange;
import com.luna.insight.server.inscribe.EntityKey;
import com.luna.insight.server.inscribe.EntityKeyComparer;
import com.luna.insight.server.inscribe.EntityKeyWrapper;
import com.luna.insight.server.inscribe.EntityMapChange;
import com.luna.insight.server.inscribe.EntityMediaMapChange;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class EntityChange
implements EntityKey,
Comparable,
Serializable {
    static final long serialVersionUID = -4227129333438729963L;
    private static long TEMP_CHANGE_ID = -1L;
    public static final int CATEGORY_UNKNOWN = 0;
    public static final int CATEGORY_FIELD_CHANGE = 1;
    public static final int CATEGORY_ENTITY_MAP_CHANGE = 2;
    public static final int CATEGORY_ENTITY_MEDIA_MAP_CHANGE = 3;
    public static final int CATEGORY_ENTITY_DELETE = 4;
    public static final int CATEGORY_ENTITY_IMPORT = 5;
    public static final int CHANGE_TYPE_UNKNOWN = 0;
    public static final int CHANGE_TYPE_NEW = 1;
    public static final int CHANGE_TYPE_DELETED = 2;
    public static final int CHANGE_STATUS_UNKNOWN = 0;
    public static final int CHANGE_STATUS_PENDING = 1;
    public static final int CHANGE_STATUS_REJECTED = 2;
    public static final int CHANGE_STATUS_FULLY_COMMITTED = 3;
    public static final int CHANGE_STATUS_CANCELLED = 4;
    public static final int APPROVAL_LEVEL_IGNORE = 0;
    public static final int APPROVAL_LEVEL_LOWER = 1;
    public static final int APPROVAL_LEVEL_EQUAL = 2;
    protected long changeID;
    protected int changeCategory = 0;
    protected int changeType = 0;
    protected int changeStatus = 1;
    protected int approvalLevel;
    protected boolean invertedDataCommit = false;
    protected boolean sourceDataCommit = false;
    protected int userID;
    protected SimpleDate timestamp;
    protected int entityTypeID;
    protected long entityID;
    protected String institutionID;
    protected String collectionID;
    protected String vcID;
    protected String entityKeyString = null;

    public static void debugOut(String string) {
        EntityChange.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("EntityChange: " + string, n);
    }

    public static boolean isTempChangeID(long l) {
        return l <= 0L;
    }

    public static synchronized long getNextTempChangeID() {
        return TEMP_CHANGE_ID--;
    }

    public static String getChangeCategoryName(int n) {
        switch (n) {
            case 1: {
                return "CATEGORY_FIELD_CHANGE";
            }
            case 2: {
                return "CATEGORY_ENTITY_MAP_CHANGE";
            }
            case 3: {
                return "CATEGORY_ENTITY_MEDIA_MAP_CHANGE";
            }
            case 4: {
                return "CATEGORY_ENTITY_DELETE";
            }
            case 5: {
                return "CATEGORY_ENTITY_IMPORT";
            }
        }
        return "CATEGORY_UNKNOWN";
    }

    public static String getChangeTypeName(int n) {
        switch (n) {
            case 1: {
                return "CHANGE_TYPE_NEW";
            }
            case 2: {
                return "CHANGE_TYPE_DELETED";
            }
        }
        return "CHANGE_TYPE_UNKNOWN";
    }

    public static int getOppositeChangeType(int n) {
        switch (n) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    public static boolean areChangesEquivalent(EntityChange entityChange, EntityChange entityChange2) {
        return entityChange != null && entityChange2 != null && entityChange.getChangeCategory() == entityChange2.getChangeCategory() && entityChange.getChangeType() == entityChange2.getChangeType() && EntityKeyComparer.keysAgree(entityChange, entityChange2, true) && (entityChange instanceof EntityFieldChange && entityChange2 instanceof EntityFieldChange ? ((EntityFieldChange)entityChange).getFieldID() == ((EntityFieldChange)entityChange2).getFieldID() && ((EntityFieldChange)entityChange).getValueChange() != null && ((EntityFieldChange)entityChange2).getValueChange() != null && ((EntityFieldChange)entityChange).getValueChange().equals(((EntityFieldChange)entityChange2).getValueChange()) : (entityChange instanceof EntityMapChange && entityChange2 instanceof EntityMapChange ? ((EntityMapChange)entityChange).getRelatedEntityTypeID() == ((EntityMapChange)entityChange2).getRelatedEntityTypeID() && ((EntityMapChange)entityChange).getRelatedEntityID() == ((EntityMapChange)entityChange2).getRelatedEntityID() : entityChange instanceof EntityMediaMapChange && entityChange2 instanceof EntityMediaMapChange && ((EntityMediaMapChange)entityChange).getMediaID() == ((EntityMediaMapChange)entityChange2).getMediaID()));
    }

    public static boolean areChangesNegating(EntityChange entityChange, EntityChange entityChange2) {
        return entityChange != null && entityChange2 != null && entityChange.getChangeCategory() == entityChange2.getChangeCategory() && entityChange.getChangeType() == EntityChange.getOppositeChangeType(entityChange2.getChangeType()) && EntityKeyComparer.keysAgree(entityChange, entityChange2, true) && (entityChange instanceof EntityFieldChange && entityChange2 instanceof EntityFieldChange ? ((EntityFieldChange)entityChange).getFieldID() == ((EntityFieldChange)entityChange2).getFieldID() && ((EntityFieldChange)entityChange).getValueChange() != null && ((EntityFieldChange)entityChange2).getValueChange() != null && ((EntityFieldChange)entityChange).getValueChange().equals(((EntityFieldChange)entityChange2).getValueChange()) : (entityChange instanceof EntityMapChange && entityChange2 instanceof EntityMapChange ? ((EntityMapChange)entityChange).getRelatedEntityTypeID() == ((EntityMapChange)entityChange2).getRelatedEntityTypeID() && ((EntityMapChange)entityChange).getRelatedEntityID() == ((EntityMapChange)entityChange2).getRelatedEntityID() : entityChange instanceof EntityMediaMapChange && entityChange2 instanceof EntityMediaMapChange && ((EntityMediaMapChange)entityChange).getMediaID() == ((EntityMediaMapChange)entityChange2).getMediaID()));
    }

    public EntityChange(long l, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, long l2, int n6, SimpleDate simpleDate) {
        this.setChangeID(l);
        this.setChangeCategory(n);
        this.setChangeType(n2);
        this.setChangeStatus(n3);
        this.setApprovalLevel(n4);
        this.setInvertedDataCommit(bl);
        this.setSourceDataCommit(bl2);
        this.setEntityTypeID(n5);
        this.setEntityID(l2);
        this.setUserID(n6);
        this.setTimeStamp(simpleDate);
    }

    public void setChangeID(long l) {
        this.changeID = l;
    }

    public void setChangeCategory(int n) {
        this.changeCategory = n;
    }

    public void setChangeType(int n) {
        this.changeType = n;
    }

    public void setChangeStatus(int n) {
        this.changeStatus = n;
    }

    public void setApprovalLevel(int n) {
        this.approvalLevel = n;
    }

    public void setInvertedDataCommit(boolean bl) {
        this.invertedDataCommit = bl;
    }

    public void setSourceDataCommit(boolean bl) {
        this.sourceDataCommit = bl;
    }

    public void setEntityTypeID(int n) {
        this.entityTypeID = n;
        this.entityKeyString = null;
    }

    public void setEntityID(long l) {
        this.entityID = l;
        this.entityKeyString = null;
    }

    public void setUserID(int n) {
        this.userID = n;
    }

    public void setTimeStamp(SimpleDate simpleDate) {
        this.timestamp = simpleDate;
    }

    public long getChangeID() {
        return this.changeID;
    }

    public int getChangeType() {
        return this.changeType;
    }

    public int getChangeStatus() {
        return this.changeStatus;
    }

    public int getApprovalLevel() {
        return this.approvalLevel;
    }

    public boolean isInvertedDataCommit() {
        return this.invertedDataCommit;
    }

    public boolean isSourceDataCommit() {
        return this.sourceDataCommit;
    }

    public int getUserID() {
        return this.userID;
    }

    public SimpleDate getTimeStamp() {
        return this.timestamp;
    }

    public int getChangeCategory() {
        if (this instanceof EntityFieldChange) {
            return 1;
        }
        if (this instanceof EntityMapChange) {
            return 2;
        }
        if (this instanceof EntityMediaMapChange) {
            return 3;
        }
        return this.changeCategory;
    }

    public int getEntityTypeID() {
        return this.entityTypeID;
    }

    public long getEntityID() {
        return this.entityID;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        return this.vcID;
    }

    public String getEntityKeyString() {
        if (InsightUtilities.isEmpty(this.entityKeyString)) {
            this.entityKeyString = EntityKeyWrapper.getEntityKeyString(this);
        }
        return this.entityKeyString;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public void setCollectionKey(CollectionKey collectionKey) {
        if (collectionKey != null) {
            this.institutionID = collectionKey.getInstitutionID();
            this.collectionID = collectionKey.getCollectionID();
            this.vcID = collectionKey.getVCID();
        }
        this.entityKeyString = null;
    }

    public int compareTo(Object object) {
        return this.getEntityKeyString().compareToIgnoreCase(((EntityKey)object).getEntityKeyString());
    }

    public static List removeChangedEntities(List list, List list2) {
        Vector<Entity> vector = new Vector<Entity>();
        for (int i = 0; list != null && i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            boolean bl = false;
            for (int j = 0; list2 != null && j < list2.size() && !bl; ++j) {
                EntityChange entityChange = (EntityChange)list2.get(j);
                if (entityChange.entityTypeID != entity.getEntityTypeID() || entityChange.entityID != entity.getEntityID()) continue;
                bl = true;
            }
            if (bl) continue;
            vector.add(entity);
        }
        return vector;
    }
}

