/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.inscribe;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.CollectionKeyWrapper;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.inscribe.EntityFieldValue;
import com.luna.insight.server.inscribe.EntityKey;
import com.luna.insight.server.inscribe.EntityKeyWrapper;
import com.luna.insight.server.inscribe.EntityType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class Entity
implements EntityKey,
Comparable,
Serializable {
    static final long serialVersionUID = 3892371932470013021L;
    private static long TEMP_ENTITY_ID = -1L;
    public static final int NO_STATUS = 0;
    public static final int STATUS_DELETED = 1;
    protected int entityTypeID;
    protected long entityID;
    protected String institutionID = "";
    protected String collectionID = "";
    protected String vcID = "";
    protected int entityStatus = 0;
    protected Entity parentEntity;
    protected List parentEntities;
    protected EntityType entityType;
    private List fieldValues;
    private List relEntities;
    protected List referenceObjs;
    protected String entityKeyString = null;

    public static void debugOut(String string) {
        Entity.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("Entity: " + string, n);
    }

    public static boolean isTempEntityID(long l) {
        return l <= 0L;
    }

    public static synchronized long getNextTempEntityID() {
        return TEMP_ENTITY_ID--;
    }

    public static EntityKey getEntityKey(List list, int n, long l) {
        for (int i = 0; list != null && i < list.size(); ++i) {
            EntityKey entityKey = (EntityKey)list.get(i);
            if (entityKey == null || entityKey.getEntityTypeID() != n || entityKey.getEntityID() != l) continue;
            return entityKey;
        }
        return null;
    }

    public static Entity getEntity(List list, EntityKey entityKey) {
        if (entityKey != null) {
            return Entity.getEntity(list, entityKey.getEntityTypeID(), entityKey.getEntityID());
        }
        return null;
    }

    public static Entity getEntity(List list, int n, long l) {
        for (int i = 0; list != null && i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || entity.getEntityTypeID() != n || entity.getEntityID() != l) continue;
            return entity;
        }
        return null;
    }

    public static List getFlatEntityList(List list) {
        Vector vector = new Vector(1);
        for (int i = 0; list != null && i < list.size(); ++i) {
            ((Entity)list.get(i)).getEntityList(vector);
        }
        return vector;
    }

    public static Entity copyEntityDeep(Entity entity) {
        Entity entity2 = null;
        if (entity != null) {
            entity2 = (Entity)InsightUtilities.deepCopy(entity);
        }
        return entity2;
    }

    public static Entity copyEntityShallow(Entity entity) {
        Entity entity2 = null;
        if (entity != null) {
            entity2 = new Entity(entity);
            entity2.setEntityStatus(entity.getEntityStatus());
            entity2.setEntityType(entity.getEntityType());
            entity2.setFieldValues((List)InsightUtilities.deepCopy(entity.getFieldValues()));
            entity2.setRelatedEntities(entity.getRelatedEntities() != null ? new Vector(entity.getRelatedEntities()) : null);
        }
        return entity2;
    }

    public static List getUniqueEntityKeyList(List list) {
        ArrayList<Object> arrayList = null;
        if (list != null) {
            HashMap<String, EntityKey> hashMap = new HashMap<String, EntityKey>();
            for (int i = 0; list != null && i < list.size(); ++i) {
                EntityKey entityKey = (EntityKey)list.get(i);
                if (entityKey == null) continue;
                hashMap.put(entityKey.getEntityKeyString(), entityKey);
            }
            arrayList = !hashMap.isEmpty() ? new ArrayList(hashMap.values()) : new ArrayList();
        }
        return arrayList;
    }

    public static String displayEntity(Entity entity) {
        StringBuffer stringBuffer = new StringBuffer();
        Entity.displayEntity(entity, stringBuffer, 0);
        return stringBuffer.toString();
    }

    public static void displayEntity(Entity entity, StringBuffer stringBuffer, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        if (entity == null) {
            stringBuffer.append("\n" + string + "[null]");
        } else {
            stringBuffer.append("\n" + string + "[ETID: " + entity.getEntityTypeID() + ", EID: " + entity.getEntityID() + "]");
            string = string + "\t";
            List list = entity.getFieldValues();
            for (int i = 0; list != null && i < list.size(); ++i) {
                EntityFieldValue entityFieldValue = (EntityFieldValue)list.get(i);
                stringBuffer.append("\n" + string + entityFieldValue.getFieldID() + (entityFieldValue.getField() == null ? "" : "-" + entityFieldValue.getField().fieldDisplayName) + ": ");
                for (int j = 0; j < entityFieldValue.getValues().size(); ++j) {
                    stringBuffer.append("\n" + string + "   " + entityFieldValue.getValues().get(j));
                }
            }
            List list2 = entity.getRelatedEntities();
            for (int i = 0; list2 != null && i < list2.size(); ++i) {
                Entity entity2 = (Entity)list2.get(i);
                Entity.displayEntity(entity2, stringBuffer, n + 1);
            }
        }
    }

    public static void main(String[] stringArray) {
        Debug.setDebugLevel(3);
        for (int i = 0; i < 100; ++i) {
            Entity.debugOut("getNextTempEntityID(): " + Entity.getNextTempEntityID());
        }
    }

    public Entity(int n, long l) {
        this.entityTypeID = n;
        this.entityID = l;
    }

    public Entity(EntityKey entityKey) {
        this.entityTypeID = entityKey.getEntityTypeID();
        this.entityID = entityKey.getEntityID();
        this.setCollectionKey(entityKey);
    }

    public boolean containsRelatedEntity(Entity entity) {
        if (entity != null && this.equals(entity)) {
            return true;
        }
        for (int i = 0; this.relEntities != null && i < this.relEntities.size(); ++i) {
            if (!((Entity)this.relEntities.get(i)).containsRelatedEntity(entity)) continue;
            return true;
        }
        return false;
    }

    public void addFieldValue(int n, String string) {
        this.getFieldValue(n, true).addValue(string);
    }

    public void addFieldValue(Field field, String string) {
        if (field != null) {
            EntityFieldValue entityFieldValue = this.getFieldValue(field.fieldID, true);
            entityFieldValue.setField(field);
            entityFieldValue.addValue(string);
        }
    }

    public Entity addRelatedEntity(Entity entity) {
        if (entity != null && !this.equals(entity)) {
            if (this.relEntities == null) {
                this.relEntities = new Vector(1);
            }
            if (!this.relEntities.contains(entity)) {
                this.relEntities.add(entity);
                entity.setParentEntity(this);
                entity.addParentEntity(this);
            }
        }
        return entity;
    }

    public void addParentEntity(Entity entity) {
        if (entity != this && !this.equals(entity)) {
            if (this.parentEntities == null) {
                this.parentEntities = new Vector(1);
            }
            if (!this.parentEntities.contains(entity)) {
                this.parentEntities.add(entity);
            }
        }
    }

    public Object addReferenceObject(Object object) {
        if (object != null) {
            if (this.referenceObjs == null) {
                this.referenceObjs = new Vector(1);
            }
            if (!this.referenceObjs.contains(object)) {
                this.referenceObjs.add(object);
            }
        }
        return object;
    }

    public void removeAllRelatedEntities() {
        for (int i = 0; this.relEntities != null && i < this.relEntities.size(); ++i) {
            ((Entity)this.relEntities.get(i)).setParentEntity(null);
            ((Entity)this.relEntities.get(i)).removeParentEntity(this);
        }
        if (this.relEntities != null) {
            this.relEntities.clear();
        }
    }

    public void removeParentEntity(Entity entity) {
        if (entity != null && this.parentEntities != null) {
            this.parentEntities.remove(entity);
        }
    }

    public void removeAllParentEntities() {
        if (this.parentEntities != null) {
            this.parentEntities.clear();
        }
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setParentEntity(Entity entity) {
        this.parentEntity = entity;
    }

    public void setEntityStatus(int n) {
        this.entityStatus = n;
    }

    public void setFieldValues(List list) {
        this.fieldValues = list;
    }

    public void setRelatedEntities(List list) {
        this.relEntities = list;
    }

    public void setEntityID(long l) {
        this.entityID = l;
        this.entityKeyString = null;
    }

    public void setCollectionKey(String string, String string2, String string3) {
        this.setCollectionKey(new CollectionKeyWrapper(string, string2, string3));
    }

    public void setCollectionKey(CollectionKey collectionKey) {
        if (collectionKey != null) {
            this.institutionID = collectionKey.getInstitutionID();
            this.collectionID = collectionKey.getCollectionID();
            this.vcID = collectionKey.getVCID();
            List list = this.getRelatedEntities();
            for (int i = 0; list != null && i < list.size(); ++i) {
                ((Entity)list.get(i)).setCollectionKey(collectionKey);
            }
        }
        this.entityKeyString = null;
    }

    public int getEntityStatus() {
        return this.entityStatus;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Entity getParentEntity() {
        return this.parentEntity;
    }

    public List getParentEntities() {
        if (this.parentEntities == null) {
            this.parentEntities = new Vector(0);
        }
        return this.parentEntities;
    }

    public void getEntityAncestry(List list) {
        if (list != null && !list.contains(this)) {
            list.add(this);
            for (int i = 0; this.parentEntities != null && i < this.parentEntities.size(); ++i) {
                ((Entity)this.parentEntities.get(i)).getEntityAncestry(list);
            }
        }
    }

    public int getParentEntityCount() {
        return this.parentEntities == null ? 0 : this.parentEntities.size();
    }

    public List getRelatedEntities() {
        return this.relEntities;
    }

    public List getRelatedEntitiesCopy() {
        if (this.relEntities != null) {
            return new Vector(this.relEntities);
        }
        return null;
    }

    public List getRelatedEntities(int n) {
        Vector<Entity> vector = new Vector<Entity>(0);
        Entity entity = null;
        for (int i = 0; this.relEntities != null && i < this.relEntities.size(); ++i) {
            entity = (Entity)this.relEntities.get(i);
            if (entity.getEntityTypeID() != n) continue;
            vector.add(entity);
        }
        return vector;
    }

    public List getRelatedEntitiesDeep(int n) {
        Vector vector = new Vector(0);
        this.getRelatedEntitiesDeep(n, vector);
        return vector;
    }

    public List getRelatedEntitiesDeep(int n, List vector) {
        if (vector == null) {
            vector = new Vector<Entity>(0);
        }
        Entity entity = null;
        for (int i = 0; this.relEntities != null && i < this.relEntities.size(); ++i) {
            entity = (Entity)this.relEntities.get(i);
            if (entity.getEntityTypeID() == n) {
                vector.add(entity);
            }
            entity.getRelatedEntitiesDeep(n, vector);
        }
        return vector;
    }

    public EntityFieldValue getFieldValue(int n) {
        return this.getFieldValue(n, -1, false);
    }

    public EntityFieldValue getFieldValue(int n, boolean bl) {
        return this.getFieldValue(n, -1, bl);
    }

    public EntityFieldValue getFieldValue(int n, int n2, boolean bl) {
        EntityFieldValue entityFieldValue = null;
        for (int i = 0; this.fieldValues != null && i < this.fieldValues.size(); ++i) {
            EntityFieldValue entityFieldValue2 = (EntityFieldValue)this.fieldValues.get(i);
            if (entityFieldValue2.getFieldID() != n) continue;
            entityFieldValue = entityFieldValue2;
            break;
        }
        if (entityFieldValue == null && bl) {
            entityFieldValue = new EntityFieldValue(n);
            if (this.fieldValues == null) {
                this.fieldValues = new Vector(1);
            }
            if (n2 >= 0 && n2 <= this.fieldValues.size()) {
                this.fieldValues.add(n2, entityFieldValue);
            } else {
                this.fieldValues.add(entityFieldValue);
            }
        }
        return entityFieldValue;
    }

    public EntityFieldValue getFieldValueDeep(int n) {
        EntityFieldValue entityFieldValue;
        int n2;
        for (n2 = 0; this.fieldValues != null && n2 < this.fieldValues.size(); ++n2) {
            entityFieldValue = (EntityFieldValue)this.fieldValues.get(n2);
            if (entityFieldValue.getFieldID() != n) continue;
            return entityFieldValue;
        }
        for (n2 = 0; this.relEntities != null && n2 < this.relEntities.size(); ++n2) {
            entityFieldValue = ((Entity)this.relEntities.get(n2)).getFieldValueDeep(n);
            if (entityFieldValue == null) continue;
            return entityFieldValue;
        }
        return null;
    }

    public List getFieldValues() {
        return this.fieldValues;
    }

    public List getFieldValuesCopy() {
        if (this.fieldValues != null) {
            return new Vector(this.fieldValues);
        }
        return null;
    }

    public List getFieldValuesDeep() {
        Vector vector = new Vector();
        this.getFieldValuesDeep(vector);
        return vector;
    }

    public void getFieldValuesDeep(List list) {
        if (list != null && this.fieldValues != null) {
            list.addAll(this.fieldValues);
        }
        for (int i = 0; this.relEntities != null && i < this.relEntities.size(); ++i) {
            ((Entity)this.relEntities.get(i)).getFieldValuesDeep(list);
        }
    }

    public List getFieldValuesDeep(int n) {
        Vector vector = new Vector();
        this.getFieldValuesDeep(vector, n);
        return vector;
    }

    public void getFieldValuesDeep(List list, int n) {
        if (list != null && this.fieldValues != null) {
            for (int i = 0; this.fieldValues != null && i < this.fieldValues.size(); ++i) {
                EntityFieldValue entityFieldValue = (EntityFieldValue)this.fieldValues.get(i);
                if (entityFieldValue.getFieldID() != n) continue;
                list.add(entityFieldValue);
            }
        }
        for (int i = 0; this.relEntities != null && i < this.relEntities.size(); ++i) {
            ((Entity)this.relEntities.get(i)).getFieldValuesDeep(list, n);
        }
    }

    public int getValueCountDeep() {
        int n;
        int n2 = 0;
        for (n = 0; this.fieldValues != null && n < this.fieldValues.size(); ++n) {
            EntityFieldValue entityFieldValue = (EntityFieldValue)this.fieldValues.get(n);
            if (entityFieldValue == null || entityFieldValue.getValues() == null) continue;
            n2 += entityFieldValue.getValues().size();
        }
        for (n = 0; this.relEntities != null && n < this.relEntities.size(); ++n) {
            n2 += ((Entity)this.relEntities.get(n)).getValueCountDeep();
        }
        return n2;
    }

    public List getEntityList() {
        Vector vector = new Vector();
        this.getEntityList(vector);
        return vector;
    }

    public void getEntityList(List list) {
        if (list != null) {
            if (!list.contains(this)) {
                list.add(this);
            }
            for (int i = 0; this.relEntities != null && i < this.relEntities.size(); ++i) {
                ((Entity)this.relEntities.get(i)).getEntityList(list);
            }
        }
    }

    public Entity getTopmostParent() {
        Entity entity = this.getParentEntity();
        if (entity == null) {
            return this;
        }
        while (entity.getParentEntity() != null) {
            entity = entity.getParentEntity();
        }
        return entity;
    }

    public long getSecondClassParentEntityID() {
        if (this.getParentEntity() == null) {
            return 0L;
        }
        Entity entity = this.getParentEntity();
        Entity entity2 = this;
        while (entity.getParentEntity() != null) {
            entity2 = entity;
            entity = entity.getParentEntity();
        }
        return entity2.getEntityID();
    }

    public List getReferenceObjects() {
        return this.referenceObjs;
    }

    public void sortFieldValues() {
        EntityFieldValue.sortEntityFieldValues(this.fieldValues);
    }

    public void severRelatedEntities() {
        for (int i = 0; this.relEntities != null && i < this.relEntities.size(); ++i) {
            ((Entity)this.relEntities.get(i)).setParentEntity(null);
            ((Entity)this.relEntities.get(i)).removeAllParentEntities();
        }
        if (this.relEntities != null) {
            this.relEntities.clear();
        }
    }

    public void replaceEntity(Entity entity, Entity entity2) {
        int n;
        if (this.relEntities != null && (n = this.relEntities.indexOf(entity)) > -1) {
            this.relEntities.set(n, entity2);
        }
        if (this.parentEntities != null && (n = this.parentEntities.indexOf(entity)) > -1) {
            this.parentEntities.set(n, entity2);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Entity) {
            return InsightUtilities.compareStrings(this.getEntityKeyString(), ((Entity)object).getEntityKeyString()) == 0;
        }
        return this == object;
    }

    public int getEntityTypeID() {
        return this.entityTypeID;
    }

    public long getEntityID() {
        return this.entityID;
    }

    public String getInstitutionID() {
        return this.institutionID;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public String getVCID() {
        return this.vcID;
    }

    public String getEntityKeyString() {
        if (InsightUtilities.isEmpty(this.entityKeyString)) {
            this.entityKeyString = EntityKeyWrapper.getEntityKeyString(this);
        }
        return this.entityKeyString;
    }

    public String toKeyString() {
        return CollectionKeyWrapper.toKeyString(this);
    }

    public int compareTo(Object object) {
        return this.getEntityKeyString().compareToIgnoreCase(((EntityKey)object).getEntityKeyString());
    }
}

