/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.indexer;

import com.luna.insight.server.Debug;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.StringCriterionValue;
import com.luna.insight.server.indexer.TrinityField;
import com.luna.insight.server.indexer.TrinityValueGrouping;
import java.util.Collections;
import java.util.Vector;

public class TrinityFieldGrouping {
    public static final int SINGLE_GROUPING = 1;
    public static final int MULTIPLE_GROUPING_1 = 2;
    public static final int MULTIPLE_GROUPING_2 = 3;
    public static final int MULTIPLE_GROUPING_3 = 4;
    protected int fieldGroupID = -1;
    protected String fieldGroupDisplayName = "";
    protected int fieldGroupType = 1;
    protected Vector fields = new Vector();

    public TrinityFieldGrouping(int n, String string, int n2) {
        this.fieldGroupID = n;
        this.fieldGroupDisplayName = string;
        this.fieldGroupType = n2;
        if (this.fieldGroupType < 1 || this.fieldGroupType > 4) {
            this.fieldGroupType = 1;
        }
    }

    public int getFieldGroupID() {
        return this.fieldGroupID;
    }

    public void addFieldData(TrinityField trinityField, String string, String string2) {
        TrinityField trinityField2 = trinityField;
        int n = this.fields.indexOf(trinityField2);
        if (n > -1) {
            trinityField2 = (TrinityField)this.fields.elementAt(n);
        } else {
            this.fields.addElement(trinityField2);
        }
        trinityField2.addValue(string, string2);
    }

    public Vector getFormattedFieldData() {
        Vector<FieldValue> vector;
        block15: {
            block18: {
                block17: {
                    block16: {
                        block14: {
                            Collections.sort(this.fields);
                            vector = new Vector<FieldValue>();
                            if (this.fieldGroupType != 1) break block14;
                            for (int i = 0; i < this.fields.size(); ++i) {
                                int n;
                                TrinityField trinityField = (TrinityField)this.fields.elementAt(i);
                                Object[] objectArray = trinityField.getValues();
                                if (trinityField.getDelimiterType() == 1) {
                                    for (n = 0; n < objectArray.length; ++n) {
                                        vector.addElement(new FieldValue(trinityField.getFieldID(), trinityField.getDisplayName(), objectArray[n].getValue(), false));
                                    }
                                    continue;
                                }
                                if (trinityField.getDelimiterType() == 2) {
                                    for (n = 0; n < objectArray.length; ++n) {
                                        objectArray[n].setValue("- " + ((TrinityValueGrouping)objectArray[n]).getValue());
                                    }
                                    vector.addElement(new FieldValue(trinityField.getFieldID(), trinityField.getDisplayName(), TrinityFieldGrouping.delimitString(objectArray, "\n"), false));
                                    continue;
                                }
                                if (trinityField.getDelimiterType() == 3) {
                                    vector.addElement(new FieldValue(trinityField.getFieldID(), trinityField.getDisplayName(), TrinityFieldGrouping.delimitString(objectArray, ", "), false));
                                    continue;
                                }
                                if (trinityField.getDelimiterType() != 4) continue;
                                vector.addElement(new FieldValue(trinityField.getFieldID(), trinityField.getDisplayName(), TrinityFieldGrouping.delimitString(objectArray, "; "), false));
                            }
                            break block15;
                        }
                        if (this.fieldGroupType != 2) break block16;
                        Vector[] vectorArray = TrinityFieldGrouping.splitValuesByGrouping(this.fields);
                        for (int i = 0; i < vectorArray.length; ++i) {
                            for (int j = 0; j < vectorArray[i].size(); ++j) {
                                Object[] objectArray = (Object[])vectorArray[i].elementAt(j);
                                vector.addElement(new FieldValue(((TrinityField)objectArray[0]).getFieldID(), ((TrinityField)objectArray[0]).getDisplayName(), (String)objectArray[1], false));
                            }
                        }
                        break block15;
                    }
                    if (this.fieldGroupType != 3) break block17;
                    Vector[] vectorArray = TrinityFieldGrouping.splitValuesByGrouping(this.fields);
                    for (int i = 0; i < vectorArray.length; ++i) {
                        Object[] objectArray = new String[vectorArray[i].size()];
                        for (int j = 0; j < vectorArray[i].size(); ++j) {
                            Object[] objectArray2 = (Object[])vectorArray[i].elementAt(j);
                            objectArray[j] = (String)objectArray2[1];
                        }
                        vector.addElement(new FieldValue(-1, this.fieldGroupDisplayName, TrinityFieldGrouping.delimitString(objectArray, "\n"), true));
                    }
                    break block15;
                }
                if (this.fieldGroupType != 4) break block18;
                Vector[] vectorArray = TrinityFieldGrouping.splitValuesByGrouping(this.fields);
                if (vectorArray.length <= 0) break block15;
                FieldValue fieldValue = new FieldValue(-1, this.fieldGroupDisplayName, " ", true);
                fieldValue.isFieldGroupHeader = true;
                vector.addElement(fieldValue);
                for (int i = 0; i < vectorArray.length; ++i) {
                    for (int j = 0; j < vectorArray[i].size(); ++j) {
                        Object[] objectArray = (Object[])vectorArray[i].elementAt(j);
                        fieldValue = new FieldValue(((TrinityField)objectArray[0]).getFieldID(), ((TrinityField)objectArray[0]).getDisplayName(), (String)objectArray[1], false);
                        fieldValue.dividerType = 1;
                        vector.addElement(fieldValue);
                    }
                }
                break block15;
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                TrinityField trinityField = (TrinityField)this.fields.elementAt(i);
                TrinityValueGrouping[] trinityValueGroupingArray = trinityField.getValues();
                for (int j = 0; j < trinityValueGroupingArray.length; ++j) {
                    vector.addElement(new FieldValue(trinityField.getFieldID(), trinityField.getDisplayName(), trinityValueGroupingArray[j].getValue(), false));
                }
            }
        }
        return vector;
    }

    protected String pluralize(String string, int n) {
        if (n == 1) {
            return string;
        }
        return string + "s";
    }

    public static Vector[] splitValuesByGrouping(Vector vector) {
        Vector vector2 = TrinityFieldGrouping.getGroupingList(vector);
        Vector[] vectorArray = new Vector[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            String string = (String)vector2.elementAt(i);
            vectorArray[i] = new Vector(1);
            for (int j = 0; j < vector.size(); ++j) {
                TrinityField trinityField = (TrinityField)vector.elementAt(j);
                Vector vector3 = trinityField.getValuesByGrouping(string);
                for (int k = 0; k < vector3.size(); ++k) {
                    vectorArray[i].addElement(new Object[]{trinityField, vector3.elementAt(k)});
                }
            }
        }
        return vectorArray;
    }

    public static Vector getGroupingList(Vector vector) {
        int n;
        Vector<Object> vector2 = new Vector<Object>(1);
        for (n = 0; vector != null && n < vector.size(); ++n) {
            TrinityValueGrouping[] trinityValueGroupingArray = ((TrinityField)vector.elementAt(n)).getValues();
            for (int i = 0; trinityValueGroupingArray != null && i < trinityValueGroupingArray.length; ++i) {
                StringCriterionValue stringCriterionValue = new StringCriterionValue(trinityValueGroupingArray[i].getGrouping());
                if (vector2.contains(stringCriterionValue)) continue;
                vector2.addElement(stringCriterionValue);
            }
        }
        Collections.sort(vector2);
        for (n = 0; n < vector2.size(); ++n) {
            vector2.setElementAt(((StringCriterionValue)vector2.elementAt(n)).toString(), n);
        }
        return vector2;
    }

    public static String delimitString(Object[] objectArray, String string) {
        String string2 = "";
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (string2.length() > 0) {
                    string2 = string2 + string;
                }
                string2 = string2 + objectArray[i].toString();
            }
        }
        return string2;
    }

    public static void debugOut(String string) {
        TrinityFieldGrouping.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("TrinityFieldGrouping: " + string, n);
    }
}

