/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.SqlColumnSelection;
import com.luna.insight.server.backend.SqlReservedWords;
import java.util.Vector;

public class SqlTable
implements SqlReservedWords {
    protected String tableName;
    protected String username;
    protected Vector columnSelections;
    protected Vector orderByColumns;
    protected String fullName;

    public SqlTable(String string) {
        this(string, null, null);
    }

    public SqlTable(String string, String string2) {
        this(string, string2, null);
    }

    public SqlTable(String string, String string2, Vector vector) {
        this.tableName = string;
        this.username = string2;
        this.addColumnSelections(vector);
        this.fullName = "";
        if (string2 != null && string2.length() > 0) {
            this.fullName = this.fullName + string2 + ".";
        }
        if (string == null) {
            string = "";
        }
        this.fullName = this.fullName + string;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getUsername() {
        return this.username;
    }

    public void addColumnSelection(String string) {
        this.addColumnSelection(new SqlColumnSelection(string, true));
    }

    public void addColumnSelection(SqlColumnSelection sqlColumnSelection) {
        if (this.columnSelections == null) {
            this.columnSelections = new Vector(1);
        }
        if (!this.columnSelections.contains(sqlColumnSelection)) {
            this.columnSelections.addElement(sqlColumnSelection);
        }
    }

    public void addColumnSelections(Vector vector) {
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            if (vector.elementAt(i) instanceof SqlColumnSelection) {
                this.addColumnSelection((SqlColumnSelection)vector.elementAt(i));
                continue;
            }
            this.addColumnSelection((String)vector.elementAt(i));
        }
    }

    public void clearColumnSelections() {
        if (this.columnSelections != null) {
            this.columnSelections.removeAllElements();
        }
    }

    public Vector getColumnSelections() {
        return this.columnSelections;
    }

    public void addOrderByColumn(String string) {
        if (this.orderByColumns == null) {
            this.orderByColumns = new Vector(1);
        }
        this.orderByColumns.addElement(string);
    }

    public String getSelectionClause() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; this.columnSelections != null && i < this.columnSelections.size(); ++i) {
            SqlColumnSelection sqlColumnSelection = (SqlColumnSelection)this.columnSelections.elementAt(i);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            if (sqlColumnSelection.includeTableName()) {
                stringBuffer.append(this.getFullName() + ".");
            }
            stringBuffer.append(sqlColumnSelection.getColumnName());
        }
        return stringBuffer.toString();
    }

    public String getOrderByClause() {
        String string = "";
        for (int i = 0; this.orderByColumns != null && i < this.orderByColumns.size(); ++i) {
            String string2 = (String)this.orderByColumns.elementAt(i);
            if (string.length() > 0) {
                string = string + ", ";
            }
            string = string + this.getFullName() + "." + string2;
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object instanceof SqlTable) {
            SqlTable sqlTable = (SqlTable)object;
            return InsightUtilities.stringsMatchIgnoreCase(this.getFullName(), sqlTable.getFullName());
        }
        return super.equals(object);
    }

    public static void debugOut(String string) {
        SqlTable.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("SqlTable: " + string, n);
    }
}

