/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server.backend;

import com.luna.insight.server.Debug;
import com.luna.insight.server.MutableBoolean;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.JdbcConnector;
import java.util.Vector;

public class SqlBatchController {
    public static final int DEFAULT_BATCH_SIZE = 100;
    protected DatabaseConnector connector = null;
    protected int batchSize = 0;
    protected int batchCounter = 0;
    protected long lastBatchTime = 0L;
    protected Vector sqlCommands = new Vector();
    protected long execTime = 0L;
    protected boolean executingBatch = false;
    protected MutableBoolean stillNeeded = new MutableBoolean(true);

    public static void debugOut(String string) {
        SqlBatchController.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("SqlBatchController: " + string, n);
    }

    public SqlBatchController(DatabaseConnector databaseConnector) {
        this(databaseConnector, 100);
    }

    public SqlBatchController(DatabaseConnector databaseConnector, int n) {
        this.connector = databaseConnector;
        this.batchSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStillNeeded() {
        MutableBoolean mutableBoolean = this.stillNeeded;
        synchronized (mutableBoolean) {
            return this.stillNeeded.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStillNeeded(boolean bl) {
        MutableBoolean mutableBoolean = this.stillNeeded;
        synchronized (mutableBoolean) {
            this.stillNeeded.setValue(bl);
            if (!this.isStillNeeded() && !this.executingBatch && this.connector != null) {
                SqlBatchController.debugOut("Closing db connector.");
                this.connector.close();
            }
        }
    }

    public void postSqlCommand(String string) {
        if (this.isStillNeeded()) {
            this.sqlCommands.addElement(string);
            if (this.sqlCommands.size() >= this.batchSize) {
                this.executeBatch();
            }
        }
    }

    public void executeRemainingCommands() {
        this.executeBatch();
    }

    public long getExecTime() {
        return this.execTime;
    }

    protected synchronized void executeBatch() {
        long l = System.currentTimeMillis();
        if (this.isStillNeeded() && this.sqlCommands.size() > 0) {
            long l2 = 10L;
            if (System.currentTimeMillis() - this.lastBatchTime < l2) {
                try {
                    Thread.sleep(l2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.executingBatch = true;
            ++this.batchCounter;
            if (this.connector instanceof JdbcConnector) {
                JdbcConnector jdbcConnector = (JdbcConnector)this.connector;
                jdbcConnector.setForceNewConnection(true);
                jdbcConnector.executeBatch(this.sqlCommands, true);
                this.sqlCommands.removeAllElements();
                if (this.batchCounter % 500 == 0) {
                    jdbcConnector.close();
                }
            } else {
                for (int i = 0; i < this.sqlCommands.size(); ++i) {
                    this.connector.setQuery((String)this.sqlCommands.elementAt(i));
                    this.connector.runUpdateQuery();
                    this.connector.close();
                }
                this.sqlCommands.removeAllElements();
            }
            this.lastBatchTime = System.currentTimeMillis();
            this.executingBatch = false;
        }
        if (!this.isStillNeeded()) {
            SqlBatchController.debugOut("Closing db connector.");
            this.connector.close();
        }
        this.execTime += System.currentTimeMillis() - l;
    }
}

