/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionConnection;
import com.luna.insight.server.CriterionValue;
import com.luna.insight.server.FieldMapping;
import com.luna.insight.server.InsightRequest;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.ResultsProgressListener;
import com.luna.insight.server.ThreadedGetter;
import com.luna.insight.server.UniqueListResultCollector;
import com.luna.insight.server.links.LinkFieldMapping;
import java.util.Vector;

public class UniqueListGetter
extends ThreadedGetter {
    public FieldMapping fieldMapping;
    public int relationship;
    public String comparator;
    public int threshold;
    public UniqueListResultCollector ulrc;
    public Vector records = new Vector();
    public Vector userGroupShells = null;
    public boolean isGroupTypeCollection = false;

    public UniqueListGetter(FieldMapping fieldMapping, ResultsProgressListener resultsProgressListener, int n, String string, int n2, UniqueListResultCollector uniqueListResultCollector, CollectionConnection collectionConnection, InsightSmartClient insightSmartClient, Vector vector, boolean bl) {
        this.fieldMapping = fieldMapping;
        this.rpl = resultsProgressListener;
        this.relationship = n;
        this.comparator = string;
        this.threshold = n2;
        this.ulrc = uniqueListResultCollector;
        this.cc = collectionConnection;
        this.ulrc.addClient();
        this.isc = insightSmartClient;
        this.userGroupShells = vector;
        this.isGroupTypeCollection = bl;
    }

    public void run() {
        boolean bl;
        block17: {
            bl = true;
            try {
                if (!this.isc.continueUniqueListRetrieval()) {
                    return;
                }
                InsightRequest insightRequest = InsightRequest.newRequest(14, this.cc.tci, this.isc.getLocalAddress());
                insightRequest.addObjectParam("FIELD_MAPPING", this.fieldMapping);
                if (this.rpl != null && this.rpl.getGroupInfo() != null) {
                    insightRequest.addIntegerParam("GROUP_ID", this.rpl.getGroupInfo().getGroupID());
                } else {
                    insightRequest.addIntegerParam("GROUP_ID", -1);
                }
                insightRequest.addIntegerParam("RELATIONSHIP", this.relationship);
                if (this.relationship != 0) {
                    insightRequest.addStringParam("COMPARATOR", this.comparator);
                }
                insightRequest.addIntegerParam("THRESHOLD", this.threshold);
                boolean bl2 = this.isGroupTypeCollection && this.rpl != null && this.rpl.getGroupInfo() != null && this.rpl.getGroupInfo().getGroupName().equals(this.cc.tci.getInitialGroupOpen());
                insightRequest.addBooleanParam("USE_CACHE", bl2);
                if (this.fieldMapping instanceof LinkFieldMapping) {
                    insightRequest.addCollectionKeyParam(this.cc.tci.getInstitutionID(), this.cc.tci.getCollectionID(), this.cc.tci.getVCID());
                    insightRequest.addStringParam("CLIENT_LOCAL_IP", this.isc.getLocalAddress());
                    insightRequest.addObjectParam("USER_GROUP_SHELLS", this.userGroupShells);
                }
                this.cc.oos.writeObject(insightRequest);
                this.cc.oos.flush();
                this.debugOut("Waiting for data: " + this.cc.tci.toKeyString(), 3);
                if (this.waitWhileKeepAlive(1) > 0) {
                    if (this.rpl != null) {
                        this.rpl.serverContacted(true);
                    }
                    if (!this.isc.continueUniqueListRetrieval()) {
                        return;
                    }
                    bl = this.cc.ois.readBoolean();
                    if (bl) {
                        int n = this.cc.ois.readInt();
                        if (this.rpl != null) {
                            this.rpl.setResultCounts(n, n);
                        }
                        CriterionValue criterionValue = null;
                        for (int i = 0; i < n; ++i) {
                            if (!this.isc.continueUniqueListRetrieval()) {
                                return;
                            }
                            criterionValue = (CriterionValue)this.cc.ois.readObject();
                            if (criterionValue != null && !criterionValue.isEmpty()) {
                                this.records.addElement(criterionValue);
                            }
                            if (this.rpl == null) continue;
                            this.rpl.setResultProgress(i);
                        }
                        if (this.rpl != null) {
                            this.rpl.resultLoadComplete();
                        }
                    }
                } else {
                    this.debugOut("(waitWhileKeepAlive(1) > 0) returned false: " + this.cc.tci.toKeyString(), 3);
                }
            }
            catch (Exception exception) {
                this.debugOut("Exception in UniqueListGetter:\n" + InsightUtilities.getStackTrace(exception), 2);
                if (this.rpl == null) break block17;
                this.rpl.resultLoadFailed();
            }
        }
        this.ulrc.addResult(this.records, bl);
        this.debugOut("Calling remove client for " + this.cc.tci.toKeyString(), 3);
        this.ulrc.removeClient();
    }
}

