/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionConnection;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightServicerCommands;
import com.luna.insight.server.InsightSmartClient;
import com.luna.insight.server.KeepAliveMessage;
import com.luna.insight.server.ResultsProgressListener;
import java.io.IOException;

public abstract class ThreadedGetter
extends Thread
implements InsightServicerCommands {
    public static final int DEBUG_LEVEL = 3;
    public static final String COMPONENT_CODE = "THG";
    public static final int DEFAULT_PORT_NUMBER = 2845;
    public static final int RESOLUTIONS = 8;
    protected static final long WAIT_LIMIT = 30000L;
    protected static final int WAIT_PAUSE = 200;
    protected ResultsProgressListener rpl;
    protected CollectionConnection cc;
    protected InsightSmartClient isc;

    protected void debugOut(String string) {
        Debug.debugOut("THG C" + this.cc.tci.getCollectionID() + ": " + string, 3);
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut("THG C" + this.cc.tci.getCollectionID() + ": " + string, n);
    }

    public long getProgressEnd() {
        return this.cc.progressEnd;
    }

    public long getProgressPosition() {
        return this.cc.progressPosition;
    }

    public int getProgressPercentage() {
        if (this.cc.progressEnd > 0L) {
            return (int)(this.cc.progressPosition * 100L / this.cc.progressEnd);
        }
        return 0;
    }

    protected void setProgressPosition(long l) {
        this.cc.progressPosition = l;
    }

    protected void setProgressEnd(long l) {
        this.cc.progressEnd = l;
        this.setProgressPosition(0L);
    }

    protected int waitForInput() {
        return this.waitForInput(1, 30000L);
    }

    protected int waitForInput(int n) {
        return this.waitForInput(n, 30000L);
    }

    protected int waitForInput(int n, long l) {
        int n2;
        block5: {
            n2 = 0;
            try {
                if (this.cc.theInputStream == null) break block5;
                int n3 = 0;
                while (this.cc.theInputStream.available() < n) {
                    n3 += 200;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((long)n3 < l) continue;
                }
                n2 = this.cc.theInputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n2;
    }

    protected int waitWhileKeepAlive(int n) {
        int n2 = 0;
        try {
            while (this.cc != null && this.cc.theInputStream != null) {
                int n3 = 0;
                while (this.cc.theInputStream.available() < n) {
                    n3 += 200;
                    try {
                        ThreadedGetter.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if ((long)n3 <= 30000L) continue;
                    this.debugOut("Wait limit expired [wait = " + n3 + ", waitLimit = " + 30000L + "]");
                    break;
                }
                if ((n2 = this.cc.theInputStream.available()) <= 0) break;
                KeepAliveMessage keepAliveMessage = new KeepAliveMessage();
                try {
                    Object object = this.cc.ois.readObject();
                    if (object instanceof KeepAliveMessage) {
                        keepAliveMessage = (KeepAliveMessage)object;
                    } else {
                        this.debugOut("Expecting KeepAliveMessage, found " + object.getClass() + ".");
                    }
                }
                catch (Exception exception) {
                    this.debugOut("Exception in waitWhileKeepAlive(): " + exception);
                }
                if (keepAliveMessage.getStatus() == 1) break;
                if (keepAliveMessage.getStatus() == -1) {
                    n2 = 0;
                    break;
                }
                this.debugOut("Received a KeepAliveMessage.  Waiting...");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n2;
    }

    public abstract void run();
}

