/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import java.io.Serializable;

public class InsightVersion
implements Serializable {
    static final long serialVersionUID = 1755502720524099668L;
    public static final int MAJOR_VERSION = 5;
    public static final int MINOR_VERSION = 50;
    public static final int MICRO_VERSION = 21;
    public static final String BUILD_DATE = "05July2006";
    public static final int LAST_MAJOR_VERSION_ZIP_UPDATE = 3;
    public static final int LAST_MINOR_VERSION_ZIP_UPDATE = 10;
    public static final int LAST_MICRO_VERSION_ZIP_UPDATE = 7;
    public static final int EQUALTO = 1;
    public static final int GREATER_THAN_EQUALTO = 7;
    public static final int LESS_THAN_EQUALTO = 8;
    protected int majorVersion = 5;
    protected int minorVersion = 50;
    protected int microVersion = 21;
    protected String buildDate = "";

    public static String releaseName() {
        return ("v" + InsightVersion.version() + " " + BUILD_DATE).intern();
    }

    public static String version() {
        return InsightVersion.version(5, 50, 21);
    }

    public static String version(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(10);
        if (n2 < 10) {
            stringBuffer.append(n);
            stringBuffer.append(".0");
            stringBuffer.append(n2);
        } else {
            stringBuffer.append(n);
            stringBuffer.append('.');
            stringBuffer.append(n2);
        }
        if (n3 < 10) {
            stringBuffer.append("(0");
            stringBuffer.append(n3);
            stringBuffer.append(')');
        } else {
            stringBuffer.append('(');
            stringBuffer.append(n3);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public static boolean requiresZipUpdate(int n, int n2, int n3) {
        return n < 3 || n == 3 && n2 < 10 || n == 3 && n2 == 10 && n3 < 7;
    }

    public static boolean isBetweenVersions(InsightVersion insightVersion, InsightVersion insightVersion2, InsightVersion insightVersion3) {
        return InsightVersion.compareVersions(insightVersion, insightVersion2, 7) && InsightVersion.compareVersions(insightVersion, insightVersion3, 8);
    }

    public static boolean compareVersion(InsightVersion insightVersion, int n) {
        if (insightVersion != null) {
            return InsightVersion.compareVersions(insightVersion.getMajorVersion(), insightVersion.getMinorVersion(), insightVersion.getMicroVersion(), 5, 50, 21, n);
        }
        return false;
    }

    public static boolean compareVersions(InsightVersion insightVersion, InsightVersion insightVersion2, int n) {
        if (insightVersion != null && insightVersion2 != null) {
            return InsightVersion.compareVersions(insightVersion.getMajorVersion(), insightVersion.getMinorVersion(), insightVersion.getMicroVersion(), insightVersion2.getMajorVersion(), insightVersion2.getMinorVersion(), insightVersion2.getMicroVersion(), n);
        }
        return false;
    }

    public static boolean compareVersions(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = new int[]{n, n2, n3};
        int[] nArray2 = new int[]{n4, n5, n6};
        if (n7 == 7) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < nArray2[i]) {
                    return false;
                }
                if (nArray[i] <= nArray2[i]) continue;
                return true;
            }
            return true;
        }
        if (n7 == 8) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] > nArray2[i]) {
                    return false;
                }
                if (nArray[i] >= nArray2[i]) continue;
                return true;
            }
            return true;
        }
        if (n7 == 1) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public InsightVersion() {
        this(BUILD_DATE);
    }

    public InsightVersion(String string) {
        this.buildDate = string;
    }

    public InsightVersion(int n, int n2, int n3) {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.microVersion = n3;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMicroVersion() {
        return this.microVersion;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String toString() {
        return InsightVersion.version(this.getMajorVersion(), this.getMinorVersion(), this.getMicroVersion());
    }

    public static void main(String[] stringArray) {
        System.out.println(InsightVersion.releaseName());
    }
}

