/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class InsightUser
implements Serializable {
    static final long serialVersionUID = -7950814566139869097L;
    public static final int SERVER_ADMIN_NONE = 0;
    public static final int SERVER_ADMIN_READ = 1;
    public static final int SERVER_ADMIN_EDIT = 3;
    public static final int SERVER_ADMIN_ADD = 5;
    public static final int SERVER_ADMIN_DELETE = 9;
    public static final int SERVER_ADMIN_TASK_MASTER = 17;
    public static final int SERVER_STUDIO_AUTHENTICATE = 32;
    public static final int SERVER_STUDIO_COLLECTION_DELETE = 64;
    public static final int SERVER_STUDIO_CATLG_TEMPLATE_DELETE = 64;
    protected int userID = -1;
    protected String loginName = "";
    protected String fullName = "";
    protected String firstName = "";
    protected String lastName = "";
    protected String organization = "";
    protected String email = "";
    protected String address = "";
    protected String city = "";
    protected String state = "";
    protected String postalCode = "";
    protected String country = "";
    protected String phone = "";
    protected String createdTimestamp = "";
    protected int userServerPrivs = 0;
    protected int collectionServerPrivs = 0;
    protected String password;
    protected List userGroupKeys = new ArrayList();
    protected List userShareKeys = new ArrayList();

    public static void debugOut(String string) {
        InsightUser.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("InsightUser: " + string, n);
    }

    public InsightUser() {
    }

    public InsightUser(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
        this.setUserID(n);
        this.setLoginName(string);
        this.setFirstName(string2);
        this.setLastName(string3);
        this.setFullName(this.createFullName());
        this.setOrganization(string4);
        this.setEmail(string5);
        this.setAddress(string6);
        this.setCity(string7);
        this.setState(string8);
        this.setPostalCode(string9);
        this.setCountry(string10);
        this.setPhone(string11);
        this.setCreatedTimestamp(string12);
    }

    public void setUserID(int n) {
        this.userID = n;
    }

    public void setLoginName(String string) {
        this.loginName = string == null ? "" : string;
    }

    public void setFullName(String string) {
        this.fullName = string == null ? "" : string;
    }

    public void setFirstName(String string) {
        this.firstName = string == null ? "" : string;
        this.setFullName(this.createFullName());
    }

    public void setLastName(String string) {
        this.lastName = string == null ? "" : string;
        this.setFullName(this.createFullName());
    }

    public void setOrganization(String string) {
        this.organization = string == null ? "" : string;
    }

    public void setEmail(String string) {
        this.email = string == null ? "" : string;
    }

    public void setAddress(String string) {
        this.address = string == null ? "" : string;
    }

    public void setCity(String string) {
        this.city = string == null ? "" : string;
    }

    public void setState(String string) {
        this.state = string == null ? "" : string;
    }

    public void setPostalCode(String string) {
        this.postalCode = string == null ? "" : string;
    }

    public void setCountry(String string) {
        this.country = string == null ? "" : string;
    }

    public void setPhone(String string) {
        this.phone = string == null ? "" : string;
    }

    public int getUserID() {
        return this.userID;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getPhone() {
        return this.phone;
    }

    private String createFullName() {
        return InsightUtilities.isNonEmpty(this.firstName) ? this.firstName + " " + this.lastName : this.lastName;
    }

    public String toString() {
        return "InsightUser: (" + this.userID + ", " + this.loginName + ", " + this.fullName + ", " + this.organization + ", " + this.email + ", " + this.address + ", " + this.city + ", " + this.state + ", " + this.postalCode + ", " + this.country + ", " + this.phone + ")\n";
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.firstName == null || this.lastName == null) {
            this.firstName = "";
            if (this.fullName == null) {
                this.fullName = "";
            }
            this.lastName = this.fullName;
        }
        if (this.city == null) {
            this.city = "";
            this.state = "";
            this.postalCode = "";
            this.country = "";
        }
    }

    public String getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(String string) {
        this.createdTimestamp = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public int getUserServerPrivs() {
        return this.userServerPrivs;
    }

    public void setUserServerPrivs(int n) {
        this.userServerPrivs = n;
    }

    public int getCollectionServerPrivs() {
        return this.collectionServerPrivs;
    }

    public void setCollectionServerPrivs(int n) {
        this.collectionServerPrivs = n;
    }
}

