/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.license.InsightLicenseManager;
import com.luna.insight.core.license.InsightLicensedSessionManager;
import com.luna.insight.server.AccessLogger;
import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.Debug;
import com.luna.insight.server.EnhancedProperties;
import com.luna.insight.server.FieldCriterion;
import com.luna.insight.server.FieldStandard;
import com.luna.insight.server.FieldStandardsManager;
import com.luna.insight.server.InsightRequest;
import com.luna.insight.server.InsightServicerCommands;
import com.luna.insight.server.InsightSmartServicer;
import com.luna.insight.server.InsightUserServer;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.InsightVersion;
import com.luna.insight.server.MultiObjectIndicatorFieldCriterion;
import com.luna.insight.server.MutableBoolean;
import com.luna.insight.server.ThreadCounter;
import com.luna.insight.server.ThumbnailQuery;
import com.luna.insight.server.ThumbnailQueryCache;
import com.luna.insight.server.ThumbnailQueryLogger;
import com.luna.insight.server.ThumbnailResultCache;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.DatabaseConnectorGenerator;
import com.luna.insight.server.backend.InsightBackendConnector;
import com.luna.insight.server.backend.TrinityConnector;
import com.luna.insight.server.collectionmanagement.CollectionBuildingTemplate;
import com.luna.insight.server.extensions.ServiceComponent;
import com.luna.insight.server.indexer.DiacriticMappings;
import com.luna.insight.server.inscribe.MedeConnector;
import com.luna.insight.server.inscribe.MedePublisher;
import com.luna.insight.server.links.LinkCodeGenerator;
import com.luna.insight.server.links.LinkData;
import com.luna.insight.server.links.LinkFileManager;
import com.luna.insight.server.links.LinkInventoryTracker;
import com.luna.insight.server.mvi.MultiviewImageFileManager;
import com.luna.insight.server.presentation.PresentationFileManager;
import com.luna.insight.server.security.MediaSecurityHandler;
import com.luna.insight.server.security.MediaSecurityUtilities;
import com.luna.insight.server.theme.ThemeFileManager;
import com.luna.insight.server.ucb.UcbSupportConnector;
import com.luna.insight.server.usergroup.UserGroup;
import com.luna.insight.server.usergroup.UserGroupConnection;
import com.luna.insight.server.usergroup.UserGroupConnectionPool;
import com.luna.insight.server.usergroup.UserGroupKey;
import com.luna.insight.server.usergroup.UserGroupSessionResults;
import com.luna.insight.server.usergroup.UserGroupShell;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import sun.misc.Service;

public class InsightSmartServer
extends Thread
implements InsightServicerCommands {
    protected static InsightSmartServer primaryServerInstance = null;
    public static final String COMPONENT_CODE = "ISS";
    public static String DEFAULT_CONNECT_STRING = "";
    public static String DEFAULT_USER_CONNECT_STRING = "";
    public static final int DEBUG_LEVEL = 2;
    public static final boolean DNS_LOOKUP = false;
    public static final int DEFAULT_TCP_BACKLOG = 64;
    public static int MAXIMUM_THUMBNAIL_FIELD_LENGTH = 25;
    public static int DEFAULT_LISTEN_PORT_NUMBER = 2845;
    public static final String BUILD_DATE = "05July2006";
    public static String PROPS_FILE = "InsightServer.dat";
    public static final String DATABASE_UID = "Admin";
    public static final String DEFAULT_MIP_PROPS_FILE = "ucbsupport/props/insight_mip_techemp.properties";
    public static final String DEFAULT_UCB_TABLE_NAMES_FILE = "InsightMIP/ucbtablenames.dat";
    public static final String DEFAULT_FUZZY_HELP_MESSAGE = "No help available.";
    public static final String DEFAULT_PRES_FILE_PATH = "Presentation-Files";
    public static final String DEFAULT_MVI_FILE_PATH = "Multi-View-Image-Files";
    public static final String DEFAULT_LINK_FILE_PATH = "Link-Files";
    public static final String DEFAULT_THEME_FILE_PATH = "Theme-Files";
    public static final String DEFAULT_BROWSER_REMOTE_LAUNCH_URL = "";
    public static final String DEFAULT_JVA_REMOTE_LAUNCH_URL = "";
    public static final int DEFAULT_TIMEOUT_MINUTES = 30;
    public static final int DEFAULT_UPDATE_INTERVAL = 300000;
    public static final int DEFAULT_DISTRIBUTION_BUCKET_SIZE = 1000;
    protected static boolean DISABLE_EXPORT_FOR_VC = true;
    public static ThreadCounter THREAD_COUNTER = null;
    public static ThreadGroup THREAD_GROUP = new ThreadGroup("Insight Servicers");
    public static final String PARAM_NAME_USER_ID = "userid";
    public static final String PARAM_NAME_USER_NAME = "username";
    public static final String PARAM_NAME_RESOLUTION = "resolution";
    public static final String PARAM_NAME_COLLECTIONID = "cid";
    public static final String PARAM_NAME_INSTITUTIONID = "iid";
    public static final String PARAM_NAME_VCID = "vcid";
    public static final String PARAM_NAME_USERGROUP = "usergroup";
    public static final String PARAM_NAME_PROFILEID = "profileid";
    public static final String PARAM_NAME_SERVERTYPE = "servertype";
    protected static final String DEFAULT_FILE_MENU_HELP = "IDH_File.htm";
    protected static final String DEFAULT_EDIT_MENU_HELP = "IDH_Edit.htm";
    protected static final String DEFAULT_INSCRIBE_HELP = "IDH_InscribeHelp.htm";
    protected static final String DEFAULT_WINDOW_MENU_HELP = "IDH_Window.htm";
    protected static final String DEFAULT_HELP_MENU_HELP = "IDH_Help.htm";
    protected static final String DEFAULT_SEARCH_HELP = "IDH_Search_View.htm";
    protected static final String DEFAULT_EDITOR_HELP = "IDH_Editor_View.htm";
    protected static final String DEFAULT_THUMBNAIL_HELP = "IDH_Selection_View.htm";
    protected static final String DEFAULT_TABLE_HELP = "IDH_Table_View.htm";
    protected static final String DEFAULT_PREFS_HELP = "IDH_Preferences_View.htm";
    protected static final String DEFAULT_ENITY_MEDIA_MAP_HELP = "IDH_EntityMediaMap.htm";
    protected static final String DEFAULT_SEARCH_REPLACE_HELP = "IDH_SearchReplace.htm";
    protected static final String DEFAULT_INBOX_HELP = "IDH_Inbox.htm";
    protected static final String DEFAULT_FUZZY_DATE_HELP = "IDH_FuzzyDate.htm";
    protected static final String COMPONENTS_DIRECTORY = "components";
    protected static final Class SERVICE_INTERFACE = class$com$luna$insight$server$extensions$ServiceComponent == null ? (class$com$luna$insight$server$extensions$ServiceComponent = InsightSmartServer.class$("com.luna.insight.server.extensions.ServiceComponent")) : class$com$luna$insight$server$extensions$ServiceComponent;
    protected static final List SERVICE_LIST = new ArrayList();
    protected static final int MIN_ALLOWED_SERVICE_CMD = 1001;
    protected static final Set DISALLOWED_SERVICE_NAMES = new HashSet();
    public int tcpBacklog = 64;
    public int listenPortNumber = DEFAULT_LISTEN_PORT_NUMBER;
    public String connectString = DEFAULT_CONNECT_STRING;
    public String userConnectString = DEFAULT_USER_CONNECT_STRING;
    public boolean servingUsers = false;
    public String suitableClientURL = "";
    public String outdatedMessage = "";
    public String suitableJARFileURL = "";
    public String serverName = "";
    public String serverShortName = "";
    protected ServerSocket listener;
    protected boolean keepGoing = true;
    protected EnhancedProperties properties;
    public boolean FUZZY_DATES = false;
    public String FUZZY_HELP_FILE = "FuzzyHelpText.txt";
    public String FUZZY_DATE_HELP_TEXT = "No help available.";
    public boolean LEXICON_TREES = false;
    public boolean JTIPS = false;
    public String MIP_PROPS_FILE = "ucbsupport/props/insight_mip_techemp.properties";
    public Properties MIP_PROPS;
    public String UCB_TABLE_NAMES_FILE = "InsightMIP/ucbtablenames.dat";
    public Properties UCB_TABLE_NAMES;
    public boolean UCB_DB = false;
    public float DB_VERSION = 2.0f;
    public boolean MS_ACCESS_MODE = false;
    public int DATABASE_QUERY_MODE = 0;
    public String DATABASE_GLOBALESCAPEDELIMITER = null;
    public String DATABASE_UNICODEFIELDPREFIX = null;
    public boolean USE_LOWER_CASE_COMMAND = false;
    public boolean USE_LOWER_CASE_COMMAND_ON_SEARCH_VALUE = false;
    public boolean USE_VALUE_FROM_SUB_QUERY = false;
    public boolean USE_DISTINCT_KEYWORD = true;
    public String BOUND_SERVER_HOSTNAME = null;
    public boolean USE_UNIQUELIST_CACHE = true;
    public boolean CASE_INSENSITIVE_COMPARISON = true;
    public boolean USE_SQL_COUNT_FOR_THRESHOLD = true;
    public boolean USE_DISTINCT_IN_COUNT = true;
    protected DatabaseConnectorGenerator DB_CONNECTOR_GENERATOR = null;
    public String CHAR_WILDCARD = "_";
    public String STRING_WILDCARD = "%";
    public String LEFT_ESCAPE_DELIM = "[";
    public String RIGHT_ESCAPE_DELIM = "]";
    public Locale COLLECTION_LOCALE = InsightBackendConnector.DEFAULT_LOCALE;
    public boolean OBJECTS_EDITABLE = false;
    public boolean MEDE_ENABLED = false;
    protected MedePublisher MEDE_PUBLISHER = null;
    protected long MEDE_PUBLISH_CHANGES_INTERVAL = 300000L;
    protected long MEDE_GATHER_INFO_INTERVAL = 28800000L;
    protected boolean MEDE_PUBLISH_CHANGES_BLOCK_MODE = true;
    protected int MEDE_PUBLISH_CHANGES_BATCH_SIZE = 0;
    protected int MEDE_PUBLISH_TERM_INDEX_MODE = 1;
    protected long MEDE_PUBLISH_TERM_INDEX_INTERVAL = 0L;
    protected Calendar MEDE_PUBLISH_TERM_INDEX_FIRSTTIME = null;
    protected String primaryObjectTable = "Objects";
    protected String primaryObjectKey = "ObjectID";
    protected Vector userGroups = new Vector();
    protected Vector connectionPools = new Vector();
    protected int totalConnections = 0;
    protected int timeoutMinutes = 30;
    protected long lastUserGroupUpdate = System.currentTimeMillis();
    protected long updateIntervalMillis = 300000L;
    protected int connectionLimit = Integer.MAX_VALUE;
    protected String licenseConnect = "";
    protected String licenseNumber;
    protected String logFilename = null;
    protected String searchQueryLogFilename = null;
    protected String xmlExportLogFilename = null;
    protected String presFilePath = "Presentation-Files";
    protected PresentationFileManager presFileManager;
    protected String mviFilePath = "Multi-View-Image-Files";
    protected MultiviewImageFileManager mviFileManager;
    protected String linkFilePath = "Link-Files";
    protected LinkFileManager linkFileManager;
    protected String themeFilePath = "Theme-Files";
    protected String themeFileURL = "";
    protected ThemeFileManager themeFileManager;
    protected String jvaRemoteLaunchURL = "";
    protected String browserRemoteLaunchURL = "";
    protected LinkInventoryTracker linkInventory = new LinkInventoryTracker();
    protected int ALLOW_COLLECTION_SORT_MAX = 0;
    protected int DYNAMIC_DIST_BUCKET_SIZE = 1000;
    protected Map fieldStandardsManagers = new TreeMap();
    protected List uniqueCollectionIDs = new ArrayList();
    protected ThumbnailQueryCache thumbQueryCache = new ThumbnailQueryCache();
    protected Map groupRecordCountCache = new Hashtable();
    protected String MEDIA_INFO_TABLE_NAME = "";
    public Hashtable BACKEND_PARAMETERS = null;
    protected Vector SERVER_SERIALIZED_CLASSES = null;
    protected boolean MEDIA_SECURITY_ENABLED = false;
    protected MediaSecurityHandler mediaSecurityHandler = null;
    protected Hashtable helpFileNames = new Hashtable();
    protected MutableBoolean isServerRebuildingLock = new MutableBoolean(false);
    protected Object updateServerThumbCacheLock = new Object();
    public boolean PERSONAL_COLLECTIONS_ENABLED = false;
    protected DiacriticMappings DIACRITIC_MAPPINGS;
    public boolean LICENSED_COLLECTION_MANAGER = false;
    public boolean LICENSED_PERSONAL_COLLECTION_MANAGER = false;
    public boolean LICENSED_NAMED_USER_MODE = false;
    public int MAX_COLLECTION_MEDIA_COUNT_SOFT = 0;
    public int MAX_COLLECTION_MEDIA_COUNT_HARD = 0;
    public static final String DEFAULT_LICENSE_FILE_PATH = "License-Files";
    public static String licenseFilePath = "License-Files";
    protected InsightLicenseManager licenseManager;
    protected InsightLicensedSessionManager licensedSessionManager;
    static /* synthetic */ Class class$com$luna$insight$server$extensions$ServiceComponent;

    protected void debugOut(String string) {
        this.debugOut(string, 2);
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut(this.getDebugPrefix() + ": " + string, n);
    }

    protected void debugOutStay(String string) {
        Debug.debugOutStay(this.getDebugPrefix() + ": " + string, 2);
    }

    public static ThumbnailQueryCache generateThumbnailQueryCache(FieldStandardsManager fieldStandardsManager, Hashtable hashtable) {
        if (fieldStandardsManager != null && hashtable != null) {
            InsightSmartServer insightSmartServer = new InsightSmartServer(hashtable);
            insightSmartServer.setServerName("Thumbnail Cache Generator");
            insightSmartServer.setServerShortName("TCG");
            insightSmartServer.setDbVersion();
            insightSmartServer.setFSM(fieldStandardsManager.getUniqueCollectionID(), fieldStandardsManager);
            insightSmartServer.assembleDefaultThumbnailQueries(fieldStandardsManager.getUniqueCollectionID());
            return insightSmartServer.getThumbnailQueryCache();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static EnhancedProperties getProperties(String string) {
        EnhancedProperties enhancedProperties;
        block11: {
            enhancedProperties = null;
            FileInputStream fileInputStream = null;
            fileInputStream = new FileInputStream(string);
            enhancedProperties = new EnhancedProperties();
            enhancedProperties.load(fileInputStream);
            fileInputStream.close();
            Object var5_3 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block11;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (IOException iOException) {
                    enhancedProperties = null;
                    Object var5_4 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block11;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return enhancedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static EnhancedProperties loadProperties(String string) {
        EnhancedProperties enhancedProperties;
        block11: {
            enhancedProperties = new EnhancedProperties();
            FileInputStream fileInputStream = null;
            System.out.println("ISS: Configuration file is " + string + ".");
            fileInputStream = new FileInputStream(string);
            enhancedProperties.load(fileInputStream);
            fileInputStream.close();
            Object var5_3 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block11;
            }
            catch (IOException iOException) {}
            break block11;
            {
                catch (IOException iOException) {
                    System.out.println("ISS: Cannot read configuration file!");
                    System.out.println("ISS: Server terminating due to configuration file problems.");
                    System.exit(0);
                    Object var5_4 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block11;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return enhancedProperties;
    }

    public static String addExtendedURLParams(InsightRequest insightRequest, int n, String string, int n2, int n3, String string2, String string3) {
        try {
            if (insightRequest != null) {
                boolean bl;
                String string4 = insightRequest.getStringParam("USER_ID");
                String string5 = insightRequest.getStringParam("USER_NAME");
                InsightVersion insightVersion = insightRequest.getVersion();
                String string6 = insightRequest.getStringParam("SESSION_GROUP_NAME");
                String string7 = "&";
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl2 = string.toLowerCase().endsWith(".sid");
                boolean bl3 = bl = string.toLowerCase().endsWith(".jp2") || string.toLowerCase().endsWith(".jpx");
                if (bl2) {
                    if (!InsightVersion.compareVersions(insightVersion, new InsightVersion(3, 10, 8), 7)) {
                        return string;
                    }
                    string7 = "?";
                    stringBuffer.append("/uffff?");
                } else if (string.lastIndexOf("?") > -1) {
                    stringBuffer.append("&");
                } else {
                    stringBuffer.append("?");
                }
                stringBuffer.append("userid=" + string4);
                stringBuffer.append(string7);
                stringBuffer.append("username=" + (string5 != null ? URLEncoder.encode(string5.replace(' ', '_'), "UTF-8") : string5));
                stringBuffer.append(string7);
                stringBuffer.append("resolution=" + n);
                stringBuffer.append(string7);
                stringBuffer.append("servertype=JVA");
                stringBuffer.append(string7);
                stringBuffer.append("cid=" + n3);
                stringBuffer.append(string7);
                stringBuffer.append("iid=" + string2);
                stringBuffer.append(string7);
                stringBuffer.append("vcid=" + string3);
                stringBuffer.append(string7);
                stringBuffer.append("usergroup=" + (string6 != null ? URLEncoder.encode(string6.replace(' ', '_'), "UTF-8") : string6));
                stringBuffer.append(string7);
                stringBuffer.append("profileid=" + n2);
                if (bl) {
                    stringBuffer.append("/uffff");
                }
                string = string + stringBuffer.toString();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length >= 1) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equalsIgnoreCase("-version")) continue;
                System.out.println("Insight Smart Server - Build of " + InsightVersion.releaseName());
                return;
            }
        }
        System.out.println("\nInsight Smart Server");
        System.out.println("Build " + InsightVersion.releaseName() + "\n");
        System.out.println("ISS: Using communication protocol: version " + InsightVersion.version() + ".");
        System.out.println("ISS: Operating on: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        System.out.println("ISS: Java version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        if (stringArray.length >= 1) {
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equalsIgnoreCase("-cf") && !stringArray[n].equalsIgnoreCase("-configfile")) continue;
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) break;
                PROPS_FILE = stringArray[++n];
                break;
            }
        }
        EnhancedProperties enhancedProperties = InsightSmartServer.loadProperties(PROPS_FILE);
        Debug.setDebugLevel(0);
        THREAD_COUNTER = new ThreadCounter(THREAD_GROUP);
        THREAD_COUNTER.start();
        try {
            int n2 = Integer.parseInt(enhancedProperties.getProperty("DebugLevel"));
            Debug.setDebugLevel(n2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            MAXIMUM_THUMBNAIL_FIELD_LENGTH = Integer.parseInt(enhancedProperties.getProperty("MaxThumbnailFieldLength"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vector<InsightSmartServer> vector = new Vector<InsightSmartServer>();
        int n3 = 1;
        String string = enhancedProperties.getProperty("ServerConfigurationFile" + n3);
        while (string != null) {
            vector.addElement(new InsightSmartServer(string, stringArray));
            string = enhancedProperties.getProperty("ServerConfigurationFile" + ++n3);
        }
        if (n3 == 1) {
            vector.addElement(new InsightSmartServer(enhancedProperties, stringArray));
        }
        for (int i = 0; i < vector.size(); ++i) {
            InsightSmartServer insightSmartServer = (InsightSmartServer)vector.elementAt(i);
            if (i == 0) {
                primaryServerInstance = insightSmartServer;
            }
            insightSmartServer.start();
        }
    }

    public InsightSmartServer() {
    }

    public InsightSmartServer(Hashtable hashtable) {
        this.BACKEND_PARAMETERS = hashtable;
    }

    public InsightSmartServer(String string, String[] stringArray) {
        this(InsightSmartServer.loadProperties(string), stringArray);
    }

    public InsightSmartServer(EnhancedProperties enhancedProperties, String[] stringArray) {
        super("InsightSmartServer");
        String string;
        String string2;
        this.properties = enhancedProperties;
        this.DB_CONNECTOR_GENERATOR = DatabaseConnectorGenerator.getCustomGenerator(this.properties);
        this.serverName = this.properties.getProperty("ServerName", this.serverName);
        this.serverShortName = this.properties.getProperty("ServerShortName", this.serverShortName);
        this.suitableClientURL = this.properties.getProperty("ClientURL");
        this.outdatedMessage = this.properties.getProperty("OutdatedMessage");
        this.suitableJARFileURL = this.properties.getProperty("InsightJAR");
        this.connectString = this.properties.getProperty("DatabaseConnect", this.connectString);
        this.userConnectString = this.properties.getProperty("UserDatabaseConnect", this.userConnectString);
        if (this.properties.getProperty("LogFilename") != null) {
            this.logFilename = this.properties.getProperty("LogFilename");
        }
        try {
            this.timeoutMinutes = Integer.parseInt(this.properties.getProperty("TimeoutMinutes"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n = Integer.parseInt(this.properties.getProperty("UserGroupUpdateMinutes"));
            this.updateIntervalMillis = n * 60000;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n = Integer.parseInt(this.properties.getProperty("MedeCommitChangesMinutes"));
            this.MEDE_PUBLISH_CHANGES_INTERVAL = n * 60000;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n = Integer.parseInt(this.properties.getProperty("MedeGatherInfoMinutes"));
            this.MEDE_GATHER_INFO_INTERVAL = n * 60000;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.properties.getProperty("MedeCommitChangesBlockMode") != null) {
            String string3 = this.properties.getProperty("MedeCommitChangesBlockMode");
            this.MEDE_PUBLISH_CHANGES_BLOCK_MODE = string3.equals("1");
        }
        try {
            int n;
            this.MEDE_PUBLISH_CHANGES_BATCH_SIZE = n = Integer.parseInt(this.properties.getProperty("MedeCommitChangesBatchSize"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.properties.getProperty("MedeAutoTermIndexingMode") != null) {
            try {
                this.MEDE_PUBLISH_TERM_INDEX_MODE = Integer.parseInt(this.properties.getProperty("MedeAutoTermIndexingMode"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.properties.getProperty("MedeBackgroundTermIndexingMinutes") != null) {
            try {
                int n = Integer.parseInt(this.properties.getProperty("MedeBackgroundTermIndexingMinutes"));
                if (n < 0) {
                    n = 0;
                }
                this.MEDE_PUBLISH_TERM_INDEX_INTERVAL = n * 60000;
                string2 = this.properties.getProperty("MedeBackgroundTermIndexingFirstTime");
                if (n > 0 && string2 != null) {
                    if (string2.length() == 4) {
                        int n2 = Integer.parseInt(string2.substring(0, 2));
                        int n3 = Integer.parseInt(string2.substring(2, 4));
                        this.MEDE_PUBLISH_TERM_INDEX_FIRSTTIME = Calendar.getInstance();
                        this.MEDE_PUBLISH_TERM_INDEX_FIRSTTIME.set(11, n2);
                        this.MEDE_PUBLISH_TERM_INDEX_FIRSTTIME.set(12, n3);
                    } else {
                        this.debugOut("Encountered bad data for MedeBackgroundTermIndexingFirstTime");
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.debugOut("Encountered bad data for Mede Background Term Indexing properties");
            }
        }
        if (this.properties.getProperty("DisablePresentationExportForVC") != null) {
            String string4 = this.properties.getProperty("DisablePresentationExportForVC");
            DISABLE_EXPORT_FOR_VC = string4.equals("1");
        }
        if (this.properties.getProperty("SearchQueryLogFilename") != null) {
            this.searchQueryLogFilename = this.properties.getProperty("SearchQueryLogFilename");
        }
        if (this.properties.getProperty("ExportLogFilename") != null) {
            this.xmlExportLogFilename = this.properties.getProperty("ExportLogFilename");
        }
        if (this.properties.getProperty("PresFilePath") != null) {
            this.presFilePath = this.properties.getProperty("PresFilePath");
        }
        if (this.properties.getProperty("MVIFilePath") != null) {
            this.mviFilePath = this.properties.getProperty("MVIFilePath");
        }
        if (this.properties.getProperty("LinkFilePath") != null) {
            this.linkFilePath = this.properties.getProperty("LinkFilePath");
        }
        if (this.properties.getProperty("ThemeFileURL") != null) {
            this.themeFileURL = this.properties.getProperty("ThemeFileURL");
        }
        if (this.properties.getProperty("ThemeFilePath") != null) {
            this.themeFilePath = this.properties.getProperty("ThemeFilePath");
        }
        this.browserRemoteLaunchURL = this.properties.getProperty("BrowserRemoteLaunchURL", this.browserRemoteLaunchURL);
        this.jvaRemoteLaunchURL = this.properties.getProperty("JVARemoteLaunchURL", this.jvaRemoteLaunchURL);
        if (this.properties.getProperty("LicenseFilePath") != null) {
            licenseFilePath = this.properties.getProperty("LicenseFilePath");
        }
        if (this.properties.getProperty("UseDistinctKeyword") != null) {
            String string5 = this.properties.getProperty("UseDistinctKeyword");
            this.USE_DISTINCT_KEYWORD = string5.equals("1");
        }
        if (this.properties.getProperty("BoundServerHostname") != null) {
            this.BOUND_SERVER_HOSTNAME = this.properties.getProperty("BoundServerHostname");
        }
        if (this.properties.getProperty("UseUniqueListCache") != null) {
            String string6 = this.properties.getProperty("UseUniqueListCache");
            this.USE_UNIQUELIST_CACHE = string6.equals("1");
        }
        if (this.properties.getProperty("CaseInsensitiveComparison") != null) {
            String string7 = this.properties.getProperty("CaseInsensitiveComparison");
            this.CASE_INSENSITIVE_COMPARISON = string7.equals("1");
        }
        if (this.properties.getProperty("UseSqlCountToCheckThreshold") != null) {
            String string8 = this.properties.getProperty("UseSqlCountToCheckThreshold");
            this.USE_SQL_COUNT_FOR_THRESHOLD = string8.equals("1");
        }
        if (this.properties.getProperty("UseDistinctInCount") != null) {
            String string9 = this.properties.getProperty("UseDistinctInCount");
            this.USE_DISTINCT_IN_COUNT = string9.equals("1");
        }
        this.FUZZY_HELP_FILE = this.properties.getProperty("FuzzyDateHelpFile", this.FUZZY_HELP_FILE);
        String string10 = this.properties.getProperty("MSAccessMode");
        this.MS_ACCESS_MODE = string10 != null && string10.equals("1");
        try {
            this.DATABASE_QUERY_MODE = Integer.parseInt(this.properties.getProperty("DatabaseQueryMode", "" + this.DATABASE_QUERY_MODE));
        }
        catch (Exception exception) {
            this.DATABASE_QUERY_MODE = 0;
        }
        if (this.properties.getProperty("GlobalEscapeDelimiter") != null) {
            this.DATABASE_GLOBALESCAPEDELIMITER = this.properties.getProperty("GlobalEscapeDelimiter");
        }
        if (this.properties.getProperty("UnicodeFieldPrefix") != null) {
            this.DATABASE_UNICODEFIELDPREFIX = this.properties.getProperty("UnicodeFieldPrefix");
        }
        if ((string2 = this.properties.getProperty("UseLowerCaseCommand")) != null) {
            this.USE_LOWER_CASE_COMMAND = string2.equals("1");
        }
        this.debugOut("USE_LOWER_CASE_COMMAND: " + this.USE_LOWER_CASE_COMMAND);
        String string11 = this.properties.getProperty("UseLowerCaseCommandOnSearchValue");
        if (string11 != null) {
            this.USE_LOWER_CASE_COMMAND_ON_SEARCH_VALUE = string11.equals("1");
        }
        this.debugOut("USE_LOWER_CASE_COMMAND_ON_SEARCH_VALUE: " + this.USE_LOWER_CASE_COMMAND_ON_SEARCH_VALUE);
        if (this.properties.getProperty("UseValueFromSubQuery") != null) {
            String string12 = this.properties.getProperty("UseValueFromSubQuery");
            this.USE_VALUE_FROM_SUB_QUERY = string12.equals("1");
        }
        this.UCB_DB = (string = this.properties.getProperty("UCBDatabase")) != null && string.equals("1");
        this.MIP_PROPS_FILE = this.properties.getProperty("MipPropsFile", DEFAULT_MIP_PROPS_FILE);
        if (this.UCB_DB) {
            this.UCB_TABLE_NAMES_FILE = this.properties.getProperty("UcbTableNames", DEFAULT_UCB_TABLE_NAMES_FILE);
        }
        this.CHAR_WILDCARD = this.properties.getProperty("CharacterWildcard", this.CHAR_WILDCARD);
        this.STRING_WILDCARD = this.properties.getProperty("StringWildcard", this.STRING_WILDCARD);
        this.LEFT_ESCAPE_DELIM = this.properties.getProperty("LeftEscapeDelimiter", this.LEFT_ESCAPE_DELIM);
        this.RIGHT_ESCAPE_DELIM = this.properties.getProperty("RightEscapeDelimiter", this.RIGHT_ESCAPE_DELIM);
        this.DIACRITIC_MAPPINGS = new DiacriticMappings();
        if (this.DIACRITIC_MAPPINGS.hasMappings()) {
            this.debugOut("DiacriticMappings found.");
        } else {
            this.debugOut("No DiacriticMappings found.");
            this.DIACRITIC_MAPPINGS = null;
        }
        try {
            int n = Integer.parseInt(this.properties.getProperty("DebugLevel"));
            Debug.setDebugLevel(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.listenPortNumber = Integer.parseInt(this.properties.getProperty("PortNumber", "" + this.listenPortNumber));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.tcpBacklog = Integer.parseInt(this.properties.getProperty("TCPBacklog", "" + this.tcpBacklog));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.properties.getProperty("MediaInfoTableName") != null) {
            this.MEDIA_INFO_TABLE_NAME = this.properties.getProperty("MediaInfoTableName");
        }
        try {
            this.ALLOW_COLLECTION_SORT_MAX = Integer.parseInt(this.properties.getProperty("AllowCollectionSortMax"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.DYNAMIC_DIST_BUCKET_SIZE = Integer.parseInt(this.properties.getProperty("DynamicThumbnailDistributionBucketSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gatherCommandLine(stringArray);
        this.MEDIA_SECURITY_ENABLED = this.properties.getBooleanProperty("MediaSecurityEnabled", false);
        this.debugOut("MEDIA_SECURITY_ENABLED: " + this.MEDIA_SECURITY_ENABLED);
        if (this.MEDIA_SECURITY_ENABLED) {
            this.mediaSecurityHandler = new MediaSecurityHandler();
            this.mediaSecurityHandler.configure(this.properties);
        }
        String string13 = DEFAULT_FILE_MENU_HELP;
        String string14 = DEFAULT_EDIT_MENU_HELP;
        String string15 = DEFAULT_WINDOW_MENU_HELP;
        String string16 = DEFAULT_HELP_MENU_HELP;
        String string17 = DEFAULT_INSCRIBE_HELP;
        String string18 = DEFAULT_SEARCH_HELP;
        String string19 = DEFAULT_EDITOR_HELP;
        String string20 = DEFAULT_THUMBNAIL_HELP;
        String string21 = DEFAULT_TABLE_HELP;
        String string22 = DEFAULT_PREFS_HELP;
        String string23 = DEFAULT_ENITY_MEDIA_MAP_HELP;
        String string24 = DEFAULT_SEARCH_REPLACE_HELP;
        String string25 = DEFAULT_INBOX_HELP;
        String string26 = DEFAULT_FUZZY_DATE_HELP;
        if (this.properties.getProperty("FileMenuHelp") != null) {
            string13 = this.properties.getProperty("FileMenuHelp");
        }
        if (this.properties.getProperty("EditMenuHelp") != null) {
            string14 = this.properties.getProperty("EditMenuHelp");
        }
        if (this.properties.getProperty("WindowMenuHelp") != null) {
            string15 = this.properties.getProperty("WindowMenuHelp");
        }
        if (this.properties.getProperty("HelpMenuHelp") != null) {
            string16 = this.properties.getProperty("HelpMenuHelp");
        }
        if (this.properties.getProperty("InscribeHelp") != null) {
            string17 = this.properties.getProperty("InscribeHelp");
        }
        if (this.properties.getProperty("SearchViewHelp") != null) {
            string18 = this.properties.getProperty("SearchViewHelp");
        }
        if (this.properties.getProperty("EditorViewHelp") != null) {
            string19 = this.properties.getProperty("EditorViewHelp");
        }
        if (this.properties.getProperty("ThumbnailViewHelp") != null) {
            string20 = this.properties.getProperty("ThumbnailViewHelp");
        }
        if (this.properties.getProperty("TableViewHelp") != null) {
            string21 = this.properties.getProperty("TableViewHelp");
        }
        if (this.properties.getProperty("PreferencesViewHelp") != null) {
            string22 = this.properties.getProperty("PreferencesViewHelp");
        }
        if (this.properties.getProperty("EntityMediaMapHelp") != null) {
            string23 = this.properties.getProperty("EntityMediaMapHelp");
        }
        if (this.properties.getProperty("SearchReplaceHelp") != null) {
            string24 = this.properties.getProperty("SearchReplaceHelp");
        }
        if (this.properties.getProperty("InboxHelp") != null) {
            string25 = this.properties.getProperty("InboxHelp");
        }
        if (this.properties.getProperty("FuzzyDateHelp") != null) {
            string26 = this.properties.getProperty("FuzzyDateHelp");
        }
        this.helpFileNames.put("FileMenuHelp", string13);
        this.helpFileNames.put("EditMenuHelp", string14);
        this.helpFileNames.put("InscribeHelp", string17);
        this.helpFileNames.put("WindowMenuHelp", string15);
        this.helpFileNames.put("HelpMenuHelp", string16);
        this.helpFileNames.put("SearchViewHelp", string18);
        this.helpFileNames.put("EditorViewHelp", string19);
        this.helpFileNames.put("ThumbnailViewHelp", string20);
        this.helpFileNames.put("TableViewHelp", string21);
        this.helpFileNames.put("PreferencesViewHelp", string22);
        this.helpFileNames.put("EntityMediaMapHelp", string23);
        this.helpFileNames.put("SearchReplaceHelp", string24);
        this.helpFileNames.put("InboxHelp", string25);
        this.helpFileNames.put("FuzzyDateHelp", string26);
        this.debugOut("MEDE_PUBLISH_CHANGES_INTERVAL: " + this.MEDE_PUBLISH_CHANGES_INTERVAL + "ms");
        this.debugOut("MEDE_GATHER_INFO_INTERVAL: " + this.MEDE_GATHER_INFO_INTERVAL + "ms");
        this.debugOut("MEDE_PUBLISH_CHANGES_BLOCK_MODE: " + this.MEDE_PUBLISH_CHANGES_BLOCK_MODE);
        this.debugOut("MEDE_PUBLISH_CHANGES_BATCH_SIZE: " + this.MEDE_PUBLISH_CHANGES_BATCH_SIZE);
        this.debugOut("MEDE_PUBLISH_TERM_INDEX_MODE: " + this.MEDE_PUBLISH_TERM_INDEX_MODE);
        this.debugOut("MEDE_PUBLISH_TERM_INDEX_INTERVAL: " + this.MEDE_PUBLISH_TERM_INDEX_INTERVAL);
        this.debugOut("MEDE_PUBLISH_TERM_INDEX_FIRSTTIME: " + (this.MEDE_PUBLISH_TERM_INDEX_FIRSTTIME != null ? this.MEDE_PUBLISH_TERM_INDEX_FIRSTTIME.toString() : "none"));
        this.debugOut("DISABLE_EXPORT_FOR_VC: " + DISABLE_EXPORT_FOR_VC);
        this.debugOut("CHAR_WILDCARD: " + this.CHAR_WILDCARD);
        this.debugOut("STRING_WILDCARD: " + this.STRING_WILDCARD);
        this.debugOut("LEFT_ESCAPE_DELIM: " + this.LEFT_ESCAPE_DELIM);
        this.debugOut("RIGHT_ESCAPE_DELIM: " + this.RIGHT_ESCAPE_DELIM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block47: {
            try {
                Object object;
                if (!this.userConnectString.equals("")) {
                    this.servingUsers = true;
                    this.debugOut("Starting user server (IUS).");
                    object = new InsightUserServer(this.userConnectString, THREAD_GROUP, false);
                    ((Thread)object).start();
                }
                if (this.serverName.length() > 0) {
                    System.out.println("ISS: Server name: " + this.serverName + " (" + this.serverShortName + ")");
                }
                this.debugOut("Listening to port " + this.listenPortNumber + ".");
                this.debugOut("TCP_BACKLOG: (" + this.tcpBacklog + ")");
                this.listener = null;
                object = null;
                InetAddress inetAddress = null;
                InsightSmartServicer insightSmartServicer = null;
                InetAddress inetAddress2 = null;
                if (InsightUtilities.isNonEmpty(this.BOUND_SERVER_HOSTNAME)) {
                    this.debugOut("Attempting to bind to server hostname: " + this.BOUND_SERVER_HOSTNAME);
                    try {
                        inetAddress2 = InetAddress.getByName(this.BOUND_SERVER_HOSTNAME);
                    }
                    catch (Exception exception) {
                        this.debugOut("Failed to bind to server hostname: " + this.BOUND_SERVER_HOSTNAME);
                        inetAddress2 = null;
                    }
                }
                this.listener = inetAddress2 != null ? new ServerSocket(this.listenPortNumber, this.tcpBacklog, inetAddress2) : new ServerSocket(this.listenPortNumber, this.tcpBacklog);
                InsightBackendConnector insightBackendConnector = new InsightBackendConnector(this.getBackendParameters(true));
                this.presFileManager = new PresentationFileManager(this.presFilePath);
                this.mviFileManager = new MultiviewImageFileManager(this.mviFilePath);
                this.linkFileManager = new LinkFileManager(this.linkFilePath);
                this.themeFileManager = new ThemeFileManager(this.themeFilePath, this.themeFileURL);
                this.installUserGroups(insightBackendConnector.getUserGroupConnectionPoolList(this), insightBackendConnector.getUserGroupList());
                String string = "0";
                DatabaseConnector databaseConnector = null;
                try {
                    databaseConnector = this.DB_CONNECTOR_GENERATOR.getConnector(this.connectString);
                    databaseConnector.setQuery("select version from IRVERSION");
                    databaseConnector.runQuerySafe();
                    if (databaseConnector.more()) {
                        string = databaseConnector.getStringField("Version");
                        this.debugOut("Insight Collection Database Version: " + string);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Couldn't Connect to database" + exception.getMessage());
                    Debug.debugOutAlways("Exception in run():\n" + exception.getMessage());
                    this.keepGoing = false;
                }
                catch (Error error) {
                    System.err.println("Couldn't Connect to database" + error.getMessage());
                    Debug.debugOutAlways("Error in run():\n" + error.getMessage());
                    this.keepGoing = false;
                }
                finally {
                    if (databaseConnector != null) {
                        databaseConnector.close();
                    }
                }
                if (string == "0") {
                    System.err.println("Database is not configured correctly");
                    this.keepGoing = false;
                }
                if (this.totalConnections > 0) {
                    Object object2;
                    this.setDbVersion(insightBackendConnector);
                    this.MIP_PROPS = InsightSmartServer.getProperties(this.MIP_PROPS_FILE);
                    if (this.DB_VERSION >= TrinityConnector.TRINITY_VERSION) {
                        insightBackendConnector = new TrinityConnector(this.getBackendParameters());
                    } else if (this.UCB_DB) {
                        this.UCB_TABLE_NAMES = InsightSmartServer.getProperties(this.UCB_TABLE_NAMES_FILE);
                        insightBackendConnector = new UcbSupportConnector(this.getBackendParameters(), this.MIP_PROPS, this.UCB_TABLE_NAMES);
                    }
                    this.COLLECTION_LOCALE = insightBackendConnector.getCollectionLanguage();
                    this.debugOut("Using backend: " + insightBackendConnector.getImplementationName() + ", version " + insightBackendConnector.getVersionId() + ".");
                    this.OBJECTS_EDITABLE = insightBackendConnector.canEditObjects();
                    if (this.OBJECTS_EDITABLE) {
                        this.debugOut("Server supports client-side object editing.");
                        this.debugOut("Retrieving primary objects table name and key from file: InsightTrinityIndexer.dat.");
                        this.setPrimaryObjectsNameAndKey();
                    } else {
                        this.debugOut("Server does not support client-side object editing.");
                    }
                    insightBackendConnector.removeAllLinkData();
                    this.FUZZY_DATES = insightBackendConnector.getFuzzyDateSupport();
                    if (this.FUZZY_DATES) {
                        this.debugOut("Server db formatted for Fuzzy Date support.");
                        this.debugOut("Server reading Fuzzy Date help message.");
                        this.FUZZY_DATE_HELP_TEXT = this.readTextFromFile(this.FUZZY_HELP_FILE);
                        if (this.FUZZY_DATE_HELP_TEXT.length() < 1) {
                            this.FUZZY_DATE_HELP_TEXT = DEFAULT_FUZZY_HELP_MESSAGE;
                        }
                    } else {
                        this.debugOut("Server does not Fuzzy Dates.");
                    }
                    if (this.UCB_DB) {
                        object2 = new UcbSupportConnector(this.getBackendParameters(), this.MIP_PROPS, this.UCB_TABLE_NAMES);
                        if (this.UCB_DB) {
                            this.debugOut("Server db is a UCB database.");
                        }
                        boolean bl = this.LEXICON_TREES = this.UCB_DB && ((UcbSupportConnector)object2).getLexiconTreeSupport();
                        if (this.LEXICON_TREES) {
                            this.debugOut("Server supporting MIP lexicon trees.");
                        } else {
                            this.debugOut("Server does not support MIP lexicon trees.");
                        }
                        this.JTIPS = this.UCB_DB ? true : ((UcbSupportConnector)object2).getJTIPSupport();
                        if (this.JTIPS) {
                            this.debugOut("Server supporting JTIP image files.");
                        } else {
                            this.debugOut("Server does not support JTIP image files.");
                        }
                    } else {
                        this.debugOut("Server db is not a UCB database.");
                    }
                    this.getBackendParameters(true);
                    this.setMedeEnabled(insightBackendConnector);
                    this.setUniqueCollectionIDs(insightBackendConnector);
                    this.debugOut("querying personal collection server mode");
                    this.PERSONAL_COLLECTIONS_ENABLED = ((TrinityConnector)insightBackendConnector).isPersonalCollectionServer();
                    this.licenseManager = new InsightLicenseManager(licenseFilePath);
                    if (this.PERSONAL_COLLECTIONS_ENABLED) {
                        this.LICENSED_PERSONAL_COLLECTION_MANAGER = this.licenseManager.checkPersonalCollectionManagerLicense();
                    } else {
                        this.LICENSED_COLLECTION_MANAGER = this.licenseManager.checkCollectionManagerLicense();
                    }
                    if (!this.LICENSED_PERSONAL_COLLECTION_MANAGER && !this.LICENSED_COLLECTION_MANAGER) {
                        Debug.debugOutAlways("No valid license found, please contact Luna for a new license key.");
                        System.exit(0);
                    }
                    this.LICENSED_NAMED_USER_MODE = this.licenseManager.isLicensedUserMode();
                    if (this.LICENSED_NAMED_USER_MODE) {
                        this.licenseManager.initializeLicenseNamedUserList();
                    }
                    this.initializeCollectionMediaCount((TrinityConnector)insightBackendConnector);
                    this.debugOut("Loading Service Components ...");
                    if (!this.loadServiceComponents()) {
                        Debug.debugOutAlways("Failed to load all available Service Components.  Exiting.");
                        System.exit(0);
                    }
                    this.debugOut("Creating FSM.");
                    this.assembleFSM(null, insightBackendConnector);
                    object2 = this.fieldStandardsManagers.values().iterator();
                    while (object2.hasNext()) {
                        FieldStandardsManager fieldStandardsManager = (FieldStandardsManager)object2.next();
                        this.assembleDefaultThumbnailQueries(fieldStandardsManager.getUniqueCollectionID());
                    }
                    if (insightBackendConnector instanceof TrinityConnector) {
                        this.debugOut("Clearing search results.");
                        ((TrinityConnector)insightBackendConnector).clearAllSearchResults();
                    }
                    this.MEDE_PUBLISHER.processPartiallyCommittedTerms();
                    if (this.keepGoing) {
                        Debug.debugOutAlways("Accepting connection.");
                    }
                    while (this.keepGoing) {
                        this.debugOut("Accepting connection.");
                        object = this.listener.accept();
                        inetAddress = ((Socket)object).getInetAddress();
                        this.debugOut("Connection received at " + new Date() + ".", 1);
                        this.debugOut("Servicing connection from " + inetAddress.getHostAddress() + ".", 1);
                        try {
                            insightSmartServicer = new InsightSmartServicer((Socket)object, this);
                            object2 = new Thread(THREAD_GROUP, insightSmartServicer);
                            try {
                                ((Thread)object2).setName("InsightSmartServicer");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.debugOut("Starting servicer thread.");
                            ((Thread)object2).start();
                        }
                        catch (Exception exception) {
                            this.debugOut("Exception while servicing: " + exception);
                        }
                    }
                    break block47;
                }
                this.debugOut("Cannot run with 0 total sessions; shutting down.");
            }
            catch (IOException iOException) {
                this.debugOut("IOException on listener open.");
                this.debugOut("Server port cannot be opened.  Terminating.");
                if (THREAD_COUNTER == null) break block47;
                THREAD_COUNTER.setStillNeeded(false);
            }
        }
    }

    void updateUniqueCollection(Integer n) {
        if (!this.uniqueCollectionIDs.contains(n)) {
            this.uniqueCollectionIDs.add(n);
        }
        this.assembleFSM(n, this.getBackendConnector());
        this.assembleDefaultThumbnailQueries(n);
    }

    private final void gatherConnectionLimit() {
        if (this.licenseNumber != null && this.licenseNumber.length() == 23) {
            try {
                int n = Integer.parseInt(this.licenseNumber.substring(0, 5));
                int n2 = Integer.parseInt(this.licenseNumber.substring(6, 11));
                int n3 = Integer.parseInt(this.licenseNumber.substring(12, 17));
                int n4 = Integer.parseInt(this.licenseNumber.substring(18, 23));
                char[] cArray = new char[]{(char)(65 + n % 20), (char)(65 + n % 12), (char)(65 + n % 5), (char)(65 + n2 % 16), (char)(65 + n2 % 4), (char)(65 + n3 % 23), (char)(65 + n4 % 24), (char)(65 + n2 % 19), (char)(65 + n4 % 6), (char)(75 + n3 % 6)};
                try {
                    DatabaseConnector databaseConnector = this.DB_CONNECTOR_GENERATOR.getConnector(this.licenseConnect);
                    databaseConnector.setUsername(DATABASE_UID);
                    databaseConnector.setPassword(new String(cArray));
                    databaseConnector.setQuery("SELECT * FROM Connections;");
                    databaseConnector.runQuery();
                    this.connectionLimit = databaseConnector.more() ? databaseConnector.getIntegerFieldByName("MaximumConnections") : 0;
                    databaseConnector.close();
                }
                catch (Exception exception) {
                    this.debugOut("ISS: " + exception);
                    this.connectionLimit = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.incorrectLicenseFormat();
            }
            this.debugOut("Granted " + this.connectionLimit + " concurrent connection" + this.pluralize(this.connectionLimit) + ".");
        } else {
            this.incorrectLicenseFormat();
        }
    }

    protected void incorrectLicenseFormat() {
        System.out.println("ISS: Incorrect license number format.  Use format 12345-67890-12345-67890.");
        System.out.println("ISS: Cannot run without license number; shutting down.");
    }

    protected void installUserGroups(Vector vector, Vector vector2) {
        if (vector != null && vector2 != null) {
            Object object;
            int n;
            this.userGroups = vector2;
            for (n = 0; n < vector.size(); ++n) {
                object = (UserGroupConnectionPool)vector.elementAt(n);
                object.setTimeoutMinutes(this.timeoutMinutes);
                this.totalConnections += object.getSessionLimit();
                this.debugOut("Connection pool " + object.getPoolName() + " granted " + object.getSessionLimit() + " concurrent connection" + this.pluralize(object.getSessionLimit()) + ".");
                object.setUserGroups(this.userGroups);
                this.connectionPools.addElement(object);
            }
            for (n = 0; n < this.userGroups.size(); ++n) {
                object = (UserGroup)this.userGroups.elementAt(n);
                this.debugOut("User group " + ((UserGroup)object).getGroupName() + " reserving " + ((UserGroup)object).getConnectionReserve() + " connection" + this.pluralize(((UserGroup)object).getConnectionReserve()) + ", accepting IPs in range:\n       " + ((UserGroup)object).getValidIPs());
            }
        }
    }

    protected void initializeCollectionMediaCount(TrinityConnector trinityConnector) {
        this.MAX_COLLECTION_MEDIA_COUNT_SOFT = this.licenseManager.getMaxMediaSoft();
        this.MAX_COLLECTION_MEDIA_COUNT_HARD = this.licenseManager.getMaxMediaHard();
        if (this.MAX_COLLECTION_MEDIA_COUNT_SOFT > 0 && this.MAX_COLLECTION_MEDIA_COUNT_HARD <= 0) {
            this.MAX_COLLECTION_MEDIA_COUNT_HARD = this.MAX_COLLECTION_MEDIA_COUNT_SOFT + 250;
        }
        if (this.MAX_COLLECTION_MEDIA_COUNT_SOFT > 0) {
            int n = trinityConnector.getCollectionMediaCount();
            System.out.println("Current media count: " + n + " of " + this.MAX_COLLECTION_MEDIA_COUNT_SOFT);
            if (this.shouldWarnAboutMediaCount(n)) {
                System.out.println("!!!!! WARNING !!!!! WARNING !!!!! WARNING !!!!!");
                if (n <= this.MAX_COLLECTION_MEDIA_COUNT_SOFT) {
                    System.out.println("The current media count (" + n + ") is near the maximum of " + this.MAX_COLLECTION_MEDIA_COUNT_SOFT);
                } else if (n < this.MAX_COLLECTION_MEDIA_COUNT_HARD) {
                    System.out.println("The current media count (" + n + ") exceeds the maximum of " + this.MAX_COLLECTION_MEDIA_COUNT_SOFT);
                } else {
                    System.out.println("There are too many media in the collection.  Shutting down.");
                    System.exit(0);
                }
            }
        }
    }

    public boolean shouldWarnAboutMediaCount(int n) {
        if (this.MAX_COLLECTION_MEDIA_COUNT_SOFT <= 0) {
            return false;
        }
        int n2 = new Double(new Integer(this.MAX_COLLECTION_MEDIA_COUNT_SOFT).doubleValue() * 0.9).intValue();
        return n >= n2;
    }

    public void updateUserGroupsAndPools(boolean bl) {
        if (bl || System.currentTimeMillis() - this.lastUserGroupUpdate > this.updateIntervalMillis) {
            Object object;
            int n;
            this.debugOut("Updating user groups and connection pools.");
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector = insightBackendConnector.getUserGroupConnectionPoolList(this);
            Vector vector2 = insightBackendConnector.getUserGroupList();
            this.installNewUserGroups(vector, vector2);
            this.removeOldUserGroups(vector, vector2);
            for (n = 0; n < this.connectionPools.size(); ++n) {
                object = (UserGroupConnectionPool)this.connectionPools.elementAt(n);
                object.setUserGroups(this.userGroups);
                this.debugOut("Connection pool " + object.getPoolName() + " granted " + object.getSessionLimit() + " concurrent connection" + this.pluralize(object.getSessionLimit()) + ".");
            }
            for (n = 0; n < this.userGroups.size(); ++n) {
                object = (UserGroup)this.userGroups.elementAt(n);
                this.debugOut("User group " + ((UserGroup)object).getGroupName() + " reserving " + ((UserGroup)object).getConnectionReserve() + " connection" + this.pluralize(((UserGroup)object).getConnectionReserve()) + ", accepting IPs in range:\n       " + ((UserGroup)object).getValidIPs());
            }
            this.lastUserGroupUpdate = System.currentTimeMillis();
        }
    }

    private void installNewUserGroups(Vector vector, Vector vector2) {
        if (vector != null && vector2 != null) {
            UserGroup userGroup;
            UserGroup userGroup2;
            int n;
            for (n = 0; n < vector2.size(); ++n) {
                userGroup2 = (UserGroup)vector2.elementAt(n);
                userGroup = this.getUserGroup(userGroup2.getGroupName(), userGroup2.getGroupCodeKey());
                if (userGroup == null) {
                    this.userGroups.addElement(userGroup2);
                    this.debugOut("Adding new user group " + userGroup2.getGroupName() + ".");
                    continue;
                }
                userGroup.setGroupID(userGroup2.getGroupID());
                userGroup.setProfileID(userGroup2.getProfileID());
                userGroup.setConnectionReserve(userGroup2.getConnectionReserve());
                if (!userGroup.getValidIPs().equals(userGroup2.getValidIPs())) {
                    userGroup.setValidIPs(userGroup2.getValidIPs());
                }
                if (userGroup.getPoolID() != userGroup2.getPoolID() && userGroup.getConnectionPool() != null) {
                    userGroup.getConnectionPool().removeUserGroup(userGroup);
                }
                userGroup.setPoolID(userGroup2.getPoolID());
            }
            for (n = 0; n < vector.size(); ++n) {
                userGroup2 = (UserGroupConnectionPool)vector.elementAt(n);
                userGroup = this.getConnectionPool(userGroup2.getPoolID());
                if (userGroup == null) {
                    userGroup2.setTimeoutMinutes(this.timeoutMinutes);
                    this.totalConnections += userGroup2.getSessionLimit();
                    this.debugOut("Adding new connection pool " + userGroup2.getPoolName() + ".  Granted " + userGroup2.getSessionLimit() + " concurrent connection" + this.pluralize(userGroup2.getSessionLimit()) + ".");
                    this.connectionPools.addElement(userGroup2);
                    continue;
                }
                userGroup.setPoolName(userGroup2.getPoolName());
                this.totalConnections += userGroup2.getSessionLimit() - userGroup.getSessionLimit();
                userGroup.setSessionLimit(userGroup2.getSessionLimit());
            }
        }
    }

    private void removeOldUserGroups(Vector vector, Vector vector2) {
        if (vector != null && vector2 != null) {
            Object[] objectArray = new UserGroup[this.userGroups.size()];
            this.userGroups.copyInto(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                if (vector2.contains(objectArray[i])) continue;
                if (((UserGroup)objectArray[i]).getConnectionPool() != null) {
                    ((UserGroup)objectArray[i]).getConnectionPool().removeUserGroup((UserGroup)objectArray[i]);
                }
                this.userGroups.removeElement(objectArray[i]);
                this.debugOut("Removed user group " + ((UserGroup)objectArray[i]).getGroupName() + ".");
            }
            Object[] objectArray2 = new UserGroupConnectionPool[this.connectionPools.size()];
            this.connectionPools.copyInto(objectArray2);
            for (int i = 0; i < objectArray2.length; ++i) {
                if (vector.contains(objectArray2[i]) || objectArray2[i].getUserGroupCount() != 0) continue;
                this.totalConnections -= objectArray2[i].getSessionLimit();
                this.connectionPools.removeElement(objectArray2[i]);
                this.debugOut("Removed connection pool " + objectArray2[i].getPoolName() + ".");
            }
        }
    }

    public void checkForTimeouts() {
        Enumeration enumeration = this.connectionPools.elements();
        while (enumeration.hasMoreElements()) {
            UserGroupConnectionPool userGroupConnectionPool = (UserGroupConnectionPool)enumeration.nextElement();
            userGroupConnectionPool.checkForTimeouts();
        }
    }

    public UserGroupKey getKey(String string, String string2) {
        return new UserGroupKey(string, string2);
    }

    public Vector getUserGroups() {
        return this.userGroups;
    }

    public UserGroupConnectionPool getConnectionPool(int n) {
        UserGroupConnectionPool userGroupConnectionPool = null;
        for (int i = 0; i < this.connectionPools.size(); ++i) {
            if (n != ((UserGroupConnectionPool)this.connectionPools.elementAt(i)).getPoolID()) continue;
            userGroupConnectionPool = (UserGroupConnectionPool)this.connectionPools.elementAt(i);
        }
        return userGroupConnectionPool;
    }

    public UserGroup getUserGroup(String string, String string2) {
        UserGroupKey userGroupKey;
        int n;
        UserGroup userGroup = null;
        if (string != null && string2 != null && (n = this.userGroups.indexOf(userGroupKey = this.getKey(string, string2))) > -1) {
            userGroup = (UserGroup)this.userGroups.elementAt(n);
        }
        return userGroup;
    }

    public UserGroupConnection getUserGroupConnection(String string, String string2, String string3, String string4) {
        return this.getUserGroupConnection(string, string2, string3, string4, false);
    }

    public UserGroupConnection getUserGroupConnection(String string, String string2, String string3, String string4, boolean bl) {
        return this.getUserGroupConnection(string, string2, string3, string4, bl, null, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserGroupConnection getUserGroupConnection(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, String string7, String string8, String string9) {
        UserGroupConnection userGroupConnection = null;
        Vector vector = this.getUserGroups();
        synchronized (vector) {
            UserGroup userGroup = this.getUserGroup(string, string2);
            if (userGroup != null) {
                UserGroupConnectionPool userGroupConnectionPool = userGroup.getConnectionPool();
                if (userGroupConnectionPool != null) {
                    userGroupConnection = userGroupConnectionPool.getSession(string3, string4, userGroup);
                    if (userGroupConnection == null) {
                        this.debugOut("User group session not found for [" + string3 + ":" + string4 + "] of user group [" + string + ":" + string2 + "]");
                        if (bl) {
                            if (userGroup.isIPAddressInRange(string3)) {
                                this.debugOut("Attempting to start session in user group: [" + userGroupConnectionPool.getPoolName() + ":" + userGroup.getGroupName() + "].");
                                this.debugOut("Client IP address: " + string3 + ":" + string4);
                                boolean bl2 = false;
                                boolean bl3 = false;
                                if (userGroup.getConnectionReserve() > 0 && userGroupConnectionPool.areReservedSessionsAvailable(userGroup)) {
                                    bl2 = true;
                                    bl3 = true;
                                } else if (userGroupConnectionPool.areCommunalSessionsAvailable()) {
                                    bl2 = true;
                                }
                                if (bl2) {
                                    userGroupConnection = userGroupConnectionPool.addNewSession(string3, string4, userGroup, bl3);
                                    if (userGroupConnection != null) {
                                        this.debugOut("Session start successful.");
                                        if (bl3) {
                                            this.debugOut("Client " + string3 + ":" + string4 + " starting reserved session in [" + userGroupConnectionPool.getPoolName() + ":" + userGroup.getGroupName() + "] (" + userGroupConnectionPool.getFilledReserveCount(userGroup) + " reserved session" + this.pluralize(userGroupConnectionPool.getFilledReserveCount(userGroup)) + " and " + userGroupConnectionPool.getSessionCount() + " total session" + this.pluralize(userGroupConnectionPool.getSessionCount()) + " now used)");
                                            this.logAccess(null, string5, string3, string4, string6, userGroup.getGroupName(), string7, string8, string9, userGroup.getProfileID() + "", userGroupConnectionPool.getPoolName(), userGroupConnectionPool.getSessionCount() + "", "reserved", "login successful", "Starting reserved session");
                                        } else {
                                            this.debugOut("Client " + string3 + ":" + string4 + " starting communal session in [" + userGroupConnectionPool.getPoolName() + ":" + userGroup.getGroupName() + "] (" + userGroupConnectionPool.getSessionCount() + " total session" + this.pluralize(userGroupConnectionPool.getSessionCount()) + " now used)");
                                            this.logAccess(null, string5, string3, string4, string6, userGroup.getGroupName(), string7, string8, string9, userGroup.getProfileID() + "", userGroupConnectionPool.getPoolName(), userGroupConnectionPool.getSessionCount() + "", "communal", "login successful", "Starting communal session");
                                        }
                                    } else {
                                        this.debugOut("Unable to start session in [" + userGroupConnectionPool.getPoolName() + ":" + userGroup.getGroupName() + "].  A session has already been started for client " + string3 + ":" + string4 + ".");
                                        this.logAccess(null, string5, string3, string4, string6, userGroup.getGroupName(), string7, string8, string9, userGroup.getProfileID() + "", userGroupConnectionPool.getPoolName(), userGroupConnectionPool.getSessionCount() + "", "normal", "login failed", "Unable to start session");
                                    }
                                } else {
                                    this.debugOut("There are no available sessions for [" + userGroupConnectionPool.getPoolName() + ":" + userGroup.getGroupName() + "].");
                                    this.logAccess(null, string5, string3, string4, string6, userGroup.getGroupName(), string7, string8, string9, userGroup.getProfileID() + "", userGroupConnectionPool.getPoolName(), userGroupConnectionPool.getSessionCount() + "", "normal", "login failed", "No available sessions");
                                }
                            } else {
                                this.debugOut("Client " + string3 + " not in IP address range (" + userGroup.getValidIPs() + ").  Cannot start session.");
                                this.logAccess(null, string5, string3, string4, string6, userGroup.getGroupName(), string7, string8, string9, userGroup.getProfileID() + "", userGroupConnectionPool.getPoolName(), userGroupConnectionPool.getSessionCount() + "", "normal", "login failed", "Not in IP address range (" + userGroup.getValidIPs() + ")");
                            }
                        }
                    }
                } else {
                    this.debugOut("Connection pool undefined (connection pool ID: " + userGroup.getPoolID() + ").");
                }
            } else {
                this.debugOut("User group not found for [" + string + ":" + string2 + "].");
            }
        }
        return userGroupConnection;
    }

    public UserGroupSessionResults startSession(String string, String string2, String string3, String string4) {
        return this.startSession(string, string2, string3, string4, null);
    }

    public UserGroupSessionResults startSession(String string, String string2, String string3, String string4, String string5) {
        return this.startSession(string, string2, string3, string4, string5, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserGroupSessionResults startSession(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        UserGroupSessionResults userGroupSessionResults;
        Vector vector = this.getUserGroups();
        synchronized (vector) {
            this.checkForTimeouts();
            this.updateUserGroupsAndPools(false);
            UserGroupConnection userGroupConnection = this.getUserGroupConnection(string, string2, string3, string4, true, null, string5, string7, string6, string8);
            userGroupSessionResults = new UserGroupSessionResults();
            if (userGroupConnection != null && userGroupConnection.getUserGroup() != null && userGroupConnection.getUserGroup().getConnectionPool() != null) {
                userGroupConnection.heardFrom();
                userGroupSessionResults.sessionStarted = true;
                userGroupSessionResults.timeoutMinutes = userGroupConnection.getUserGroup().getConnectionPool().getTimeoutMinutes();
                userGroupSessionResults.sessionGroupName = userGroupConnection.getUserGroup().getGroupName();
                userGroupSessionResults.sessionCodeKey = userGroupConnection.getUserGroup().getGroupCodeKey();
                userGroupSessionResults.profileID = userGroupConnection.getUserGroup().getProfileID();
            }
        }
        return userGroupSessionResults;
    }

    public boolean endSession(String string, String string2, String string3, String string4) {
        return this.endSession(string, string2, string3, string4, null);
    }

    public boolean endSession(String string, String string2, String string3, String string4, String string5) {
        return this.endSession(string, string2, string3, string4, string5, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endSession(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        boolean bl = false;
        Vector vector = this.getUserGroups();
        synchronized (vector) {
            UserGroupConnectionPool userGroupConnectionPool;
            UserGroup userGroup = this.getUserGroup(string, string2);
            if (userGroup != null && (userGroupConnectionPool = userGroup.getConnectionPool()) != null && (bl = userGroupConnectionPool.removeSession(string3, string4, userGroup))) {
                this.debugOut("Removed session for " + string3 + ":" + string4);
                this.debugOut("Removed session from [" + userGroupConnectionPool.getPoolName() + ":" + userGroup.getGroupName() + "]");
                this.logAccess(null, null, string3, string4, string5, userGroup.getGroupName(), string7, string6, string8, userGroup.getProfileID() + "", userGroupConnectionPool.getPoolName(), userGroupConnectionPool.getSessionCount() + "", "normal", "logout", "Removed session");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keepSessionAlive(String string, String string2, String string3, String string4) {
        Vector vector = this.getUserGroups();
        synchronized (vector) {
            UserGroupConnectionPool userGroupConnectionPool;
            UserGroup userGroup = this.getUserGroup(string, string2);
            if (userGroup != null && (userGroupConnectionPool = userGroup.getConnectionPool()) != null) {
                userGroupConnectionPool.renewSession(string3, string4, userGroup);
            }
        }
    }

    public void logAccess(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) {
        if (this.logFilename != null && this.logFilename.length() > 0) {
            try {
                AccessLogger.logAccess((String)this.logFilename, (String)string, (String)string2, (String)string3, (String)string4, (String)string5, (String)string6, (String)string7, (String)string8, (String)string9, (String)string10, (String)string11, (String)string12, (String)string13, (String)string14, (String)string15);
            }
            catch (Exception exception) {
                this.debugOut("Exception while constructing log string:\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error while constructing log string:\n" + InsightUtilities.getStackTrace(error));
            }
        }
    }

    public int getDynamicDistributionBucketSize() {
        return this.DYNAMIC_DIST_BUCKET_SIZE;
    }

    public Locale getCollectionLocale() {
        return this.COLLECTION_LOCALE;
    }

    public void setConnectString(String string) {
        this.connectString = string;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setServerShortName(String string) {
        this.serverShortName = string;
    }

    public String getPrimaryObjectTable() {
        return this.primaryObjectTable;
    }

    public void setPrimaryObjectsNameAndKey() {
        EnhancedProperties enhancedProperties = InsightSmartServer.getProperties("InsightTrinityIndexer.dat");
        if (enhancedProperties != null) {
            this.primaryObjectTable = this.properties.getProperty("PrimaryObjectTable", this.primaryObjectTable);
            this.primaryObjectKey = this.properties.getProperty("PrimaryObjectKey", this.primaryObjectKey);
        }
    }

    public FieldStandardsManager getFSM(Integer n) {
        return (FieldStandardsManager)this.fieldStandardsManagers.get(n);
    }

    public void setFSM(Integer n, FieldStandardsManager fieldStandardsManager) {
        this.fieldStandardsManagers.put(n, fieldStandardsManager);
    }

    public void assembleFSM(Integer n, InsightBackendConnector insightBackendConnector) {
        if (insightBackendConnector != null) {
            if (n == null) {
                Iterator iterator = this.uniqueCollectionIDs.iterator();
                while (iterator.hasNext()) {
                    Integer n2 = (Integer)iterator.next();
                    FieldStandardsManager fieldStandardsManager = ((TrinityConnector)insightBackendConnector).assembleFSM(n2, true);
                    this.setFSM(n2, fieldStandardsManager);
                }
            } else {
                FieldStandardsManager fieldStandardsManager = ((TrinityConnector)insightBackendConnector).assembleFSM(n, true);
                this.setFSM(n, fieldStandardsManager);
            }
        }
    }

    public FieldStandard getFieldStandardTemplate(String string) {
        Iterator iterator = this.fieldStandardsManagers.values().iterator();
        while (iterator.hasNext()) {
            FieldStandardsManager fieldStandardsManager = (FieldStandardsManager)iterator.next();
            Iterator iterator2 = fieldStandardsManager.getFieldStandards().iterator();
            while (iterator2.hasNext()) {
                FieldStandard fieldStandard = (FieldStandard)iterator2.next();
                if (!fieldStandard.isTemplate() || !fieldStandard.getStandardName().equals(string)) continue;
                return fieldStandard;
            }
        }
        return null;
    }

    public void setUniqueCollectionIDs(InsightBackendConnector insightBackendConnector) {
        List list;
        if (insightBackendConnector != null && (list = insightBackendConnector.getUniqueCollectionIDs()) != null) {
            this.uniqueCollectionIDs = list;
        }
    }

    public List getUniqueCollectionIDs() {
        return this.uniqueCollectionIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getServerRebuildLock() {
        boolean bl = false;
        MutableBoolean mutableBoolean = this.isServerRebuildingLock;
        synchronized (mutableBoolean) {
            if (!this.isServerRebuildingLock.getValue()) {
                this.isServerRebuildingLock.setValue(true);
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseServerRebuildLock() {
        MutableBoolean mutableBoolean = this.isServerRebuildingLock;
        synchronized (mutableBoolean) {
            if (this.isServerRebuildingLock.getValue()) {
                this.isServerRebuildingLock.setValue(false);
            }
        }
    }

    public void setMedeEnabled() {
        this.setMedeEnabled(this.getBackendConnector());
    }

    public void setMedeEnabled(InsightBackendConnector insightBackendConnector) {
        if (insightBackendConnector != null) {
            this.MEDE_ENABLED = insightBackendConnector.isMedeEnabled();
            this.debugOut("MEDE_ENABLED -> " + this.MEDE_ENABLED);
            if (this.MEDE_ENABLED) {
                if (this.MEDE_PUBLISHER == null) {
                    this.debugOut("MEDE_PUBLISHER -> starting.");
                    this.MEDE_PUBLISHER = new MedePublisher(this.getMedeConnector(), this.MEDE_PUBLISH_CHANGES_INTERVAL, this.MEDE_GATHER_INFO_INTERVAL, this.MEDE_PUBLISH_CHANGES_BLOCK_MODE, this.MEDE_PUBLISH_CHANGES_BATCH_SIZE, this.MEDE_PUBLISH_TERM_INDEX_MODE, this.MEDE_PUBLISH_TERM_INDEX_INTERVAL, this.MEDE_PUBLISH_TERM_INDEX_FIRSTTIME, this);
                    if (this.MEDE_PUBLISH_CHANGES_INTERVAL > 0L) {
                        this.MEDE_PUBLISHER.start();
                    } else {
                        this.debugOut("MEDE_PUBLISHER -> NOT starting.");
                    }
                }
            } else {
                if (this.MEDE_PUBLISHER != null) {
                    this.debugOut("MEDE_PUBLISHER -> stopping.");
                    this.MEDE_PUBLISHER.setStillNeeded(false);
                }
                this.MEDE_PUBLISHER = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearEntityCaches() {
        if (this.connectionPools == null || this.connectionPools.size() == 0) {
            return;
        }
        Vector vector = this.getUserGroups();
        synchronized (vector) {
            for (int i = 0; i < this.connectionPools.size(); ++i) {
                UserGroupConnectionPool userGroupConnectionPool = (UserGroupConnectionPool)this.connectionPools.elementAt(i);
                Vector vector2 = userGroupConnectionPool.getSessions();
                for (int j = 0; vector2 != null && j < vector2.size(); ++j) {
                    UserGroupConnection userGroupConnection = (UserGroupConnection)vector2.elementAt(j);
                    try {
                        userGroupConnection.getThumbnailQueryCache().clearEntitySearchQueries();
                        userGroupConnection.getThumbnailQueryCache().setEntityEquivalenceQuery(null);
                        continue;
                    }
                    catch (Exception exception) {
                        this.debugOut("Exception in clearEntityCaches(): " + exception);
                    }
                }
            }
        }
    }

    public void setDbVersion() {
        this.setDbVersion(this.getBackendConnector());
    }

    public void setDbVersion(InsightBackendConnector insightBackendConnector) {
        if (insightBackendConnector != null) {
            this.DB_VERSION = insightBackendConnector.getDatabaseVersion();
            this.debugOut("Database version: " + this.DB_VERSION);
        }
    }

    public void logSearchQuery(ThumbnailQuery thumbnailQuery, String string, String string2, String string3, String string4, String string5, String string6) {
        if (this.searchQueryLogFilename != null && this.searchQueryLogFilename.length() > 0) {
            try {
                ThumbnailQueryLogger.logSearchQuery((String)this.searchQueryLogFilename, (String)"JVA", (ThumbnailQuery)thumbnailQuery, (String)string, (String)string2, (String)string3, (String)string4, (String)string5, (String)string6);
            }
            catch (Exception exception) {
                this.debugOut("Exception while constructing log string:\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                this.debugOut("Error while constructing log string:\n" + InsightUtilities.getStackTrace(error));
            }
        }
    }

    public void setThumbnailQueryCache(ThumbnailQueryCache thumbnailQueryCache) {
        this.thumbQueryCache = thumbnailQueryCache;
    }

    public ThumbnailQueryCache getThumbnailQueryCache() {
        return this.thumbQueryCache;
    }

    public int getGroupRecordCount(int n) {
        Integer n2 = (Integer)this.groupRecordCountCache.get(n + "");
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    public void setGroupRecordCount(int n, int n2) {
        int n3 = this.getGroupRecordCount(n);
        if (n2 >= n3) {
            this.groupRecordCountCache.put(n + "", new Integer(n2));
        }
    }

    public void assembleDefaultThumbnailQueries(Integer n) {
        InsightSmartServicer insightSmartServicer = new InsightSmartServicer(null, this);
        InsightBackendConnector insightBackendConnector = this.getBackendConnector();
        Vector vector = insightBackendConnector.getThumbnailQueries(n);
        Vector vector2 = this.getFSM(n).getFieldStandards();
        ThumbnailQuery thumbnailQuery = null;
        Vector vector3 = null;
        Object[] objectArray = null;
        FieldStandard fieldStandard = null;
        Object object = null;
        ThumbnailQuery thumbnailQuery2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            thumbnailQuery = (ThumbnailQuery)vector.elementAt(i);
            if (i == 0) {
                this.getThumbnailQueryCache().clearThumbnailQueries(thumbnailQuery.getGroupID());
            }
            vector3 = insightBackendConnector.getInitialSearchCriteria(thumbnailQuery.getInstitutionID(), thumbnailQuery.getCollectionID(), thumbnailQuery.getVCID());
            objectArray = new FieldCriterion[]{};
            if (vector3 != null) {
                objectArray = new FieldCriterion[vector3.size()];
                vector3.copyInto(objectArray);
            }
            for (int j = 0; j < vector2.size(); ++j) {
                fieldStandard = (FieldStandard)vector2.elementAt(j);
                if (!fieldStandard.createThumbCache() || !fieldStandard.isEnabled()) continue;
                this.debugOut("Creating default thumbnail cache for standard: " + fieldStandard.standardName + ".");
                for (int k = 0; k < objectArray.length; ++k) {
                    object = objectArray[k];
                    ((FieldCriterion)object).fieldMapping = this.getFSM(n).getFieldMappingInStandard(fieldStandard.standardName, ((FieldCriterion)object).field.fieldName);
                }
                thumbnailQuery2 = new ThumbnailQuery(thumbnailQuery, thumbnailQuery.getCollectionName(), thumbnailQuery.getGroupID(), fieldStandard.getStartThumbFields(), fieldStandard.getStartSortFields(), objectArray, false, thumbnailQuery.getThumbnailSize(), thumbnailQuery.getProfileID(false), thumbnailQuery.getUserCollection(false), thumbnailQuery.refuseResultCache());
                thumbnailQuery2 = insightSmartServicer.doThumbnailQuery(thumbnailQuery2, n);
                this.getThumbnailQueryCache().addThumbnailQuery(thumbnailQuery2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServerThumbnailCaches(Integer n, List list) {
        try {
            Object object = this.updateServerThumbCacheLock;
            synchronized (object) {
                this.debugOut("Updating server thumbnail caches.");
                if (InsightUtilities.isNonEmpty(list)) {
                    Vector vector = this.getThumbnailQueryCache().getThumbnailQueries();
                    for (int i = 0; vector != null && i < vector.size(); ++i) {
                        ThumbnailQuery thumbnailQuery = (ThumbnailQuery)vector.get(i);
                        ThumbnailResultCache thumbnailResultCache = thumbnailQuery.getThumbnailResultCache();
                        if (thumbnailResultCache != null && thumbnailResultCache.getUniqueCollectionID().equals(n)) {
                            List list2 = this.getSpecificThumbnails(thumbnailQuery, list);
                            thumbnailResultCache.replaceThumbnails(list, list2);
                            continue;
                        }
                        this.debugOut(thumbnailQuery.toKeyString() + " -> Thumbnail result cache is missing.");
                    }
                    Vector vector2 = this.getUserGroups();
                    synchronized (vector2) {
                        for (int i = 0; i < this.connectionPools.size(); ++i) {
                            UserGroupConnectionPool userGroupConnectionPool = (UserGroupConnectionPool)this.connectionPools.elementAt(i);
                            Vector vector3 = userGroupConnectionPool.getSessions();
                            for (int j = 0; vector3 != null && j < vector3.size(); ++j) {
                                UserGroupConnection userGroupConnection = (UserGroupConnection)vector3.elementAt(j);
                                try {
                                    userGroupConnection.getThumbnailQueryCache().clearThumbnailQueries();
                                    continue;
                                }
                                catch (Exception exception) {
                                    this.debugOut("Exception in updateServerThumbnailCaches(): " + exception);
                                }
                            }
                        }
                    }
                    TrinityConnector.clearuniqueListCache();
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateServerThumbnailCaches():\n" + InsightUtilities.getStackTrace(exception));
        }
    }

    public List getSpecificThumbnails(ThumbnailQuery thumbnailQuery, List list) {
        Vector vector = new Vector(0);
        if (thumbnailQuery != null && InsightUtilities.isNonEmpty(list)) {
            InsightBackendConnector insightBackendConnector = this.getBackendConnector();
            Vector vector2 = null;
            MultiObjectIndicatorFieldCriterion multiObjectIndicatorFieldCriterion = new MultiObjectIndicatorFieldCriterion();
            Object[] objectArray = new FieldCriterion[]{multiObjectIndicatorFieldCriterion};
            for (int i = 0; i < list.size(); ++i) {
                multiObjectIndicatorFieldCriterion.addObjectID((Long)list.get(i));
                if (multiObjectIndicatorFieldCriterion.size() < 100 && i != list.size() - 1) continue;
                vector2 = insightBackendConnector.performThumbnailQuery(thumbnailQuery.getGroupID(), thumbnailQuery.getCaptionFields(), thumbnailQuery.getSortFields(), objectArray, false, thumbnailQuery.getThumbnailSize(), thumbnailQuery.getProfileID(), thumbnailQuery.getUserCollection(), false, thumbnailQuery.getStart(), thumbnailQuery.getLength(), null, false);
                if (InsightUtilities.isNonEmpty(vector2)) {
                    vector.addAll(vector2);
                }
                multiObjectIndicatorFieldCriterion.clear();
            }
        }
        return vector;
    }

    public CollectionBuildingTemplate getCollectionBuildingTemplate() {
        CollectionBuildingTemplate collectionBuildingTemplate = new CollectionBuildingTemplate(this.getMedeConnector().getCatalogTemplates(), this.getMedeConnector().getMappingStandards());
        collectionBuildingTemplate.setStandardNames(this.getMedeConnector().getAllStandardNames());
        return collectionBuildingTemplate;
    }

    public boolean isMediaSecurityEnabled() {
        return this.MEDIA_SECURITY_ENABLED;
    }

    public boolean isMediaSecurityTicketlessMode() {
        return this.MEDIA_SECURITY_ENABLED && this.mediaSecurityHandler.isTicketlessMode();
    }

    public String getMediaSecurityTicket(int n, String string) {
        String string2 = null;
        if (this.MEDIA_SECURITY_ENABLED && this.mediaSecurityHandler != null) {
            try {
                string2 = MediaSecurityHandler.generateTicket();
                String string3 = MediaSecurityUtilities.getRegisterTicketParams((String)string2, (int)this.mediaSecurityHandler.getTicketDuration(), (int)n, (String)string);
                MediaSecurityUtilities.registerTicket((String)this.mediaSecurityHandler.getServletBaseUrl(), (String)this.mediaSecurityHandler.encrypt(string3));
            }
            catch (Exception exception) {
                this.debugOut("Exception in getMediaSecurityTicket():\n" + InsightUtilities.getStackTrace(exception));
                string2 = null;
            }
        }
        return string2;
    }

    public String getMediaSecurityServletBaseUrl() {
        if (this.mediaSecurityHandler == null) {
            return null;
        }
        return this.mediaSecurityHandler.getServletBaseUrl();
    }

    public String getMediaSecurityKey() {
        if (this.mediaSecurityHandler == null) {
            return null;
        }
        return this.mediaSecurityHandler.getSecurityKey();
    }

    public void publishLinks(CollectionKey collectionKey, Vector vector, Integer n) {
        if (this.getFSM(n).supportsLinkSearching() && collectionKey != null) {
            Vector vector2;
            String string = LinkCodeGenerator.getCollectionLinkCode((CollectionKey)collectionKey);
            if (!this.getLinkInventory().isInInventory(string)) {
                vector2 = this.getLinkFileManager().getLinks(collectionKey);
                if (vector2 != null && vector2.size() > 0) {
                    this.publishLinks(vector2, string, n);
                }
            } else {
                this.debugOut("Link code " + string + " already in inventory.");
            }
            UserGroupShell userGroupShell = null;
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                userGroupShell = (UserGroupShell)vector.elementAt(i);
                string = LinkCodeGenerator.getGroupLinkCode((CollectionKey)collectionKey, (String)userGroupShell.getName(), (String)userGroupShell.getCodeKey());
                if (!this.getLinkInventory().isInInventory(string)) {
                    vector2 = this.getLinkFileManager().getLinks(collectionKey, userGroupShell.getName(), userGroupShell.getCodeKey());
                    if (vector2 == null || vector2.size() <= 0) continue;
                    this.publishLinks(vector2, string, n);
                    continue;
                }
                this.debugOut("Link code " + string + " already in inventory.");
            }
        }
    }

    public void publishLinks(Vector vector, String string, Integer n) {
        if (this.getFSM(n).supportsLinkSearching() && vector != null && vector.size() > 0) {
            this.getBackendConnector().addMultipleLinkData(vector, string, this.getFSM(n).getLinkStandard());
            this.getLinkInventory().addToInventory(string, vector.size());
        }
    }

    public void publishLink(LinkData linkData, String string, Integer n) {
        if (this.getFSM(n).supportsLinkSearching()) {
            this.getBackendConnector().addLinkData(linkData, string, this.getFSM(n).getLinkStandard());
            this.getLinkInventory().addToInventory(string, 1);
        }
    }

    public void unpublishLinksWithFragment(String string) {
        Iterator iterator = this.getUniqueCollectionIDs().iterator();
        while (iterator.hasNext()) {
            if (!this.getFSM((Integer)iterator.next()).supportsLinkSearching()) continue;
            Vector vector = this.getLinkInventory().getLinkCodesWithFragment(string);
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                this.getBackendConnector().removeLinkDataWithLinkCode((String)vector.elementAt(i));
                this.getLinkInventory().wipeFromInventory((String)vector.elementAt(i));
            }
        }
    }

    public void unpublishLinks(Vector vector, String string) {
        Iterator iterator = this.getUniqueCollectionIDs().iterator();
        while (iterator.hasNext()) {
            if (!this.getFSM((Integer)iterator.next()).supportsLinkSearching() || vector == null || vector.size() <= 0) continue;
            this.getBackendConnector().removeMultipleLinkData(vector, string);
            this.getLinkInventory().removeFromInventory(string, vector.size());
        }
    }

    public void unpublishLink(String string, Rectangle rectangle, long l) {
        Iterator iterator = this.getUniqueCollectionIDs().iterator();
        while (iterator.hasNext()) {
            if (!this.getFSM((Integer)iterator.next()).supportsLinkSearching()) continue;
            this.getBackendConnector().removeSpecificLinkData(string, rectangle, l);
            this.getLinkInventory().removeFromInventory(string, 1);
        }
    }

    public LinkInventoryTracker getLinkInventory() {
        return this.linkInventory;
    }

    public LinkFileManager getLinkFileManager() {
        return this.linkFileManager;
    }

    public ThemeFileManager getThemeFileManager() {
        return this.themeFileManager;
    }

    public InsightLicenseManager getInsightLicenseManager() {
        return this.licenseManager;
    }

    public InsightLicensedSessionManager getInsightLicensedSessionManager() {
        return this.licensedSessionManager;
    }

    public PresentationFileManager getPresFileManager() {
        return this.presFileManager;
    }

    public MultiviewImageFileManager getMviFileManager() {
        return this.mviFileManager;
    }

    public Hashtable getHelpFileNames() {
        return this.helpFileNames;
    }

    public Hashtable getBackendParameters() {
        return this.getBackendParameters(false);
    }

    public Hashtable getBackendParameters(boolean bl) {
        if (this.BACKEND_PARAMETERS == null || bl) {
            this.BACKEND_PARAMETERS = InsightBackendConnector.packageParameters(this.connectString, this.MS_ACCESS_MODE, this.CHAR_WILDCARD, this.STRING_WILDCARD, this.LEFT_ESCAPE_DELIM, this.RIGHT_ESCAPE_DELIM, this.COLLECTION_LOCALE, this.DATABASE_QUERY_MODE, this.DATABASE_GLOBALESCAPEDELIMITER, this.DATABASE_UNICODEFIELDPREFIX, this.USE_LOWER_CASE_COMMAND, this.USE_LOWER_CASE_COMMAND_ON_SEARCH_VALUE, this.USE_VALUE_FROM_SUB_QUERY, this.USE_DISTINCT_KEYWORD, this.USE_UNIQUELIST_CACHE, this.CASE_INSENSITIVE_COMPARISON, this.USE_SQL_COUNT_FOR_THRESHOLD, this.USE_DISTINCT_IN_COUNT, this.FUZZY_DATES, this.DB_CONNECTOR_GENERATOR, this.MEDIA_INFO_TABLE_NAME, this.DIACRITIC_MAPPINGS);
        }
        return this.BACKEND_PARAMETERS;
    }

    public InsightBackendConnector getBackendConnector() {
        InsightBackendConnector insightBackendConnector = this.UCB_DB ? new UcbSupportConnector(this.getBackendParameters(), this.MIP_PROPS, this.UCB_TABLE_NAMES) : (this.DB_VERSION >= TrinityConnector.TRINITY_VERSION ? new TrinityConnector(this.getBackendParameters()) : new InsightBackendConnector(this.getBackendParameters()));
        if (this.OBJECTS_EDITABLE) {
            insightBackendConnector.IG_TABLE_OBJECTS = this.primaryObjectTable;
            insightBackendConnector.IG_TABLE_OBJECTS_KEY = this.primaryObjectKey;
        }
        return insightBackendConnector;
    }

    public MedeConnector getMedeConnector() {
        return new MedeConnector(this.getBackendParameters(), this.getMedePublisher());
    }

    public boolean doingImmediateMedePublishing() {
        return this.MEDE_PUBLISHER != null && this.MEDE_PUBLISH_CHANGES_INTERVAL == 0L;
    }

    public void publishImmediately(Integer n, boolean bl) {
        this.MEDE_PUBLISHER.publishImmediately(n, bl);
    }

    public MedePublisher getMedePublisher() {
        return this.MEDE_PUBLISHER;
    }

    public String pluralize(int n) {
        if (n == 1) {
            return "";
        }
        return "s";
    }

    public String getDebugPrefix() {
        if (this.serverShortName.length() > 0) {
            return this.serverShortName;
        }
        return COMPONENT_CODE;
    }

    public void setKeepGoing(boolean bl) {
        this.keepGoing = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String readTextFromFile(String string) {
        String string2;
        block13: {
            FileInputStream fileInputStream;
            block12: {
                string2 = "";
                fileInputStream = null;
                this.debugOut("ISS: Reading text from file " + string + ".");
                File file = new File(string);
                byte[] byArray = new byte[(int)file.length()];
                fileInputStream = new FileInputStream(file);
                int n = fileInputStream.read(byArray);
                fileInputStream.close();
                if (n == byArray.length) {
                    string2 = new String(byArray);
                    break block12;
                }
                this.debugOut("ISS: The required bytes were not read.");
            }
            Object var8_8 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block13;
            }
            catch (IOException iOException) {}
            break block13;
            {
                catch (Exception exception) {
                    this.debugOut("ISS: Exception in readTextFromFile, exc: " + exception);
                    string2 = "";
                    Object var8_9 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block13;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return string2;
    }

    protected void gatherCommandLine(String[] stringArray) {
        if (stringArray.length >= 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-p")) {
                    if (stringArray.length <= i + 1 || stringArray[i + 1] == null) continue;
                    ++i;
                    try {
                        this.listenPortNumber = Integer.parseInt(stringArray[i]);
                        this.debugOut("listenPortNumber is " + this.listenPortNumber);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.debugOut("NumberFormatException occured.");
                    }
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-connectstring")) {
                    if (stringArray.length <= i + 1 || stringArray[i + 1] == null) continue;
                    this.connectString = stringArray[++i];
                    this.debugOut("connectString is " + this.connectString);
                    continue;
                }
                if (stringArray[i].equals("-u")) {
                    if (stringArray.length <= i + 1 || stringArray[i + 1] == null) continue;
                    this.userConnectString = stringArray[++i];
                    this.debugOut("userConnectString is " + this.userConnectString);
                    continue;
                }
                if (stringArray[i].equals("-nu")) {
                    this.userConnectString = "";
                    this.debugOut("Not serving user database.");
                    continue;
                }
                if (!stringArray[i].equals("-d") || stringArray.length <= i + 1 || stringArray[i + 1] == null) continue;
                ++i;
                try {
                    int n = Integer.parseInt(stringArray[i]);
                    Debug.setDebugLevel(n);
                    System.out.println("ISS: Setting debug level to " + Debug.LEVELS[Debug.getDebugLevel()] + ".");
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public Vector getServerSerializedClasses() {
        if (this.SERVER_SERIALIZED_CLASSES == null) {
            this.SERVER_SERIALIZED_CLASSES = new Vector();
            this.SERVER_SERIALIZED_CLASSES.addElement("AnnotationLinkData");
            this.SERVER_SERIALIZED_CLASSES.addElement("AudioFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("CollectionInfo");
            this.SERVER_SERIALIZED_CLASSES.addElement("CollectionKeyWrapper");
            this.SERVER_SERIALIZED_CLASSES.addElement("CriterionValue");
            this.SERVER_SERIALIZED_CLASSES.addElement("DatabaseConnectorGenerator");
            this.SERVER_SERIALIZED_CLASSES.addElement("DateCriterionValue");
            this.SERVER_SERIALIZED_CLASSES.addElement("Entity");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityBuilder");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityChange");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityChangeList");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityChangeListBuilder");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityField");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityFieldChange");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityFieldValue");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityKeyWrapper");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityLock");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityMapChange");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityMediaMapChange");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityRelationship");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntitySearchQuery");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntitySearchResult");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityType");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityTypeBuilder");
            this.SERVER_SERIALIZED_CLASSES.addElement("EntityValueDetails");
            this.SERVER_SERIALIZED_CLASSES.addElement("Field");
            this.SERVER_SERIALIZED_CLASSES.addElement("FieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("FieldListResult");
            this.SERVER_SERIALIZED_CLASSES.addElement("FieldMapping");
            this.SERVER_SERIALIZED_CLASSES.addElement("FieldStandard");
            this.SERVER_SERIALIZED_CLASSES.addElement("FieldStandardMismatches");
            this.SERVER_SERIALIZED_CLASSES.addElement("FieldStandardsManager");
            this.SERVER_SERIALIZED_CLASSES.addElement("FieldValue");
            this.SERVER_SERIALIZED_CLASSES.addElement("FieldValueGroup");
            this.SERVER_SERIALIZED_CLASSES.addElement("FontDescriptor");
            this.SERVER_SERIALIZED_CLASSES.addElement("FuzzyDateFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("FuzzyDateJulianRange");
            this.SERVER_SERIALIZED_CLASSES.addElement("GroupInformation");
            this.SERVER_SERIALIZED_CLASSES.addElement("HierarchyAncillaryData");
            this.SERVER_SERIALIZED_CLASSES.addElement("HierarchyNodeData");
            this.SERVER_SERIALIZED_CLASSES.addElement("HierarchyNodeFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("HierarchyNodePath");
            this.SERVER_SERIALIZED_CLASSES.addElement("ImageFile");
            this.SERVER_SERIALIZED_CLASSES.addElement("ImageGroupFile");
            this.SERVER_SERIALIZED_CLASSES.addElement("ImageInGroup");
            this.SERVER_SERIALIZED_CLASSES.addElement("ImageLinkData");
            this.SERVER_SERIALIZED_CLASSES.addElement("ImageSeries");
            this.SERVER_SERIALIZED_CLASSES.addElement("ImageSeriesSlide");
            this.SERVER_SERIALIZED_CLASSES.addElement("ImageToProcess");
            this.SERVER_SERIALIZED_CLASSES.addElement("InsightJtipImage");
            this.SERVER_SERIALIZED_CLASSES.addElement("InsightJtipTile");
            this.SERVER_SERIALIZED_CLASSES.addElement("InsightResourceBundle");
            this.SERVER_SERIALIZED_CLASSES.addElement("InsightSmartClientResults");
            this.SERVER_SERIALIZED_CLASSES.addElement("InsightTransientPackager");
            this.SERVER_SERIALIZED_CLASSES.addElement("InsightUser");
            this.SERVER_SERIALIZED_CLASSES.addElement("InsightVersion");
            this.SERVER_SERIALIZED_CLASSES.addElement("IntegerRange");
            this.SERVER_SERIALIZED_CLASSES.addElement("KeepAliveMessage");
            this.SERVER_SERIALIZED_CLASSES.addElement("KeywordsFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("LinkAuthorshipInfo");
            this.SERVER_SERIALIZED_CLASSES.addElement("LinkData");
            this.SERVER_SERIALIZED_CLASSES.addElement("LinkFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("LinkFieldMapping");
            this.SERVER_SERIALIZED_CLASSES.addElement("MedePrivileges");
            this.SERVER_SERIALIZED_CLASSES.addElement("MediaFetchFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("MediaField");
            this.SERVER_SERIALIZED_CLASSES.addElement("MediaMetaData");
            this.SERVER_SERIALIZED_CLASSES.addElement("MediaSearchQuery");
            this.SERVER_SERIALIZED_CLASSES.addElement("MediaSearchResult");
            this.SERVER_SERIALIZED_CLASSES.addElement("MpdSearchResults");
            this.SERVER_SERIALIZED_CLASSES.addElement("MpdFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("MultipageDocumentLevel");
            this.SERVER_SERIALIZED_CLASSES.addElement("MultipageDocumentNode");
            this.SERVER_SERIALIZED_CLASSES.addElement("MultipageDocumentPage");
            this.SERVER_SERIALIZED_CLASSES.addElement("MultipageDocumentPathEntry");
            this.SERVER_SERIALIZED_CLASSES.addElement("MultipageDocumentSeries");
            this.SERVER_SERIALIZED_CLASSES.addElement("MultiviewImageSeries");
            this.SERVER_SERIALIZED_CLASSES.addElement("MultiviewImageSlide");
            this.SERVER_SERIALIZED_CLASSES.addElement("MutableBoolean");
            this.SERVER_SERIALIZED_CLASSES.addElement("MutableInteger");
            this.SERVER_SERIALIZED_CLASSES.addElement("MutableLong");
            this.SERVER_SERIALIZED_CLASSES.addElement("MviFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("ObjectDataRecord");
            this.SERVER_SERIALIZED_CLASSES.addElement("ObjectDimension");
            this.SERVER_SERIALIZED_CLASSES.addElement("ObjectIndicatorFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("OrphanSearchFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("QtvrFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("SimpleDate");
            this.SERVER_SERIALIZED_CLASSES.addElement("StringCriterionValue");
            this.SERVER_SERIALIZED_CLASSES.addElement("ThesaurusRelationType");
            this.SERVER_SERIALIZED_CLASSES.addElement("ThumbnailDistribution");
            this.SERVER_SERIALIZED_CLASSES.addElement("ThumbnailQuery");
            this.SERVER_SERIALIZED_CLASSES.addElement("ThumbnailQueryCache");
            this.SERVER_SERIALIZED_CLASSES.addElement("ThumbnailResultCache");
            this.SERVER_SERIALIZED_CLASSES.addElement("ThumbnailTallyMark");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityCollection");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityCollectionInfo");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityField");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityFieldGroup");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityHierarchyNode");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityJoin");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityKeywordID");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityTable");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityTermObjectToMap");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityTermToFilter");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityTermToIndex");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityValueGrouping");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityValueObjectToMap");
            this.SERVER_SERIALIZED_CLASSES.addElement("TrinityValueToIndex");
            this.SERVER_SERIALIZED_CLASSES.addElement("UcbHierarchyNodeData");
            this.SERVER_SERIALIZED_CLASSES.addElement("UcbTreeNodeFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("UserGroupSessionResults");
            this.SERVER_SERIALIZED_CLASSES.addElement("UserGroupShell");
            this.SERVER_SERIALIZED_CLASSES.addElement("VideoFieldCriterion");
            this.SERVER_SERIALIZED_CLASSES.addElement("VirtualCollectionInfo");
            this.SERVER_SERIALIZED_CLASSES.addElement("WebLinkData");
        }
        return this.SERVER_SERIALIZED_CLASSES;
    }

    public static InsightSmartServer getPrimaryServerInstance() {
        return primaryServerInstance;
    }

    public String getBrowserRemoteLaunchURL() {
        return this.browserRemoteLaunchURL;
    }

    public String getJvaRemoteLaunchURL() {
        return this.jvaRemoteLaunchURL;
    }

    private boolean loadServiceComponents() {
        InsightVersion insightVersion = new InsightVersion(5, 50, 21);
        File[] fileArray = new File(COMPONENTS_DIRECTORY).listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            File file = fileArray[i];
            URLClassLoader uRLClassLoader = null;
            try {
                uRLClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()});
            }
            catch (MalformedURLException malformedURLException) {
                Debug.debugOutAlways("Failed to load Service Component jar file " + file.getName());
                Debug.debugOutAlways(malformedURLException);
                return false;
            }
            Iterator iterator = Service.providers((Class)SERVICE_INTERFACE, (ClassLoader)uRLClassLoader);
            while (iterator.hasNext()) {
                ServiceComponent serviceComponent = (ServiceComponent)iterator.next();
                String string = serviceComponent.getCommonName();
                int[] nArray = serviceComponent.getCommandRange();
                if (string == null || string.equals("")) {
                    Debug.debugOutAlways("Failed to load service.  Service name is empty.");
                    return false;
                }
                if (!hashSet.add(string)) {
                    Debug.debugOutAlways("Failed to load service " + string + ".  Name already in use.");
                    return false;
                }
                if (DISALLOWED_SERVICE_NAMES.contains(string)) {
                    Debug.debugOutAlways("Failed to load service " + string + ".  Collection Manager does not allow this service.");
                    return false;
                }
                if (nArray == null || nArray.length != 2 || nArray[1] < nArray[0]) {
                    Debug.debugOutAlways("Failed to load service " + string + ". Invalid command range.");
                    return false;
                }
                if (nArray[0] < 1001) {
                    Debug.debugOutAlways("Failed to load service " + string + ". Command range is reserved by server.");
                    return false;
                }
                Iterator iterator2 = SERVICE_LIST.iterator();
                while (iterator2.hasNext()) {
                    ServiceComponent serviceComponent2 = (ServiceComponent)iterator2.next();
                    int[] nArray2 = serviceComponent2.getCommandRange();
                    if ((nArray[0] >= nArray2[0] || nArray[1] < nArray2[0]) && (nArray[0] < nArray2[0] || nArray[0] > nArray2[1])) continue;
                    Debug.debugOutAlways("Failed to load service " + string + ".  Command range conflicts with service " + serviceComponent2.getCommonName());
                    return false;
                }
                if (serviceComponent.getMinimumServerVersion() != null && !InsightVersion.compareVersions(insightVersion, serviceComponent.getMinimumServerVersion(), 7)) {
                    Debug.debugOutAlways("Failed to load service " + string + ".  This service requires server version " + insightVersion);
                    return false;
                }
                SERVICE_LIST.add(serviceComponent);
                Debug.debugOut("Loaded service " + string);
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

