/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import java.awt.Dimension;
import java.io.Serializable;
import java.util.Vector;

public class ImageFile
implements Serializable {
    static final long serialVersionUID = 162127093974974518L;
    public static final int MEDIA_TYPE_IMAGE = 1;
    public static final int MEDIA_TYPE_AUDIO = 2;
    public static final int MEDIA_TYPE_VIDEO = 3;
    public static final int MEDIA_TYPE_QTVR = 4;
    public static final String MEDIA_TYPE_IMAGE_STR = "Image";
    public static final String MEDIA_TYPE_AUDIO_STR = "Audio";
    public static final String MEDIA_TYPE_VIDEO_STR = "Video";
    public static final String MEDIA_TYPE_QTVR_STR = "QTVR";
    public static final int IMAGE_TYPE_JPEG = 0;
    public static final int IMAGE_TYPE_SID = 1;
    public static final int IMAGE_TYPE_JTIP = 2;
    public static final int IMAGE_TYPE_JP2 = 13;
    public static final int AUDIO_TYPE = 3;
    public static final int AUDIO_TYPE_LINEAR = 4;
    public static final int AUDIO_TYPE_MP3 = 5;
    public static final int AUDIO_TYPE_ULAW = 6;
    public static final int VIDEO_TYPE = 7;
    public static final int VIDEO_TYPE_CVID = 8;
    public static final int VIDEO_TYPE_MPG1 = 9;
    public static final int VIDEO_TYPE_YUV = 10;
    public static final int VIDEO_TYPE_RGB = 11;
    public static final int QTVR_TYPE = 12;
    public static final String IMAGE_TYPE_JPEG_STR = "JPEG";
    public static final String IMAGE_TYPE_SID_STR = "SID";
    public static final String IMAGE_TYPE_JTIP_STR = "JTIP";
    public static final String IMAGE_TYPE_JP2_STR = "JP2";
    public static final String AUDIO_TYPE_STR = "AUDIO";
    public static final String AUDIO_TYPE_LINEAR_STR = "LINEAR";
    public static final String AUDIO_TYPE_MP3_STR = "MP3";
    public static final String AUDIO_TYPE_ULAW_STR = "ULAW";
    public static final String VIDEO_TYPE_STR = "VIDEO";
    public static final String VIDEO_TYPE_CVID_STR = "CVID";
    public static final String VIDEO_TYPE_MPG1_STR = "MPG1";
    public static final String VIDEO_TYPE_YUV_STR = "YUV";
    public static final String VIDEO_TYPE_RGB_STR = "RGB";
    public static final String QTVR_TYPE_STR = "QTVR";
    public long imageID;
    public Dimension imageSize = null;
    public int resolution;
    public String URL = null;
    public String filename = null;
    public int format = 0;
    public int mediaType = 1;

    public static String[] getMediaTypeStrings() {
        return new String[]{MEDIA_TYPE_IMAGE_STR, MEDIA_TYPE_AUDIO_STR, MEDIA_TYPE_VIDEO_STR, "QTVR"};
    }

    public static String[] getFormatTypeStrings() {
        return new String[]{IMAGE_TYPE_JPEG_STR, IMAGE_TYPE_JP2_STR, IMAGE_TYPE_SID_STR, IMAGE_TYPE_JTIP_STR, AUDIO_TYPE_STR, VIDEO_TYPE_STR, "QTVR"};
    }

    public static String getGeneralFormatString(String string) {
        int n = ImageFile.getFormatTypeToInt(string);
        String string2 = IMAGE_TYPE_JPEG_STR;
        try {
            switch (n) {
                case 0: {
                    string2 = IMAGE_TYPE_JPEG_STR;
                    break;
                }
                case 1: {
                    string2 = IMAGE_TYPE_SID_STR;
                    break;
                }
                case 2: {
                    string2 = IMAGE_TYPE_JTIP_STR;
                    break;
                }
                case 13: {
                    string2 = IMAGE_TYPE_JP2_STR;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string2 = AUDIO_TYPE_STR;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string2 = VIDEO_TYPE_STR;
                    break;
                }
                case 12: {
                    string2 = "QTVR";
                    break;
                }
                default: {
                    string2 = IMAGE_TYPE_JPEG_STR;
                    break;
                }
            }
        }
        catch (Exception exception) {
            string2 = IMAGE_TYPE_JPEG_STR;
        }
        return string2;
    }

    public static int getMediaTypeToInt(String string) {
        int n = 1;
        try {
            if (string.equalsIgnoreCase(MEDIA_TYPE_IMAGE_STR)) {
                n = 1;
            } else if (string.equalsIgnoreCase(MEDIA_TYPE_AUDIO_STR)) {
                n = 2;
            } else if (string.equalsIgnoreCase(MEDIA_TYPE_VIDEO_STR)) {
                n = 3;
            } else if (string.equalsIgnoreCase("QTVR")) {
                n = 4;
            }
        }
        catch (Exception exception) {
            n = 1;
        }
        return n;
    }

    public static String getMediaTypeToString(int n) {
        String string = MEDIA_TYPE_IMAGE_STR;
        try {
            switch (n) {
                case 1: {
                    string = MEDIA_TYPE_IMAGE_STR;
                    break;
                }
                case 2: {
                    string = MEDIA_TYPE_AUDIO_STR;
                    break;
                }
                case 3: {
                    string = MEDIA_TYPE_VIDEO_STR;
                    break;
                }
                case 4: {
                    string = "QTVR";
                    break;
                }
                default: {
                    string = MEDIA_TYPE_IMAGE_STR;
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = MEDIA_TYPE_IMAGE_STR;
        }
        return string;
    }

    public static int getFormatTypeToInt(String string) {
        int n = 0;
        try {
            n = string.equalsIgnoreCase(IMAGE_TYPE_JPEG_STR) ? 0 : (string.equalsIgnoreCase(IMAGE_TYPE_SID_STR) ? 1 : (string.equalsIgnoreCase(IMAGE_TYPE_JTIP_STR) ? 2 : (string.equalsIgnoreCase(IMAGE_TYPE_JP2_STR) ? 13 : (string.equalsIgnoreCase(AUDIO_TYPE_STR) ? 3 : (string.equalsIgnoreCase(AUDIO_TYPE_LINEAR_STR) ? 4 : (string.equalsIgnoreCase(AUDIO_TYPE_MP3_STR) ? 5 : (string.equalsIgnoreCase(AUDIO_TYPE_ULAW_STR) ? 6 : (string.equalsIgnoreCase(VIDEO_TYPE_STR) ? 7 : (string.equalsIgnoreCase(VIDEO_TYPE_CVID_STR) ? 8 : (string.equalsIgnoreCase(VIDEO_TYPE_MPG1_STR) ? 9 : (string.equalsIgnoreCase(VIDEO_TYPE_YUV_STR) ? 10 : (string.equalsIgnoreCase(VIDEO_TYPE_RGB_STR) ? 11 : (string.equalsIgnoreCase("QTVR") ? 12 : 0)))))))))))));
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public static String getFormatTypeToString(int n) {
        String string = IMAGE_TYPE_JPEG_STR;
        try {
            switch (n) {
                case 0: {
                    string = IMAGE_TYPE_JPEG_STR;
                    break;
                }
                case 1: {
                    string = IMAGE_TYPE_SID_STR;
                    break;
                }
                case 2: {
                    string = IMAGE_TYPE_JTIP_STR;
                    break;
                }
                case 13: {
                    string = IMAGE_TYPE_JP2_STR;
                    break;
                }
                case 3: {
                    string = AUDIO_TYPE_STR;
                    break;
                }
                case 4: {
                    string = AUDIO_TYPE_LINEAR_STR;
                    break;
                }
                case 5: {
                    string = AUDIO_TYPE_MP3_STR;
                    break;
                }
                case 6: {
                    string = AUDIO_TYPE_ULAW_STR;
                    break;
                }
                case 7: {
                    string = VIDEO_TYPE_STR;
                    break;
                }
                case 8: {
                    string = VIDEO_TYPE_CVID_STR;
                    break;
                }
                case 9: {
                    string = VIDEO_TYPE_MPG1_STR;
                    break;
                }
                case 10: {
                    string = VIDEO_TYPE_YUV_STR;
                    break;
                }
                case 11: {
                    string = VIDEO_TYPE_RGB_STR;
                    break;
                }
                case 12: {
                    string = "QTVR";
                    break;
                }
                default: {
                    string = IMAGE_TYPE_JPEG_STR;
                    break;
                }
            }
        }
        catch (Exception exception) {
            string = IMAGE_TYPE_JPEG_STR;
        }
        return string;
    }

    public static ImageFile getImageFile(Vector vector, long l) {
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            ImageFile imageFile = (ImageFile)vector.elementAt(i);
            if (imageFile == null || imageFile.imageID != l) continue;
            return imageFile;
        }
        return null;
    }

    public ImageFile() {
    }

    public ImageFile(Dimension dimension, int n, String string, int n2) {
        this(dimension, n, string, n2, 1);
    }

    public ImageFile(Dimension dimension, int n, String string) {
        this(dimension, n, string, 0, 1);
    }

    public ImageFile(Dimension dimension, int n, String string, int n2, int n3) {
        this(dimension, n, string, n2, n3, "");
    }

    public ImageFile(Dimension dimension, int n, String string, int n2, int n3, String string2) {
        this.imageSize = dimension;
        this.resolution = n;
        this.URL = string;
        this.format = n2;
        this.mediaType = n3;
        this.filename = string2;
    }

    public ImageFile(ImageFile imageFile) {
        this.imageSize = new Dimension(imageFile.imageSize);
        this.resolution = imageFile.resolution;
        this.URL = new String(imageFile.URL);
        this.format = imageFile.format;
        this.mediaType = imageFile.mediaType;
    }

    public void setImageID(long l) {
        this.imageID = l;
    }

    public void setImageSize(Dimension dimension) {
        this.imageSize = dimension;
    }

    public void setResolution(int n) {
        this.resolution = n;
    }

    public void setUrl(String string) {
        this.URL = string;
    }

    public void setFormat(int n) {
        this.format = n;
    }

    public void setMediaType(int n) {
        this.mediaType = n;
    }

    public long getImageID() {
        return this.imageID;
    }

    public Dimension getImageSize() {
        return this.imageSize;
    }

    public int getResolution() {
        return this.resolution;
    }

    public String getUrl() {
        return this.URL;
    }

    public int getFormat() {
        return this.format;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public String toString() {
        return "ImageFile [w=" + this.imageSize.width + "; h=" + this.imageSize.height + "; r=" + this.resolution + "; f=" + this.format + "; t=" + this.mediaType + "]";
    }
}

