/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.core.util.CoreUtilities;

public class Debug {
    public static final int HIGH = 3;
    public static final int MEDIUM = 2;
    public static final int LOW = 1;
    public static final int OFF = 0;
    public static final String[] LEVELS = new String[]{"Off", "Low", "Medium", "High"};
    public static int DEBUG_MODE = 0;

    public static void setDebugLevel(int n) {
        if (n >= 0 && n <= 3) {
            DEBUG_MODE = n;
        }
        switch (DEBUG_MODE) {
            case 3: {
                CoreUtilities.setDebugLevel(5);
                break;
            }
            case 2: {
                CoreUtilities.setDebugLevel(4);
                break;
            }
            case 1: {
                CoreUtilities.setDebugLevel(3);
                break;
            }
            case 0: {
                CoreUtilities.setDebugLevel(0);
            }
        }
    }

    public static int getDebugLevel() {
        return DEBUG_MODE;
    }

    public static void debugOutAlways(String string) {
        System.out.println(string);
    }

    public static void debugOut(String string) {
        Debug.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        if (DEBUG_MODE >= n) {
            System.out.println(string);
        }
    }

    public static void debugOutAlways(Throwable throwable) {
        System.out.println(throwable);
        throwable.printStackTrace();
    }

    public static void debugOut(Throwable throwable) {
        Debug.debugOut(throwable, 2);
    }

    public static void debugOut(Throwable throwable, int n) {
        if (DEBUG_MODE >= n) {
            System.out.println(throwable);
            throwable.printStackTrace();
        }
    }

    public static void debugOutStay(String string) {
        Debug.debugOutStay(string, 2);
    }

    public static void debugOutStay(String string, int n) {
        if (DEBUG_MODE >= n) {
            System.out.print(string);
        }
    }
}

