/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.KeepAliveMessage;
import java.io.ObjectOutputStream;

public class ConnectionKeeper
extends Thread {
    protected boolean stillKeepAlive = true;
    protected boolean finalMessageSent = false;
    protected ObjectOutputStream oos;
    protected Object lockObject = new Object();
    protected int currentMessage = 0;

    public ConnectionKeeper(ObjectOutputStream objectOutputStream) {
        super("ConnectionKeeper");
        ConnectionKeeper.debugOut("in constructor.", 3);
        this.oos = objectOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.stillKeepAlive) {
            try {
                ConnectionKeeper.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Object object = this.lockObject;
                synchronized (object) {
                    if (!this.finalMessageSent) {
                        KeepAliveMessage keepAliveMessage = new KeepAliveMessage();
                        if (this.currentMessage == 0) {
                            keepAliveMessage.setKeepAlive();
                            this.oos.writeObject(keepAliveMessage);
                            this.oos.flush();
                            this.stillKeepAlive = true;
                        } else if (this.currentMessage == -1) {
                            ConnectionKeeper.debugOut("sendFailure.", 3);
                            keepAliveMessage.setFailure();
                            this.oos.writeObject(keepAliveMessage);
                            this.oos.flush();
                            this.stillKeepAlive = false;
                            this.finalMessageSent = true;
                        }
                    }
                }
            }
            catch (Exception exception) {
                ConnectionKeeper.debugOut("Exception in run(): " + exception, 2);
                this.stillKeepAlive = false;
                this.finalMessageSent = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendSuccess() {
        try {
            Object object = this.lockObject;
            synchronized (object) {
                this.currentMessage = 1;
                KeepAliveMessage keepAliveMessage = new KeepAliveMessage();
                ConnectionKeeper.debugOut("sendSuccess.", 3);
                keepAliveMessage.setSuccess();
                this.oos.writeObject(keepAliveMessage);
                this.stillKeepAlive = false;
                this.finalMessageSent = true;
            }
            this.waitUntilFinalMessageIsSent();
        }
        catch (Exception exception) {
            ConnectionKeeper.debugOut("Exception in sendSuccess(): " + InsightUtilities.getStackTrace(exception), 2);
            this.stillKeepAlive = false;
            this.finalMessageSent = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendFailure() {
        try {
            Object object = this.lockObject;
            synchronized (object) {
                this.currentMessage = -1;
            }
            this.waitUntilFinalMessageIsSent();
        }
        catch (Exception exception) {
            ConnectionKeeper.debugOut("Exception in sendFailure(): " + InsightUtilities.getStackTrace(exception), 2);
            this.stillKeepAlive = false;
            this.finalMessageSent = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendKeepAlive() {
        try {
            Object object = this.lockObject;
            synchronized (object) {
                this.currentMessage = 0;
            }
        }
        catch (Exception exception) {
            ConnectionKeeper.debugOut("Exception in sendKeepAlive(): " + InsightUtilities.getStackTrace(exception), 2);
            this.stillKeepAlive = false;
            this.finalMessageSent = true;
        }
    }

    protected void waitUntilFinalMessageIsSent() {
        while (!this.finalMessageSent) {
            try {
                ConnectionKeeper.sleep(200L);
            }
            catch (Exception exception) {}
        }
    }

    public static void debugOut(String string) {
        ConnectionKeeper.debugOut(string, 3);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ConnectionKeeper: " + string, n);
    }
}

