/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.server;

import com.luna.insight.server.CollectionKey;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.util.List;
import java.util.Vector;

public class CollectionKeyDistributor {
    protected Vector distribution = new Vector(0);
    protected boolean groupByInstitution = false;

    public static void debugOut(String string) {
        CollectionKeyDistributor.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionKeyDistributor: " + string, n);
    }

    public static boolean keysAgree(CollectionKey collectionKey, CollectionKey collectionKey2) {
        return collectionKey != null && collectionKey2 != null && collectionKey.getInstitutionID() != null && collectionKey.getCollectionID() != null && collectionKey2.getInstitutionID() != null && collectionKey2.getCollectionID() != null && collectionKey.getInstitutionID().equalsIgnoreCase(collectionKey2.getInstitutionID()) && collectionKey.getCollectionID().equalsIgnoreCase(collectionKey2.getCollectionID()) && (collectionKey.getVCID() == null && collectionKey2.getVCID() == null || collectionKey.getVCID() != null && collectionKey.getVCID().equalsIgnoreCase(collectionKey2.getVCID()));
    }

    public static boolean institutionIDsAgree(CollectionKey collectionKey, CollectionKey collectionKey2) {
        return collectionKey != null && collectionKey2 != null && collectionKey.getInstitutionID() != null && collectionKey2.getInstitutionID() != null && collectionKey.getInstitutionID().equalsIgnoreCase(collectionKey2.getInstitutionID());
    }

    public CollectionKeyDistributor() {
        this(false);
    }

    public CollectionKeyDistributor(boolean bl) {
        this.groupByInstitution = bl;
    }

    public void addCollectionKeys(List list) {
        for (int i = 0; list != null && i < list.size(); ++i) {
            if (!(list.get(i) instanceof CollectionKey)) continue;
            this.addCollectionKey((CollectionKey)list.get(i));
        }
    }

    public synchronized void addCollectionKey(CollectionKey collectionKey) {
        if (collectionKey != null) {
            Vector<CollectionKey> vector = this.getPartition(collectionKey);
            if (vector == null) {
                vector = this.getEmptyPartition();
            }
            if (vector == null) {
                vector = new Vector<CollectionKey>(1);
                this.distribution.add(vector);
            }
            vector.add(collectionKey);
        }
    }

    public void removeCollectionKey(CollectionKey collectionKey) {
        Vector vector = this.getPartition(collectionKey);
        if (vector != null) {
            vector.remove(collectionKey);
        }
    }

    public Vector getDistribution() {
        return this.distribution;
    }

    public Vector getPartition(CollectionKey collectionKey) {
        Vector vector = null;
        if (this.distribution != null && collectionKey != null) {
            for (int i = 0; i < this.distribution.size(); ++i) {
                CollectionKey collectionKey2;
                Vector vector2 = (Vector)this.distribution.get(i);
                if (!InsightUtilities.isNonEmpty(vector2) || !CollectionKeyDistributor.keysAgree(collectionKey2 = (CollectionKey)vector2.get(0), collectionKey) && (!this.groupByInstitution || !CollectionKeyDistributor.institutionIDsAgree(collectionKey2, collectionKey))) continue;
                vector = vector2;
                break;
            }
        }
        return vector;
    }

    protected Vector getEmptyPartition() {
        Vector vector = null;
        for (int i = 0; this.distribution != null && i < this.distribution.size(); ++i) {
            Vector vector2 = (Vector)this.distribution.get(i);
            if (vector2 == null || !vector2.isEmpty()) continue;
            vector = vector2;
            break;
        }
        return vector;
    }
}

