/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CryptoHelper {
    public static final String SECURITY_PROVIDER = "security.jceprovider";
    public static final String SECURITY_PROVIDER_NAME = "security.jcename";
    public static final String SECURITY_ALGORITHM = "security.algorithm";
    public static final String SECURITY_TRANSFORMATION = "security.transformation";
    public static final String SECURITY_DEBUG_LEVEL = "security.debug.level";
    public static final String SECURITY_CORE_SK = "security.core.sk";
    public static final Properties DEFAULT_PROPERTIES_KS;
    public static final Properties DEFAULT_PROPERTIES;
    public static final CryptoHelper CORE_CRYPTO_HELPER;
    protected String providerClassName = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    protected String providerName = "BC";
    protected String algorithm = "PBEWithSHAAnd3-KeyTripleDES-CBC";
    protected String transformation = "PBEWithSHAAnd3-KeyTripleDES-CBC";
    protected int debugLevel = 0;
    protected AlgorithmParameterSpec paramSpec;
    protected SecretKey secretKey;
    protected Cipher cipher;
    protected Provider provider;
    static /* synthetic */ Class class$java$security$Security;

    public CryptoHelper() {
        this.setProperties(DEFAULT_PROPERTIES_KS);
    }

    public CryptoHelper(String string) {
        Properties properties = (Properties)DEFAULT_PROPERTIES.clone();
        properties.put(SECURITY_CORE_SK, string);
        this.setProperties(properties);
    }

    protected void setProperties(Properties properties) {
        try {
            this.debugLevel = Integer.parseInt(properties.getProperty(SECURITY_DEBUG_LEVEL, "0"));
            this.providerClassName = properties.getProperty(SECURITY_PROVIDER, this.providerClassName);
            this.debug("JCE provider class name: " + this.providerClassName);
            this.algorithm = properties.getProperty(SECURITY_ALGORITHM, this.algorithm);
            this.debug("Security algorithm: " + this.algorithm);
            this.providerName = properties.getProperty(SECURITY_PROVIDER_NAME, this.providerName);
            this.debug("Provider name: " + this.providerName);
            this.transformation = properties.getProperty(SECURITY_TRANSFORMATION, this.algorithm);
            this.debug("Security transformation: " + this.transformation);
            this.provider = null;
            String string = properties.getProperty(SECURITY_CORE_SK);
            if (string != null) {
                this.setKeyString(string);
            }
        }
        catch (Exception exception) {
            this.debug("Exception in configure():\n" + exception.getStackTrace());
        }
    }

    protected void debug(String string) {
        this.debug(0, string);
    }

    protected void debug(int n, String string) {
        if (n >= this.debugLevel) {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyString(String string) {
        try {
            Object object;
            if (this.provider == null) {
                object = class$java$security$Security == null ? (class$java$security$Security = CryptoHelper.class$("java.security.Security")) : class$java$security$Security;
                synchronized (object) {
                    Provider[] providerArray = Security.getProviders();
                    for (int i = 0; i < providerArray.length; ++i) {
                        if (!providerArray[i].getName().equals(this.providerName)) continue;
                        this.provider = providerArray[i];
                        break;
                    }
                    if (this.provider == null) {
                        this.provider = (Provider)Class.forName(this.providerClassName).newInstance();
                        Security.addProvider(this.provider);
                    }
                }
            }
            object = new byte[]{-57, 127, 33, -116, 126, -56, 37, -103};
            int n = 11;
            this.paramSpec = new PBEParameterSpec((byte[])object, n);
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.algorithm, this.provider.getName());
            this.secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
            this.cipher = Cipher.getInstance(this.transformation, this.provider.getName());
        }
        catch (Throwable throwable) {
            this.debug("Process error in initKey():\n" + throwable.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encrypt(String string) {
        try {
            Cipher cipher = this.cipher;
            synchronized (cipher) {
                this.cipher.init(1, (Key)this.secretKey, this.paramSpec);
                return URLEncoder.encode(new BASE64Encoder().encode(this.cipher.doFinal(string.getBytes())), "UTF-8");
            }
        }
        catch (Exception exception) {
            this.debug("Exception in encrypt():\n" + exception.getStackTrace());
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decrypt(String string) {
        try {
            Cipher cipher = this.cipher;
            synchronized (cipher) {
                this.cipher.init(2, (Key)this.secretKey, this.paramSpec);
                return new String(this.cipher.doFinal(new BASE64Decoder().decodeBuffer(URLDecoder.decode(string, "UTF-8"))));
            }
        }
        catch (Exception exception) {
            this.debug("Exception in decrypt():\n" + exception.getStackTrace());
            return string;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 2) {
            if (stringArray[0].equals("-e")) {
                System.out.println("plaintext: " + stringArray[1] + " encrypted: " + CORE_CRYPTO_HELPER.encrypt(stringArray[1]));
            } else if (stringArray[0].equals("-d")) {
                System.out.println("encrypted: " + stringArray[1] + " plaintext: " + CORE_CRYPTO_HELPER.decrypt(stringArray[1]));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT_PROPERTIES = new Properties();
        DEFAULT_PROPERTIES.put(SECURITY_DEBUG_LEVEL, "2");
        DEFAULT_PROPERTIES_KS = new Properties();
        DEFAULT_PROPERTIES_KS.put(SECURITY_DEBUG_LEVEL, "2");
        DEFAULT_PROPERTIES_KS.put(SECURITY_CORE_SK, "coresk");
        CORE_CRYPTO_HELPER = new CryptoHelper();
    }
}

