/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.util;

import java.io.IOException;
import java.io.Writer;

public class CSVLogger {
    private static String SEPARATOR = "\t";
    private static String QUOTE = "\"";
    private static String ENDOFRECORD = "\n";

    public static void setSeparator(String string) {
        SEPARATOR = string;
    }

    public static void setQuote(String string) {
        QUOTE = string;
    }

    public static String getQuote() {
        return QUOTE;
    }

    public static String getSeparator() {
        return SEPARATOR;
    }

    public static String getQuoteEscape() {
        return QUOTE + QUOTE;
    }

    public static String getEndOfRecord() {
        return ENDOFRECORD;
    }

    public static void writeFirstRecord(Writer writer, Object object) throws IOException {
        if (object != null) {
            writer.write(CSVLogger.quote(object.toString()));
        }
    }

    public static void write(Writer writer, Object object) throws IOException {
        writer.write(CSVLogger.getSeparator());
        if (object != null) {
            writer.write(CSVLogger.quote(object.toString()));
        }
    }

    public static void writeEndOfRecord(Writer writer) throws IOException {
        CSVLogger.writeEndOfRecord(writer, CSVLogger.getEndOfRecord());
    }

    public static void writeEndOfRecord(Writer writer, String string) throws IOException {
        writer.write(string);
    }

    public static String quote(String string) {
        if (string.indexOf(CSVLogger.getQuote()) == -1 && string.indexOf(SEPARATOR) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        CSVLogger.replaceAll(stringBuffer, CSVLogger.getQuote(), CSVLogger.getQuoteEscape());
        stringBuffer.insert(0, "\"");
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public static int replace(StringBuffer stringBuffer, String string, String string2, int n) {
        int n2 = stringBuffer.toString().indexOf(string, n);
        if (n2 != -1) {
            stringBuffer.replace(n2, n2 + string.length(), string2);
        }
        return n2;
    }

    public static void replaceAll(StringBuffer stringBuffer, String string, String string2) {
        int n = 0;
        int n2 = 0;
        do {
            n2 = CSVLogger.replace(stringBuffer, string, string2, n);
            n = n2 + string2.length();
        } while (n2 != -1);
    }
}

