/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.license;

import com.luna.insight.core.license.InsightLicenseException;
import com.luna.insight.core.license.InsightLicenseManager;

public class InsightLicensedSessionManager {
    private static int activeInscribeSessions = 0;
    private static int activePcSessions = 0;
    public static int licensedInscribeSessions = 0;
    public static int licensedPcSessions = 0;

    private static void debugOut(String string) {
        System.out.println(string);
    }

    private static void sessionStatus(int n) {
        if (n > 4) {
            InsightLicensedSessionManager.debugOut("UNKNOWN");
        }
        if (n == 1) {
            InsightLicensedSessionManager.debugOut("Within Licensed Session Range");
        }
        if (n == 2) {
            InsightLicensedSessionManager.debugOut("Using 3 or more times licensed sessions, session not allowed");
        }
        if (n == 3) {
            InsightLicensedSessionManager.debugOut("Using 2 times licensed sessions, please purchase more licenses.");
        }
        if (n == 4) {
            InsightLicensedSessionManager.debugOut("Using more sessions than licensed.");
        }
    }

    public InsightLicensedSessionManager(InsightLicenseManager insightLicenseManager) {
        licensedPcSessions = insightLicenseManager.getPcLicensedSessions();
        licensedInscribeSessions = insightLicenseManager.getInscribeLicensedSessions();
    }

    public void addInscribeSession() {
        ++activeInscribeSessions;
    }

    public void addPcSession() {
        ++activePcSessions;
    }

    private boolean allowInscribeSession() throws InsightLicenseException {
        if (activeInscribeSessions <= licensedInscribeSessions) {
            InsightLicensedSessionManager.sessionStatus(1);
            return true;
        }
        if (activeInscribeSessions > licensedInscribeSessions && activeInscribeSessions >= licensedInscribeSessions * 3) {
            InsightLicensedSessionManager.sessionStatus(2);
            return false;
        }
        if (activeInscribeSessions >= licensedInscribeSessions * 2 && activeInscribeSessions < licensedInscribeSessions * 3) {
            InsightLicensedSessionManager.sessionStatus(3);
            return true;
        }
        if (activeInscribeSessions > licensedInscribeSessions && activeInscribeSessions < licensedInscribeSessions * 2) {
            InsightLicensedSessionManager.sessionStatus(4);
            return true;
        }
        return false;
    }

    private boolean allowPcSession() throws InsightLicenseException {
        if (activePcSessions <= licensedPcSessions) {
            InsightLicensedSessionManager.sessionStatus(1);
            return true;
        }
        if (activePcSessions > licensedPcSessions && activePcSessions >= licensedPcSessions * 3) {
            InsightLicensedSessionManager.sessionStatus(2);
            return false;
        }
        if (activePcSessions >= licensedPcSessions * 2 && activePcSessions < licensedPcSessions * 3) {
            InsightLicensedSessionManager.sessionStatus(3);
            return true;
        }
        if (activePcSessions > licensedPcSessions && activePcSessions < licensedPcSessions * 2) {
            InsightLicensedSessionManager.sessionStatus(4);
            return true;
        }
        return false;
    }

    public void endInscribeSession() {
        if (activeInscribeSessions > 0) {
            this.removeInscribeSession();
        }
    }

    public void endPcSession() {
        if (activePcSessions > 0) {
            this.removePcSession();
        }
    }

    public int getActiveInscribeSessions() {
        return activeInscribeSessions;
    }

    public int getActivePcSessions() {
        return activePcSessions;
    }

    public void removeInscribeSession() {
        --activeInscribeSessions;
    }

    public void removePcSession() {
        --activePcSessions;
    }

    public void startInscribeSession() {
        boolean bl = false;
        try {
            bl = this.allowInscribeSession();
        }
        catch (InsightLicenseException insightLicenseException) {
            insightLicenseException.printStackTrace();
        }
        if (bl) {
            this.addInscribeSession();
        }
    }

    public void startPcSession() {
        boolean bl = false;
        try {
            bl = this.allowPcSession();
        }
        catch (InsightLicenseException insightLicenseException) {
            insightLicenseException.printStackTrace();
        }
        if (bl) {
            this.addPcSession();
        }
    }
}

