/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.license;

import com.luna.insight.core.license.InsightLicenseConstants;
import com.luna.insight.core.license.InsightLicenseException;
import com.luna.insight.core.license.InsightLicenseUtilities;
import com.luna.insight.core.util.CoreUtilities;
import com.vs.ezlicrun.EzLicExceptionBase;
import com.vs.ezlicrun.EzLicExceptionInvalidHostUserNet;
import com.vs.ezlicrun.EzLicenseInfo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InsightLicenseService
implements InsightLicenseConstants {
    private String keyCookie = null;
    private EzLicenseInfo licenseInfo = null;
    private int licenseVersion = 5;
    private int inscribeSessions = 0;
    private boolean pcLicense = false;
    private int pcSessions = 0;
    private boolean xmlGatewayLicense = false;
    private boolean browserLicense = false;
    private boolean mediaServerLicense = false;
    private boolean licensedUserMode = false;
    private int maxMediaSoft = 0;
    private int maxMediaHard = 0;
    private String userhost = InsightLicenseUtilities.getHostName();
    private int serverType = 0;

    public static void debugOut(String string) {
        System.out.println(string);
    }

    public int getInscribeSessions() {
        return this.inscribeSessions;
    }

    private void setInscribeSessions(int n) {
        this.inscribeSessions = n;
    }

    public boolean isPcLicense() {
        return this.pcLicense;
    }

    private void setPcLicense(boolean bl) {
        this.pcLicense = bl;
    }

    public int getPcSessions() {
        return this.pcSessions;
    }

    private void setPcSessions(int n) {
        this.pcSessions = n;
    }

    public boolean isXmlGatewayLicense() {
        return this.xmlGatewayLicense;
    }

    private void setXmlGatewayLicense(boolean bl) {
        this.xmlGatewayLicense = bl;
    }

    public boolean isBrowserLicense() {
        return this.browserLicense;
    }

    private void setBrowserLicense(boolean bl) {
        this.browserLicense = bl;
    }

    public int getLicenseVersion() {
        return this.licenseVersion;
    }

    private void setLicenseVersion(int n) {
        this.licenseVersion = n;
    }

    public boolean isMediaServerLicense() {
        return this.mediaServerLicense;
    }

    private void setMediaServerLicense(boolean bl) {
        this.mediaServerLicense = bl;
    }

    public int getServerType() {
        return this.serverType;
    }

    public int getMaxMediaSoft() {
        return this.maxMediaSoft;
    }

    private void setMaxMediaSoft(int n) {
        this.maxMediaSoft = n;
    }

    public int getMaxMediaHard() {
        return this.maxMediaHard;
    }

    private void setMaxMediaHard(int n) {
        this.maxMediaHard = n;
    }

    public boolean isLicensedUserMode() {
        return this.licensedUserMode;
    }

    private void setLicensedUserMode(boolean bl) {
        this.licensedUserMode = bl;
    }

    public boolean registerInsightServerLicense(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "InsightCollectionManager", "a8pOTOFLWOxsWL81");
            this.serverType = 1;
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register Insight Server License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    public boolean registerXmlGatewayLicense(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "InsightCollectionManager", "a8pOTOFLWOxsWL81");
            this.setXmlGatewayLicense(bl);
            this.serverType = 4;
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register XML Gateway License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    public boolean registerBrowserInsightLicense(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "InsightCollectionManager", "a8pOTOFLWOxsWL81");
            this.setBrowserLicense(bl);
            this.serverType = 3;
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register Browser Insight License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    public boolean registerPersonalInsightServerLicense_v5_0(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "PersonalInsightManager", "a8pOTOFLWOxsWL81");
            this.setPcLicense(bl);
            this.serverType = 2;
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register Personal Insight Server License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    public boolean registerPersonalInsightServerLicense(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "InsightCollectionManager", "a8pOTOFLWOxsWL81");
            this.setPcLicense(bl);
            this.serverType = 2;
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register Personal Insight Server License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    public boolean registerMediaServerLicense(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "InsightCollectionManager", "a8pOTOFLWOxsWL81");
            this.setMediaServerLicense(bl);
            this.serverType = 5;
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register Media Server License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    public boolean registerInsightUserServerLicense(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "InsightCollectionManager", "a8pOTOFLWOxsWL81");
            this.setMediaServerLicense(bl);
            this.serverType = 6;
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register User Manager License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    private boolean validateMultihostLicense(EzLicenseInfo ezLicenseInfo, String string, String string2, String string3, String string4, String string5) {
        try {
            CoreUtilities.logInfo("Checking multi-host license");
            ezLicenseInfo.checkLicenseKeySecure(string, string2, null, null, null, 7, 0L, 10L, 365, 100L, "multihostlicense", 0L, string3, string4, null);
            String string6 = this.parseLicenseOption(ezLicenseInfo.getOptions(), "LicenseUserHosts");
            if (string6 != null && CoreUtilities.getTokenizedList(string6, " ,\t").contains(string5)) {
                CoreUtilities.logAlways("Matched '" + string5 + "' as secondary hostname.");
                return true;
            }
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            // empty catch block
        }
        return false;
    }

    private boolean validateLicense(String string, String string2, String string3) throws EzLicExceptionBase {
        Date date;
        int n = InsightLicenseUtilities.getFileType(string);
        if (n == -1) {
            return false;
        }
        Object[] objectArray = InsightLicenseUtilities.readFile(string, 1000);
        if (objectArray == null) {
            CoreUtilities.logAlways("Cannot process license key file due to errors.  Aborting.");
            return false;
        }
        int n2 = (Integer)objectArray[1];
        if (n2 == 0) {
            CoreUtilities.logAlways("License key file is empty.  Nothing to do.  Exiting.");
            return false;
        }
        CoreUtilities.logInfo("Checking license key in file...");
        String[] stringArray = (String[])objectArray[0];
        Object[] objectArray2 = null;
        objectArray2 = InsightLicenseUtilities.getKey(stringArray, n2, 0, n);
        if (objectArray2 == null) {
            CoreUtilities.logAlways("Failed to extract key text from license file.");
            return false;
        }
        String string4 = (String)objectArray2[0];
        this.licenseInfo = new EzLicenseInfo();
        try {
            this.licenseInfo.checkLicenseKeySecure(string4, this.keyCookie, null, null, null, 7, 0L, 10L, 365, 100L, this.userhost, 0L, string2, string3, null);
            InsightLicenseUtilities.displayLicenseParams(this.licenseInfo);
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            if (ezLicExceptionBase instanceof EzLicExceptionInvalidHostUserNet) {
                try {
                    if (!this.validateMultihostLicense(this.licenseInfo, string4, this.keyCookie, string2, string3, this.userhost)) {
                        CoreUtilities.logInfo("License Validation of hostname '" + this.userhost + "' failed.");
                        CoreUtilities.logInfo("Production License Validation Failed, checking floating license");
                        this.licenseInfo.checkLicenseKeySecure(string4, this.keyCookie, null, null, null, 7, 0L, 10L, 365, 100L, "developmentlicense", 0L, string2, string3, null);
                    }
                    InsightLicenseUtilities.displayLicenseParams(this.licenseInfo);
                }
                catch (EzLicExceptionBase ezLicExceptionBase2) {
                    CoreUtilities.logAlways("License Validation of hostname '" + this.userhost + "' failed.");
                    CoreUtilities.logAlways("Floating License Validation Failed");
                    throw ezLicExceptionBase2;
                }
            }
            throw ezLicExceptionBase;
        }
        Date date2 = this.licenseInfo.getExpirationDate();
        if (date2 != null && (date = new Date()).after(date2)) {
            CoreUtilities.logAlways("\n     Warning: Your Insight License has expired. \n     Expiration Date: " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss z").format(date2) + "\n     Please contact support@luna-img.com for additional information.");
            return false;
        }
        this.parseAndSetLicenseOptions(this.licenseInfo.getOptions());
        return true;
    }

    private String parseLicenseOption(String string, String string2) {
        String string3 = ";";
        String string4 = "=";
        if (string != null) {
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string5 = stringTokenizer.nextToken().trim();
                Pattern pattern = Pattern.compile("(.*)" + string4 + "(.*)");
                Matcher matcher = pattern.matcher(string5);
                if (matcher.matches()) {
                    if (!matcher.group(1).equals(string2)) continue;
                    return matcher.group(2);
                }
                CoreUtilities.logWarning("No match or an error occured");
            }
        }
        return null;
    }

    private void parseAndSetLicenseOptions(String string) {
        String string2 = ";";
        String string3 = "=";
        if (string != null) {
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string4 = stringTokenizer.nextToken().trim();
                Pattern pattern = Pattern.compile("(.*)" + string3 + "(.*)");
                Matcher matcher = pattern.matcher(string4);
                if (matcher.matches()) {
                    int n2;
                    int n3;
                    if (matcher.group(1).equals("LicenseVersion")) {
                        n3 = Integer.parseInt(matcher.group(2));
                        this.setLicenseVersion(n3);
                        continue;
                    }
                    if (matcher.group(1).equals("PersonalInsightClientSessions")) {
                        String string5 = matcher.group(2);
                        if (string5.equalsIgnoreCase("unlimited")) {
                            this.setPcSessions(100000);
                            continue;
                        }
                        n2 = CoreUtilities.tryCatchParseInt(string5);
                        this.setPcSessions(n2);
                        continue;
                    }
                    if (matcher.group(1).equals("InscribeSessions")) {
                        String string6 = matcher.group(2);
                        if (string6.equalsIgnoreCase("unlimited")) {
                            this.setInscribeSessions(100000);
                            continue;
                        }
                        n2 = CoreUtilities.tryCatchParseInt(string6);
                        this.setInscribeSessions(n2);
                        continue;
                    }
                    if (matcher.group(1).equals("LicenseNamedUserMode")) {
                        n3 = InsightLicenseUtilities.stringToBoolean(matcher.group(2)) ? 1 : 0;
                        this.setLicensedUserMode(n3 != 0);
                        continue;
                    }
                    if (matcher.group(1).equals("LicenseMaxMediaSoft")) {
                        n3 = CoreUtilities.tryCatchParseInt(matcher.group(2));
                        this.setMaxMediaSoft(n3);
                        continue;
                    }
                    if (!matcher.group(1).equals("LicenseMaxMediaHard")) continue;
                    n3 = CoreUtilities.tryCatchParseInt(matcher.group(2));
                    this.setMaxMediaHard(n3);
                    continue;
                }
                CoreUtilities.logWarning("No match or an error occured");
            }
        }
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        File file = new File("./license/server/insightCollectionServer.key");
        File file2 = new File("./license/server/personalCollectionServer.key");
        File file3 = new File("./license/server/gatewayInsightServer.key");
        File file4 = new File("./license/server/browserInsightServer.key");
        File file5 = new File("./license/server/insightMediaServer.key");
        InsightLicenseService insightLicenseService = new InsightLicenseService();
        if (file.exists()) {
            try {
                insightLicenseService.registerInsightServerLicense(file.getPath());
            }
            catch (InsightLicenseException insightLicenseException) {
                InsightLicenseService.debugOut("InsightLicenseException: " + insightLicenseException.getMessage());
            }
        }
        if (file4.exists()) {
            try {
                insightLicenseService.registerBrowserInsightLicense(file4.getPath());
            }
            catch (InsightLicenseException insightLicenseException) {
                InsightLicenseService.debugOut("InsightLicenseException: " + insightLicenseException.getMessage());
            }
        }
        if (file3.exists()) {
            try {
                insightLicenseService.registerXmlGatewayLicense(file3.getPath());
            }
            catch (InsightLicenseException insightLicenseException) {
                InsightLicenseService.debugOut("InsightLicenseException: " + insightLicenseException.getMessage());
            }
        }
        if (file2.exists()) {
            try {
                insightLicenseService.registerPersonalInsightServerLicense(file2.getPath());
            }
            catch (InsightLicenseException insightLicenseException) {
                InsightLicenseService.debugOut("InsightLicenseException: " + insightLicenseException.getMessage());
            }
        }
        if (file5.exists()) {
            try {
                insightLicenseService.registerMediaServerLicense(file5.getPath());
            }
            catch (InsightLicenseException insightLicenseException) {
                InsightLicenseService.debugOut("InsightLicenseException: " + insightLicenseException.getMessage());
            }
        }
        InsightLicenseService.debugOut("License Set - Licensed Personal Insight: " + insightLicenseService.isPcLicense());
        InsightLicenseService.debugOut("License Set - Licensed XMLGateway: " + insightLicenseService.isXmlGatewayLicense());
        InsightLicenseService.debugOut("License Set - Licensed Browser Server: " + insightLicenseService.isBrowserLicense());
        InsightLicenseService.debugOut("License Set - Licensed Media Server: " + insightLicenseService.isMediaServerLicense());
        InsightLicenseService.debugOut("License Set - PCSessions: " + insightLicenseService.getPcSessions());
        InsightLicenseService.debugOut("License Set - InscribeSessions: " + insightLicenseService.getInscribeSessions());
        InsightLicenseService.debugOut("License Set - MaxMediaSoft: " + insightLicenseService.getMaxMediaSoft());
        InsightLicenseService.debugOut("License Set - MaxMediaHard: " + insightLicenseService.getMaxMediaHard());
        long l2 = System.currentTimeMillis();
        InsightLicenseService.debugOut("Total Time: " + (double)(l2 - l) / 1000.0 + " seconds");
        System.exit(0);
    }
}

