/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.license;

import com.luna.insight.core.license.InsightLicenseConstants;
import com.luna.insight.core.license.InsightLicenseException;
import com.luna.insight.core.license.InsightLicenseUtilities;
import com.luna.insight.core.util.CoreUtilities;
import com.vs.ezlicrun.EzLicExceptionBase;
import com.vs.ezlicrun.EzLicExceptionInvalidHostUserNet;
import com.vs.ezlicrun.EzLicenseInfo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InsightLicenseClientService
implements InsightLicenseConstants {
    private String keyCookie = null;
    private EzLicenseInfo licenseInfo = null;
    private int licenseVersion = 5;
    private boolean pcLicense = false;
    private boolean inscribeLicense = false;
    private boolean jp2kEncoder = false;
    private boolean insightStudioLicense = false;
    private String userHost = InsightLicenseUtilities.getHostName();

    public static void debugOut(String string) {
        System.out.println(string);
    }

    public boolean isJp2kEncoder() {
        return this.jp2kEncoder;
    }

    private void setJp2kEncoder(boolean bl) {
        this.jp2kEncoder = bl;
    }

    public boolean isPcLicense() {
        return this.pcLicense;
    }

    private void setPcLicense(boolean bl) {
        this.pcLicense = bl;
    }

    public boolean isInscribeLicense() {
        return this.inscribeLicense;
    }

    public boolean isInsightStudioLicense() {
        return this.insightStudioLicense;
    }

    private void setInsightStudioLicense(boolean bl) {
        this.insightStudioLicense = bl;
    }

    public String getUserhost() {
        return this.userHost;
    }

    public void setUserhost(String string) {
        this.userHost = string;
    }

    public int getLicenseVersion() {
        return this.licenseVersion;
    }

    private void setLicenseVersion(int n) {
        this.licenseVersion = n;
    }

    private void setInscribeLicense(boolean bl) {
        this.inscribeLicense = bl;
    }

    public boolean registerInscribeClientLicense(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "InscribeClient", "a8pOTOFLWOxsWL81");
            this.setInscribeLicense(bl);
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register Inscribe Client License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    public boolean registerPersonalInsightLicense(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "PersonalInsightClient", "a8pOTOFLWOxsWL81");
            this.setPcLicense(bl);
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register Personal Insight Client License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    public boolean registerJp2kLicense(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "Jpeg2KEncoder", "a8pOTOFLWOxsWL81");
            this.setJp2kEncoder(bl);
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register JP2K Encoder License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    public boolean registerInsightStudioLicense(String string) throws InsightLicenseException {
        boolean bl = false;
        try {
            bl = this.validateLicense(string, "InsightStudioClient", "a8pOTOFLWOxsWL81");
            this.setInsightStudioLicense(bl);
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            CoreUtilities.logAlways("Unable to register JP2K Encoder License");
            throw new InsightLicenseException(ezLicExceptionBase);
        }
        return bl;
    }

    private boolean validateMultihostLicense(EzLicenseInfo ezLicenseInfo, String string, String string2, String string3, String string4) {
        try {
            CoreUtilities.logInfo("Checking multi-host license");
            ezLicenseInfo.checkLicenseKey(string, null, null, 7, 0L, 10L, 365, 100L, "multihostlicense", 0L, string2, string3);
            String string5 = this.parseLicenseOption(ezLicenseInfo.getOptions(), "LicenseUserHosts");
            if (string5 != null && CoreUtilities.getTokenizedList(string5, " ,\t").contains(string4)) {
                CoreUtilities.logAlways("Matched '" + string4 + "' as secondary hostname.");
                return true;
            }
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            // empty catch block
        }
        return false;
    }

    private boolean validateLicense(String string, String string2, String string3) throws EzLicExceptionBase {
        Date date;
        int n = InsightLicenseUtilities.getFileType(string);
        if (n == -1) {
            return false;
        }
        Object[] objectArray = InsightLicenseUtilities.readFile(string, 1000);
        if (objectArray == null) {
            CoreUtilities.logAlways("Cannot process license key file due to errors.  Aborting.");
            return false;
        }
        int n2 = (Integer)objectArray[1];
        if (n2 == 0) {
            CoreUtilities.logAlways("License key file is empty.  Nothing to do.  Exiting.");
            return false;
        }
        CoreUtilities.logInfo("Checking license key in file...");
        String[] stringArray = (String[])objectArray[0];
        Object[] objectArray2 = null;
        objectArray2 = InsightLicenseUtilities.getKey(stringArray, n2, 0, n);
        if (objectArray2 == null) {
            CoreUtilities.logAlways("Failed to extract key text from license file.");
            return false;
        }
        String string4 = (String)objectArray2[0];
        this.licenseInfo = new EzLicenseInfo();
        try {
            this.licenseInfo.checkLicenseKey(string4, null, null, 7, 0L, 10L, 365, 100L, this.userHost, 0L, string2, string3);
            InsightLicenseUtilities.displayLicenseParams(this.licenseInfo);
        }
        catch (EzLicExceptionBase ezLicExceptionBase) {
            if (ezLicExceptionBase instanceof EzLicExceptionInvalidHostUserNet) {
                try {
                    if (!this.validateMultihostLicense(this.licenseInfo, string4, string2, string3, this.userHost)) {
                        CoreUtilities.logInfo("License Validation of hostname '" + this.userHost + "' failed.");
                        CoreUtilities.logInfo("Production License Validation Failed, checking floating license");
                        this.licenseInfo.checkLicenseKey(string4, null, null, 7, 0L, 10L, 365, 100L, "developmentlicense", 0L, string2, string3);
                    }
                    InsightLicenseUtilities.displayLicenseParams(this.licenseInfo);
                }
                catch (EzLicExceptionBase ezLicExceptionBase2) {
                    CoreUtilities.logAlways("License Validation of hostname '" + this.userHost + "' failed.");
                    CoreUtilities.logAlways("Floating License Validation Failed");
                    throw ezLicExceptionBase2;
                }
            }
            throw ezLicExceptionBase;
        }
        Date date2 = this.licenseInfo.getExpirationDate();
        if (date2 != null && (date = new Date()).after(date2)) {
            CoreUtilities.logAlways("\n     Warning: Your Insight License has expired. \n     Expiration Date: " + new SimpleDateFormat("yyyy-MM-dd hh:mm:ss z").format(date2) + "\n     Please contact support@luna-img.com for additional information.");
            return false;
        }
        this.parseAndSetLicenseOptions(this.licenseInfo.getOptions());
        return true;
    }

    private String parseLicenseOption(String string, String string2) {
        String string3 = ";";
        String string4 = "=";
        if (string != null) {
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string5 = stringTokenizer.nextToken().trim();
                Pattern pattern = Pattern.compile("(.*)" + string4 + "(.*)");
                Matcher matcher = pattern.matcher(string5);
                if (matcher.matches()) {
                    if (!matcher.group(1).equals(string2)) continue;
                    return matcher.group(2);
                }
                CoreUtilities.logWarning("No match or an error occured");
            }
        }
        return null;
    }

    private void parseAndSetLicenseOptions(String string) {
        String string2 = ";";
        String string3 = "=";
        if (string != null) {
            string = string.trim();
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string4 = stringTokenizer.nextToken().trim();
                Pattern pattern = Pattern.compile("(.*)" + string3 + "(.*)");
                Matcher matcher = pattern.matcher(string4);
                if (matcher.matches()) {
                    if (!matcher.group(1).equals("LicenseVersion")) continue;
                    int n2 = Integer.parseInt(matcher.group(2));
                    this.setLicenseVersion(n2);
                    continue;
                }
                CoreUtilities.logInfo("No match or an error occured");
            }
        }
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        File file = new File("./license/client/5.0inscribeLicenseKey.key");
        File file2 = new File("./license/client/jp2kLicense.key");
        File file3 = new File("./license/client/personalInsightLicense.key");
        File file4 = new File("./license/client/studioInsightLicense.key");
        InsightLicenseClientService insightLicenseClientService = new InsightLicenseClientService();
        if (file.exists()) {
            try {
                insightLicenseClientService.registerInscribeClientLicense(file.getPath());
            }
            catch (InsightLicenseException insightLicenseException) {
                insightLicenseException.printStackTrace();
            }
        }
        if (file2.exists()) {
            try {
                insightLicenseClientService.registerJp2kLicense(file2.getPath());
            }
            catch (InsightLicenseException insightLicenseException) {
                insightLicenseException.printStackTrace();
            }
        }
        if (file4.exists()) {
            try {
                insightLicenseClientService.registerInsightStudioLicense(file4.getPath());
            }
            catch (InsightLicenseException insightLicenseException) {
                insightLicenseException.printStackTrace();
            }
        }
        if (file3.exists()) {
            try {
                insightLicenseClientService.registerPersonalInsightLicense(file3.getPath());
            }
            catch (InsightLicenseException insightLicenseException) {
                insightLicenseException.printStackTrace();
            }
        }
        InsightLicenseClientService.debugOut("JP2K License: " + insightLicenseClientService.isJp2kEncoder());
        InsightLicenseClientService.debugOut("Inscribe License: " + insightLicenseClientService.isInscribeLicense());
        InsightLicenseClientService.debugOut("PC License: " + insightLicenseClientService.isPcLicense());
        InsightLicenseClientService.debugOut("Studio License: " + insightLicenseClientService.isInsightStudioLicense());
        long l2 = System.currentTimeMillis();
        InsightLicenseClientService.debugOut("Total Time: " + (double)(l2 - l) / 1000.0 + " seconds");
        System.exit(0);
    }
}

