/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.jpeg2000;

import com.luna.insight.core.jpeg2000.IJPEG2KEncodeParam;
import com.luna.insight.core.jpeg2000.IJPEG2KImageEncoder;
import com.luna.insight.core.jpeg2000.JPEG2KCodec;
import com.luna.insight.core.jpeg2000.JPEG2KException;
import com.luna.insight.core.util.CoreUtilities;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileSaver;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class JPEG2KImageEncoderKDU
implements IJPEG2KImageEncoder {
    private String destPath = null;
    private IJPEG2KEncodeParam currentParam = null;
    protected static final int COLOR_TYPE_GRAY = 0;
    protected static final int COLOR_TYPE_RGB = 1;
    protected static final int COLOR_TYPE_BITONAL = 2;

    public static void debugMemory(String string) {
        CoreUtilities.logInfo("Memory Usage: " + string + " = " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000000L + "Mb");
    }

    public JPEG2KImageEncoderKDU(String string) {
        this.destPath = string;
    }

    public JPEG2KImageEncoderKDU(String string, IJPEG2KEncodeParam iJPEG2KEncodeParam) {
        this.destPath = string;
        this.currentParam = iJPEG2KEncodeParam != null ? (IJPEG2KEncodeParam)iJPEG2KEncodeParam.clone() : null;
    }

    public void setJPEG2KEncodeParam(IJPEG2KEncodeParam iJPEG2KEncodeParam) {
        if (iJPEG2KEncodeParam != this.currentParam) {
            this.currentParam = iJPEG2KEncodeParam != null ? (IJPEG2KEncodeParam)iJPEG2KEncodeParam.clone() : null;
        }
    }

    public IJPEG2KEncodeParam getJPEG2KEncodeParam() {
        return this.currentParam != null ? (IJPEG2KEncodeParam)this.currentParam.clone() : null;
    }

    public IJPEG2KEncodeParam getDefaultJPEG2KEncodeParam() {
        return JPEG2KCodec.getDefaultJPEG2KEncodeParam();
    }

    public IJPEG2KEncodeParam getDefaultJPEG2KEncodeParam(BufferedImage bufferedImage) {
        return JPEG2KCodec.getDefaultJPEG2KEncodeParam(bufferedImage);
    }

    public IJPEG2KEncodeParam getDefaultJPEG2KEncodeParam(String string) throws IOException, IOException {
        return JPEG2KCodec.getDefaultJPEG2KEncodeParam(string);
    }

    public void encode(String string) throws IOException, JPEG2KException {
        this.encode(string, this.currentParam);
    }

    public void encode(String string, IJPEG2KEncodeParam iJPEG2KEncodeParam) throws IOException, JPEG2KException {
        ImagePlus imagePlus = JPEG2KCodec.openImageJ(string);
        this.encodeKduSimpleCompress(imagePlus, iJPEG2KEncodeParam, true);
    }

    public void encode(ImagePlus imagePlus, IJPEG2KEncodeParam iJPEG2KEncodeParam) throws IOException, JPEG2KException {
        this.encodeKduSimpleCompress(imagePlus, iJPEG2KEncodeParam, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeKduSimpleCompress(ImagePlus imagePlus, IJPEG2KEncodeParam iJPEG2KEncodeParam, boolean bl) throws JPEG2KException {
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        if (iJPEG2KEncodeParam == null) {
            iJPEG2KEncodeParam = this.getDefaultJPEG2KEncodeParam();
        }
        if (iJPEG2KEncodeParam.getLevels() == 0) {
            iJPEG2KEncodeParam.setLevels(JPEG2KCodec.determineResolution(n, n2));
        }
        this.setJPEG2KEncodeParam(iJPEG2KEncodeParam);
        FileInfo fileInfo = imagePlus.getOriginalFileInfo();
        if (fileInfo == null) {
            fileInfo = imagePlus.getFileInfo();
        }
        if (fileInfo.fileFormat != 5) {
            JPEG2KImageEncoderKDU.debugMemory("before before kdu_compress invoke");
            String string = this.destPath + ".bmp";
            try {
                try {
                    new FileSaver(imagePlus).saveAsBmp(string);
                }
                catch (Exception exception) {
                    CoreUtilities.logException("exception generating bitmap input file for kdu_compress", exception);
                    throw new JPEG2KException(exception);
                }
                if (bl && imagePlus != null) {
                    imagePlus.flush();
                    imagePlus = null;
                }
                this.execKduCompress(string, this.currentParam);
            }
            finally {
                new File(string).delete();
            }
        }
        JPEG2KImageEncoderKDU.debugMemory("before before kdu_compress invoke");
        if (bl && imagePlus != null) {
            imagePlus.flush();
            imagePlus = null;
        }
        this.execKduCompress(fileInfo.directory + fileInfo.fileName, this.currentParam);
    }

    private void execKduCompress(String string, IJPEG2KEncodeParam iJPEG2KEncodeParam) throws JPEG2KException {
        Object object;
        Object object2;
        String string2 = this.destPath;
        Object var4_4 = null;
        int n = 0;
        int[] nArray = null;
        int n2 = 0;
        if (this.currentParam.getSlope() != null) {
            object2 = new StringTokenizer(this.currentParam.getSlope(), ",");
            n = ((StringTokenizer)object2).countTokens();
            CoreUtilities.logInfo("numSlopes=" + n);
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                object = ((StringTokenizer)object2).nextToken();
                nArray[i] = Integer.parseInt((String)object);
                if (i > 0 && nArray[i] > nArray[i - 1]) {
                    throw new JPEG2KException("The list of integer distortion-length slope values must be in decreasing sort order.");
                }
                if (nArray[i] < 0 || nArray[i] > 65535) {
                    throw new JPEG2KException("Each of integer distortion-length slope values must be in the range 0 to 65535, inclusive.");
                }
                CoreUtilities.logInfo("layerSlopes[" + i + "]=" + nArray[i]);
            }
            n2 = nArray[n - 1];
            if (this.currentParam.getLayers() > 0 && this.currentParam.getLayers() != n) {
                throw new JPEG2KException("Number of slopes do not match the specified Quality Layers.");
            }
        }
        if (this.currentParam.getLayers() == 0) {
            if (n > 0) {
                this.currentParam.setLayers(n);
            } else {
                this.currentParam.setLayers(1);
            }
            CoreUtilities.logInfo("Number of Layers set to: " + this.currentParam.getLayers());
        }
        object2 = " -i " + string + " -o " + string2 + " " + this.currentParam.toKduCompressArgs() + " Cband_weights:C0={0.0901},{0.2758},{0.2758},{0.7018},{0.8378},{0.8378},{1}" + " Cband_weights:C1={0.0263},{0.0863},{0.0863},{0.1362},{0.2564},{0.2564},{0.3346},{0.4691},{0.4691},{0.5444},{0.6523},{0.6523},{0.7078},{0.7797},{0.7797},{1}" + " Cband_weights:C2={0.0773},{0.1835},{0.1835},{0.2598},{0.4130},{0.4130},{0.5040},{0.6464},{0.6464},{0.7220},{0.8254},{0.8254},{0.8769},{0.9424},{0.9424},{1}";
        String string3 = "." + File.separatorChar + "kdu_compress" + (String)object2;
        CoreUtilities.logInfo("kdu_compress command line is:  " + string3);
        CoreUtilities.logInfo("Note:  this command line is not actually executed, and is given only for information purposes.");
        CoreUtilities.logInfo("       Executing this command line may require proper quoting.");
        try {
            class SubStream
            implements Runnable {
                InputStreamReader in;
                PrintStream out;

                public SubStream(InputStream inputStream, PrintStream printStream) {
                    this.in = new InputStreamReader(inputStream);
                    this.out = printStream;
                }

                public void run() {
                    char[] cArray = new char[256];
                    try {
                        int n;
                        while ((n = this.in.read(cArray)) != -1) {
                            this.out.print(cArray);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
            }
            object = new ArrayList();
            object.add("." + File.separator + "kdu_compress");
            object.add("-i");
            object.add(string);
            object.add("-o");
            object.add(string2);
            object.add("-slope");
            object.add(this.currentParam.getSlope());
            object.add("Clayers=" + this.currentParam.getLayers());
            object.add("Corder=" + this.currentParam.getProgressionOrder());
            object.add("Clevels=" + this.currentParam.getLevels());
            object.add("Creversible=" + (this.currentParam.getUseReversible() ? "yes" : "no"));
            object.add("Cprecincts=" + this.currentParam.getPrecincts());
            object.add("Cblk=" + this.currentParam.getCodeBlockSize());
            object.add("ORGtparts=" + this.currentParam.getPacketDivision());
            object.add("ORGgen_plt=" + (this.currentParam.getInsertPLT() ? "yes" : "no"));
            Process process = Runtime.getRuntime().exec(object.toArray(new String[0]));
            InputStream inputStream = process.getErrorStream();
            InputStream inputStream2 = process.getInputStream();
            Thread thread = null;
            Thread thread2 = null;
            if (inputStream != null) {
                thread = new Thread(new SubStream(inputStream, System.err));
                thread.start();
            }
            if (inputStream2 != null) {
                thread2 = new Thread(new SubStream(inputStream2, System.out));
                thread2.start();
            }
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                thread2.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (process.waitFor() != 0) {
                throw new JPEG2KException("Error generating JPEG2000 file");
            }
        }
        catch (Exception exception) {
            throw new JPEG2KException(exception);
        }
    }
}

