/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.jpeg2000;

import com.luna.insight.core.jpeg2000.IJPEG2KDecodeParam;
import com.luna.insight.core.jpeg2000.IJPEG2KImageDecoder;
import com.luna.insight.core.jpeg2000.JPEG2KException;
import com.luna.insight.core.util.CoreUtilities;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import kdu_jni.Jp2_family_src;
import kdu_jni.Jp2_locator;
import kdu_jni.Jp2_source;
import kdu_jni.KduException;
import kdu_jni.Kdu_channel_mapping;
import kdu_jni.Kdu_codestream;
import kdu_jni.Kdu_compressed_source;
import kdu_jni.Kdu_coords;
import kdu_jni.Kdu_dims;
import kdu_jni.Kdu_global;
import kdu_jni.Kdu_region_decompressor;
import kdu_jni.Kdu_simple_file_source;

public class JPEG2KImageDecoderKDU
implements IJPEG2KImageDecoder {
    private String sourceFile;
    private IJPEG2KDecodeParam currentParam = null;

    public JPEG2KImageDecoderKDU(String string) {
        this.sourceFile = string;
    }

    public JPEG2KImageDecoderKDU(String string, IJPEG2KDecodeParam iJPEG2KDecodeParam) {
        this(string);
        this.currentParam = iJPEG2KDecodeParam;
    }

    public IJPEG2KDecodeParam getJPEG2KDecodeParam() {
        return this.currentParam;
    }

    public void setJPEG2KDecodeParam(IJPEG2KDecodeParam iJPEG2KDecodeParam) {
        this.currentParam = iJPEG2KDecodeParam;
    }

    public Raster decodeAsRaster() throws IOException, JPEG2KException {
        return null;
    }

    public BufferedImage decodeAsBufferedImage() throws IOException, JPEG2KException {
        String string;
        String string2;
        boolean bl = false;
        int n = 192;
        int n2 = 0;
        int n3 = 192;
        int n4 = 153;
        boolean bl2 = false;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        try {
            if (this.currentParam.getRegionbyFloat() != null) {
                string2 = this.currentParam.getRegionbyFloat();
                string = string2.substring(1, string2.indexOf(44));
                f2 = Float.parseFloat(string);
                string2 = string2.substring(string2.indexOf(44) + 1);
                string = string2.substring(0, string2.indexOf(125));
                f = Float.parseFloat(string);
                string2 = string2.substring(string2.indexOf(123) + 1);
                string = string2.substring(0, string2.indexOf(44));
                f4 = Float.parseFloat(string);
                string2 = string2.substring(string2.indexOf(44) + 1);
                string = string2.substring(0, string2.indexOf(125));
                f3 = Float.parseFloat(string);
                bl2 = true;
                CoreUtilities.logInfo("topFloat=" + f2);
                CoreUtilities.logInfo("leftFloat=" + f);
                CoreUtilities.logInfo("heightFloat=" + f4);
                CoreUtilities.logInfo("widthFloat=" + f3);
            } else if (this.currentParam.getRegion() != null) {
                string2 = this.currentParam.getRegion();
                string = string2.substring(1, string2.indexOf(44));
                n2 = Integer.parseInt(string);
                string2 = string2.substring(string2.indexOf(44) + 1);
                string = string2.substring(0, string2.indexOf(125));
                n = Integer.parseInt(string);
                string2 = string2.substring(string2.indexOf(123) + 1);
                string = string2.substring(0, string2.indexOf(44));
                n4 = Integer.parseInt(string);
                string2 = string2.substring(string2.indexOf(44) + 1);
                string = string2.substring(0, string2.indexOf(125));
                n3 = Integer.parseInt(string);
                bl = true;
                CoreUtilities.logInfo("top=" + n2);
                CoreUtilities.logInfo("left=" + n);
                CoreUtilities.logInfo("height=" + n4);
                CoreUtilities.logInfo("width=" + n3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JPEG2KException(exception);
        }
        try {
            Jp2_locator jp2_locator;
            if (!new File(this.sourceFile).exists()) {
                throw new FileNotFoundException("Unable to locate " + this.sourceFile);
            }
            string2 = new Jp2_source();
            string = null;
            Kdu_simple_file_source kdu_simple_file_source = new Kdu_simple_file_source();
            Jp2_family_src jp2_family_src = new Jp2_family_src();
            Jp2_source jp2_source = new Jp2_source();
            if (JPEG2KImageDecoderKDU.check_jp2_compatible_suffix(this.sourceFile)) {
                jp2_locator = new Jp2_locator();
                jp2_family_src.Open(this.sourceFile, true);
                jp2_source.Open(jp2_family_src, jp2_locator);
                jp2_source.Read_header();
                string = jp2_source;
            } else {
                kdu_simple_file_source.Open(this.sourceFile, true);
                string = kdu_simple_file_source;
            }
            jp2_locator = new Kdu_codestream();
            jp2_locator.Create((Kdu_compressed_source)string);
            Kdu_channel_mapping kdu_channel_mapping = new Kdu_channel_mapping();
            if (string2.Exists()) {
                CoreUtilities.logInfo("InputSource exists: TRUE");
                kdu_channel_mapping.Configure((Jp2_source)string2, false);
            } else {
                CoreUtilities.logInfo("InputSource exists: FALSE");
                kdu_channel_mapping.Configure((Kdu_codestream)jp2_locator);
            }
            int n5 = kdu_channel_mapping.Get_source_component(0);
            Kdu_coords kdu_coords = JPEG2KImageDecoderKDU.determine_reference_expansion(n5, kdu_channel_mapping, (Kdu_codestream)jp2_locator);
            Kdu_dims kdu_dims = new Kdu_dims();
            jp2_locator.Get_dims(n5, kdu_dims);
            Kdu_coords kdu_coords2 = kdu_dims.Access_size();
            Kdu_coords kdu_coords3 = kdu_dims.Access_pos();
            if (bl2) {
                n = Math.round((float)kdu_coords3.Get_x() + f * (float)kdu_coords2.Get_x());
                n2 = Math.round((float)kdu_coords3.Get_y() + f2 * (float)kdu_coords2.Get_y());
                n3 = Math.round(f3 * (float)kdu_coords2.Get_x());
                n4 = Math.round(f4 * (float)kdu_coords2.Get_y());
            }
            if (bl || bl2) {
                kdu_coords2.Set_x(n3);
                kdu_coords2.Set_y(n4);
                kdu_coords3.Set_x(n);
                kdu_coords3.Set_y(n2);
            }
            int n6 = 1 << this.currentParam.getLevelReductionFactor();
            kdu_coords2.Set_x(kdu_coords2.Get_x() * kdu_coords.Get_x());
            CoreUtilities.logInfo("ImageSize: x = " + kdu_coords2.Get_x());
            kdu_coords2.Set_y(kdu_coords2.Get_y() * kdu_coords.Get_y());
            CoreUtilities.logInfo("ImageSize: y = " + kdu_coords2.Get_y());
            kdu_coords3.Set_x(kdu_coords3.Get_x() * kdu_coords.Get_x() / n6 - (kdu_coords.Get_x() / n6 - 1) / 2);
            CoreUtilities.logInfo("Image Position: x = " + kdu_coords3.Get_x());
            kdu_coords3.Set_y(kdu_coords3.Get_y() * kdu_coords.Get_y() / n6 - (kdu_coords.Get_y() / n6 - 1) / 2);
            CoreUtilities.logInfo("Image Position: y = " + kdu_coords3.Get_y());
            CoreUtilities.logInfo("x=" + kdu_dims.Access_pos().Get_x() + ",y=" + kdu_dims.Access_pos().Get_y());
            CoreUtilities.logInfo("width=" + kdu_dims.Access_size().Get_x() + ",height=" + kdu_dims.Access_size().Get_y());
            CoreUtilities.logInfo("LevelReductionFactor=" + this.currentParam.getLevelReductionFactor());
            Kdu_dims kdu_dims2 = new Kdu_dims();
            kdu_dims2.Assign(kdu_dims);
            kdu_dims2.Access_size().Set_x(kdu_coords2.Get_x());
            kdu_dims2.Access_size().Set_y(kdu_coords2.Get_y());
            int n7 = kdu_coords2.Get_x() * kdu_coords2.Get_y();
            int[] nArray = new int[n7];
            Kdu_region_decompressor kdu_region_decompressor = new Kdu_region_decompressor();
            kdu_region_decompressor.Start((Kdu_codestream)jp2_locator, kdu_channel_mapping, -1, this.currentParam.getLevelReductionFactor(), 16384, kdu_dims, kdu_coords, new Kdu_coords(1, 1));
            Kdu_dims kdu_dims3 = new Kdu_dims();
            Kdu_dims kdu_dims4 = new Kdu_dims();
            kdu_dims4.Assign(kdu_dims);
            BufferedImage bufferedImage = new BufferedImage(kdu_coords2.Get_x(), kdu_coords2.Get_y(), 1);
            while (kdu_region_decompressor.Process(nArray, kdu_dims.Access_pos(), 0, 0, n7, kdu_dims4, kdu_dims3)) {
                Kdu_coords kdu_coords4 = kdu_dims3.Access_pos().Minus(kdu_dims.Access_pos());
                bufferedImage.setRGB(0, kdu_coords4.Get_y(), kdu_dims3.Access_size().Get_x(), kdu_dims3.Access_size().Get_y(), nArray, 0, kdu_coords2.Get_x());
            }
            kdu_region_decompressor.Finish();
            jp2_locator.Destroy();
            string.Close();
            return bufferedImage;
        }
        catch (KduException kduException) {
            kduException.printStackTrace();
            throw new JPEG2KException((Exception)((Object)kduException));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JPEG2KException(exception);
        }
    }

    private Kdu_compressed_source readSource(Jp2_source jp2_source) throws KduException {
        Kdu_simple_file_source kdu_simple_file_source = null;
        Kdu_simple_file_source kdu_simple_file_source2 = new Kdu_simple_file_source();
        Jp2_family_src jp2_family_src = new Jp2_family_src();
        if (JPEG2KImageDecoderKDU.check_jp2_compatible_suffix(this.sourceFile)) {
            Jp2_locator jp2_locator = new Jp2_locator();
            jp2_family_src.Open(this.sourceFile, true);
            jp2_source.Open(jp2_family_src, jp2_locator);
            jp2_source.Read_header();
            kdu_simple_file_source = jp2_source;
        } else {
            kdu_simple_file_source2.Open(this.sourceFile, true);
            kdu_simple_file_source = kdu_simple_file_source2;
        }
        return kdu_simple_file_source;
    }

    private static boolean check_jp2_compatible_suffix(String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith("JP2") || string2.endsWith("JPX");
    }

    private static Kdu_coords determine_reference_expansion(int n, Kdu_channel_mapping kdu_channel_mapping, Kdu_codestream kdu_codestream) throws KduException {
        int n2;
        Kdu_coords kdu_coords = new Kdu_coords();
        Kdu_coords kdu_coords2 = new Kdu_coords();
        kdu_codestream.Get_subsampling(n, kdu_coords);
        Kdu_coords kdu_coords3 = new Kdu_coords();
        kdu_coords3.Assign(kdu_coords);
        for (n2 = 0; n2 < kdu_channel_mapping.Get_num_channels(); ++n2) {
            kdu_codestream.Get_subsampling(kdu_channel_mapping.Get_source_component(n2), kdu_coords2);
            if (kdu_coords2.Get_x() < kdu_coords3.Get_x()) {
                kdu_coords3.Set_x(kdu_coords2.Get_x());
            }
            if (kdu_coords2.Get_y() >= kdu_coords3.Get_y()) continue;
            kdu_coords3.Set_y(kdu_coords2.Get_y());
        }
        CoreUtilities.logInfo(kdu_coords.Get_x() + " / " + kdu_coords3.Get_x());
        Kdu_coords kdu_coords4 = new Kdu_coords();
        kdu_coords4.Set_x(kdu_coords.Get_x() / kdu_coords3.Get_x());
        kdu_coords4.Set_y(kdu_coords.Get_y() / kdu_coords3.Get_y());
        for (n2 = 0; n2 < kdu_channel_mapping.Get_num_channels(); ++n2) {
            kdu_codestream.Get_subsampling(kdu_channel_mapping.Get_source_component(n2), kdu_coords2);
            if (kdu_coords2.Get_x() * kdu_coords4.Get_x() % kdu_coords.Get_x() == 0 && kdu_coords2.Get_y() * kdu_coords4.Get_y() % kdu_coords.Get_y() == 0) continue;
            Kdu_global.Kdu_print_error((String)"The supplied JP2 file contains colour channels whose sub-sampling factors are not integer multiples of one another.");
            kdu_codestream.Apply_input_restrictions(0, 1, 0, 0, null);
            kdu_channel_mapping.Configure(kdu_codestream);
            kdu_coords4 = new Kdu_coords(1, 1);
        }
        return kdu_coords4;
    }
}

