/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.jpeg2000;

import com.luna.insight.core.jpeg2000.IJPEG2KDecodeParam;
import com.luna.insight.core.jpeg2000.IJPEG2KImageDecoder;
import com.luna.insight.core.jpeg2000.ImagePanel3;
import com.luna.insight.core.jpeg2000.JPEG2KCodec;
import com.luna.insight.core.jpeg2000.JPEG2KException;
import com.luna.insight.core.util.CoreUtilities;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFrame;

public class JPEG2KExtract {
    public static void debugOut(IJPEG2KDecodeParam iJPEG2KDecodeParam) {
        CoreUtilities.logInfo("----------------------------------------");
        CoreUtilities.logInfo("Debug - params Object: " + iJPEG2KDecodeParam.toString());
        CoreUtilities.logInfo("Debug - Level Reduction Factor: " + iJPEG2KDecodeParam.getLevelReductionFactor());
        CoreUtilities.logInfo("Debug - Region: " + iJPEG2KDecodeParam.getRegion());
        CoreUtilities.logInfo("Debug - Region (float): " + iJPEG2KDecodeParam.getRegionbyFloat());
        CoreUtilities.logInfo("----------------------------------------");
    }

    public static void showHelp() {
        CoreUtilities.logAlways("\nLuna Jpeg 2000 extractor\n");
        CoreUtilities.logAlways("The Jpeg2000 extractor normally reads its configuration\ninformation from a file named InsightJPEG2Compression.dat.\nHowever, you may override the options specified in that file by\nusing the following command line options.");
        CoreUtilities.logAlways("\nUsage:\n   java com.luna.insight.core.jpeg2000.JPEG2KExtract\n   -i <input>  -o <output>\n   [-reduce <reduce>]\n   [-int_region <int_region> | -region <region>]");
        CoreUtilities.logAlways("\nOptions:Usage options to come...");
        System.exit(0);
    }

    public static void extractImage(String string, String string2, IJPEG2KDecodeParam iJPEG2KDecodeParam) throws IOException, JPEG2KException {
        long l = System.currentTimeMillis();
        FileInputStream fileInputStream = new FileInputStream(string);
        IJPEG2KImageDecoder iJPEG2KImageDecoder = JPEG2KCodec.createJPEG2KDecoder(string, iJPEG2KDecodeParam);
        CoreUtilities.logInfo("Debug - Image source: " + string);
        JPEG2KExtract.debugOut(iJPEG2KDecodeParam);
        BufferedImage bufferedImage = iJPEG2KImageDecoder.decodeAsBufferedImage();
        long l2 = System.currentTimeMillis();
        CoreUtilities.logInfo("Time to decode and generate BufferedImage: " + (double)(l2 - l) / 1000.0);
        JPEG2KExtract.displayImage(bufferedImage);
        long l3 = System.currentTimeMillis();
        CoreUtilities.logInfo("Time to display BufferedImage: " + (double)(l3 - l2) / 1000.0);
        if (bufferedImage != null) {
            FileOutputStream fileOutputStream = null;
            BufferedOutputStream bufferedOutputStream = null;
            fileOutputStream = new FileOutputStream(string2);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            int n = 15;
            if (n < 0) {
                n = 0;
            } else if (n > 100) {
                n = 100;
            }
            float f = 1.0f - (float)n / 100.0f;
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality(f, true);
            jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
            bufferedImage.flush();
            bufferedImage = null;
            bufferedOutputStream.close();
            long l4 = System.currentTimeMillis();
            CoreUtilities.logInfo("Time to encode and write image: " + (double)(l4 - l3) / 1000.0);
        }
        fileInputStream.close();
    }

    private static void displayImage(BufferedImage bufferedImage) {
        ImagePanel3 imagePanel3 = new ImagePanel3(bufferedImage);
        JFrame jFrame = new JFrame("ImageDisplayer");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add((Component)imagePanel3, "Center");
        jFrame.setSize(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight() + 15));
        jFrame.setVisible(true);
    }
}

