/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.jpeg2000;

import com.luna.insight.core.jpeg2000.IJPEG2KEncodeParam;
import com.luna.insight.core.jpeg2000.JPEG2KConstants;
import com.luna.insight.core.util.EnhancedProperties;

public class JPEG2KEncodeParam
implements IJPEG2KEncodeParam {
    private String rate = JPEG2KConstants.DEFAULT_COMPRESSION_RATE;
    private String slope = "51651,51337,51186,50804,50548,50232";
    private int layers = 6;
    private int levels = 0;
    private boolean useReversible = true;
    private String precincts = "{256,256},{256,256},{128,128}";
    private String progressionOrder = "RPCL";
    private boolean insertPLT = true;
    private String packetDivision = "R";
    private String codeBlockSize = "{32,32}";

    public JPEG2KEncodeParam(EnhancedProperties enhancedProperties) {
        if (enhancedProperties != null) {
            this.rate = enhancedProperties.getProperty("rate", this.rate);
            this.slope = enhancedProperties.getProperty("slope", this.slope);
            this.layers = enhancedProperties.getIntegerProperty("Clayers", this.layers);
            this.levels = enhancedProperties.getIntegerProperty("Clevels", this.levels);
            this.useReversible = enhancedProperties.getBooleanProperty("Creversible", this.useReversible);
            this.precincts = enhancedProperties.getProperty("Cprecincts", this.precincts);
            this.progressionOrder = enhancedProperties.getProperty("Corder", this.progressionOrder);
            this.insertPLT = enhancedProperties.getBooleanProperty("ORGgen_plt", this.insertPLT);
            this.packetDivision = enhancedProperties.getProperty("ORGtparts", this.packetDivision);
            this.codeBlockSize = enhancedProperties.getProperty("Cblk", this.codeBlockSize);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getRate() {
        return this.rate;
    }

    public void setRate(String string) {
        this.rate = string;
    }

    public String getSlope() {
        return this.slope;
    }

    public void setSlope(String string) {
        this.slope = string;
    }

    public int getLayers() {
        return this.layers;
    }

    public void setLayers(int n) {
        this.layers = n;
    }

    public int getLevels() {
        return this.levels;
    }

    public void setLevels(int n) {
        this.levels = n;
    }

    public boolean getUseReversible() {
        return this.useReversible;
    }

    public void setUseReversible(boolean bl) {
        this.useReversible = bl;
    }

    public String getPrecincts() {
        return this.precincts;
    }

    public void setPrecincts(String string) {
        this.precincts = string;
    }

    public String getProgressionOrder() {
        return this.progressionOrder;
    }

    public void setProgressionOrder(String string) {
        this.progressionOrder = string;
    }

    public boolean getInsertPLT() {
        return this.insertPLT;
    }

    public void setInsertPLT(boolean bl) {
        this.insertPLT = bl;
    }

    public String getPacketDivision() {
        return this.packetDivision;
    }

    public void setPacketDivision(String string) {
        this.packetDivision = string;
    }

    public String getCodeBlockSize() {
        return this.codeBlockSize;
    }

    public void setCodeBlockSize(String string) {
        this.codeBlockSize = string;
    }

    public String toString() {
        return "[rate=" + this.getRate() + ", slope=" + this.getSlope() + ", layers=" + this.getLayers() + ", levels=" + this.getLevels() + ", useReversible=" + this.getUseReversible() + ", precincts=" + this.getPrecincts() + ", progressionOrder=" + this.getProgressionOrder() + ", insertPLT=" + this.getInsertPLT() + ", packetDivision=" + this.getPacketDivision() + ", codeBlockSize=" + this.getCodeBlockSize() + "]";
    }

    public String toKduCompressArgs() {
        return "-slope " + this.getSlope() + " Clayers=" + this.getLayers() + " Corder=" + this.getProgressionOrder() + " Clevels=" + this.getLevels() + " Creversible=" + (this.getUseReversible() ? "yes" : "no") + " Cprecincts=" + this.getPrecincts() + " Cblk=" + this.getCodeBlockSize() + " ORGtparts=" + this.getPacketDivision() + " ORGgen_plt=" + (this.getInsertPLT() ? "yes" : "no");
    }
}

