/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.jpeg2000;

import com.luna.insight.core.jpeg2000.IJPEG2KEncodeParam;
import com.luna.insight.core.jpeg2000.IJPEG2KImageEncoder;
import com.luna.insight.core.jpeg2000.JPEG2KCodec;
import com.luna.insight.core.jpeg2000.JPEG2KException;
import com.luna.insight.core.license.InsightLicenseClientManager;
import com.luna.insight.core.util.CoreUtilities;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;

public class JPEG2KCompress {
    protected static final int HIGH = 3;
    protected static final int MEDIUM = 2;
    protected static final int LOW = 1;
    protected static final int OFF = 0;
    protected static int DEBUG_MODE = 0;

    public static void setDebugLevel(int n) {
        if (n >= 0 && n <= 3) {
            DEBUG_MODE = n;
        }
        switch (DEBUG_MODE) {
            case 3: {
                CoreUtilities.setDebugLevel(5);
                break;
            }
            case 2: {
                CoreUtilities.setDebugLevel(4);
                break;
            }
            case 1: {
                CoreUtilities.setDebugLevel(3);
                break;
            }
            case 0: {
                CoreUtilities.setDebugLevel(0);
            }
        }
    }

    public static void debugOut(IJPEG2KEncodeParam iJPEG2KEncodeParam) {
        CoreUtilities.logInfo("----------------------------------------");
        CoreUtilities.logInfo("Debug - params Object: " + iJPEG2KEncodeParam.toString());
        CoreUtilities.logInfo("Debug - Slope: " + iJPEG2KEncodeParam.getSlope());
        CoreUtilities.logInfo("Debug - Levels: " + iJPEG2KEncodeParam.getLevels());
        CoreUtilities.logInfo("Debug - Layers: " + iJPEG2KEncodeParam.getLayers());
        CoreUtilities.logInfo("Debug - Use Reversible?: " + iJPEG2KEncodeParam.getUseReversible());
        CoreUtilities.logInfo("Debug - Precincts: " + iJPEG2KEncodeParam.getPrecincts());
        CoreUtilities.logInfo("Debug - Packet Division: " + iJPEG2KEncodeParam.getPacketDivision());
        CoreUtilities.logInfo("Debug - Code Block Size: " + iJPEG2KEncodeParam.getCodeBlockSize());
        CoreUtilities.logInfo("Debug - Progression Order: " + iJPEG2KEncodeParam.getProgressionOrder());
        CoreUtilities.logInfo("Debug - Insert PLT?: " + iJPEG2KEncodeParam.getInsertPLT());
        CoreUtilities.logInfo("----------------------------------------");
    }

    public static void showHelp() {
        CoreUtilities.logAlways("\nLuna Jpeg 2000 Compressor\n");
        CoreUtilities.logAlways("The Jpeg2000 compressor normally reads its configuration\ninformation from a file named InsightJPEG2Compression.dat.\nHowever, you may override the options specified in that file by\nusing the following command line options.");
        CoreUtilities.logAlways("\nOptions (Summary):\n\n   -i <input>\n   -o <output>\n   [-installdir <path to installation directory>]\n   [-debug <0|1|2|3>]\n   [-slope <slope1,slope2,...>]\n   [-Clayers <Clayers>]\n   [-Clevels <Clevels>]\n   [-Creversible <yes|no>]\n   [-Cprecincts <{int1a,int1b},...>]\n   [-Corder <LRCP|RLCP|RPCL|PCRL|CPRL>]\n   [-ORGgen_plt <yes|no>]\n   [-ORGtparts <R|L|C>]\n   [-Cblk <{w,h}>]");
        CoreUtilities.logAlways("\n\nOptions (Details):\n\n   -i <input>\n      Path to source input files. Currently accepted image file formats include\n      TIFF, JPEG, BMP.\n\n   -o <compressed file -- raw code-stream, JP2 or JPX file>\n      Name of file to receive the compressed code-stream.\n\n   -installdir <path to installation directory>\n      File path of the base installation directory for the Encoder\n      application.\n\n   -debug <0|1|2|3>\n      Enables debug output during image processing; 0 = off, 3 = high.\n\n      Default: debug = 0\n\n   -slope <layer slope>,<layer slope>,...\n       This argument provides rate control information directly in\n       terms of distortion-length slope values, overriding any information.\n       The number of layer slopes defined must be equal to that of Qlayers.\n       Slopes are inversely related to bit-rate, so the slopes should decrease\n       from layer to layer.\n\n       The program automatically sorts slopes into decreasing order so you need\n       not worry about getting the order right.  For reference we note that a\n       slope value of 0 means that all compressed bits will be included by the\n       end of the relevant layer, while a slope value of 65535 means that no\n       compressed bits will be included in the  layer.\n\n       * Use 0 for truly lossless compression, ensure Clayers is set to 1.\n       * Use [51651,51337,51186,50804,50548,50232] for standard compression\n         (~20 to 1 compression ratio with 6 quality layers)\n\n       ** Quick Reference Guide for Slope to Compression Ration **\n       Exact compression ration will vary depending on detail in source image.\n      0     = ~ 2   / 1 (lossless)\n      50000 = ~ 11  / 1\n      50125 = ~ 13  / 1\n      50250 = ~ 15  / 1\n      50500 = ~ 20  / 1\n      51000 = ~ 32  / 1\n      52000 = ~ 115 / 1\n\n      Default: slope = 51651,51337,51186,50804,50548,50232\n\n   -Clayers <Clayers>\n      Number of quality layers. May not exceed 16384.\n\n      Default: Clayers = 6\n\n   -Clevels <Clevels>\n      Number of wavelet decomposition levels, or stages.  May not exceed 32.\n      Value of 0 indicates that Insight should determine the number of\n      decomposition levels using the Insight 96 pixel factor.\n\n      Default: Clevels = 0\n\n   -Creversible <yes|no>\n      Determine the wavelet to apply during compression.\n      Yes, uses a wavelet transform that is mathematically reversible.\n      The W5X3 wavelet kernel is used for reversible compression.\n\n      Default: Creversible = yes\n\n   -Cprecincts <{int1a,int1b},...>\n      Precinct dimensions (must be powers of 2). Multiple records may be\n      supplied, in which case the first record refers to the highest\n      resolution level and subsequent records to lower resolution levels. The\n      last specified record is used for any remaining lower resolution\n      levels. Inside each record, vertical coordinates appear first.\n\n      Default: Cprecincts = {256,256},{256,256},{128,128}\n\n   -Corder <LRCP|RLCP|RPCL|PCRL|CPRL>]\n      Default progression order.  The four character identifiers have the\n      following interpretation: L=layer; R=resolution; C=component; P=position.\n      The first character in the identifier refers to the index which\n      progresses most slowly, while the last refers to the index which\n      progresses most quickly.\n\n      Default: Corder = RPCL\n\n   -ORGgen_plt <yes|no>]\n      Requests the insertion of packet length information in the header of all\n      tile-parts associated with tiles for which this attribute is turned on\n      (has a value of 'yes').\n\n      Default: ORGgen_plt = yes\n\n   -ORGtparts <R|L|C>\n      Controls the division of each tile's packets into tile-parts.  The\n      attribute consists of one or more of the flags, `R', `L' and `C',\n      separated by the vertical bar character, `|'. If the `R' flag is\n      supplied, tile-parts will be introduced as necessary to ensure that each\n      tile-part consists of packets from only one resolution level.  If `L' is\n      supplied, tile-parts are introduced as necessary to ensure that each\n      tile-part consists of packets from only one quality layer.  Similarly, if\n      the `C' flag is supplied, each tile-part will consist of packets from\n      only one component.\n\n      Default: ORGtparts = R\n\n    -Cblk <{w,h}>\n      Defines the size of each code block.  Vertical coordinates appear first.\n\n      Default:         Cblk = {32,32}\n\n\nExamples:\n\n  a) JPEG2KCompress -i image.tif -o out.jp2 -Clayers 6\n     -slope 51651,51337,51186,50804,50548,50232\n\n     -- reversible compression to a 6 layer code-stream (6 embedded slopes)\n     -- Provides a relative compression ratio based on quality, target\n        compression ratio at 20 to 1.\n     -- Visually lossless up to 3.5 x\n\n  b) JPEG2KCompress -i image.tif -o out.jp2 -slope 0, -Clayers 1\n\n     -- reversible lossless compression\n     -- Provides truly lossless compression at around 2 to 1 compression ratio.");
        System.exit(0);
    }

    public static void compressImage(String string, String string2, IJPEG2KEncodeParam iJPEG2KEncodeParam) throws JPEG2KException, IOException {
        IJPEG2KImageEncoder iJPEG2KImageEncoder = JPEG2KCodec.createJPEG2KEncoder(string2);
        CoreUtilities.logInfo("Debug - Buffer Image source: " + string);
        if (iJPEG2KEncodeParam != null) {
            JPEG2KCompress.debugOut(iJPEG2KEncodeParam);
        }
        iJPEG2KImageEncoder.encode(string, iJPEG2KEncodeParam);
    }

    public static void compressImage(String string, String string2) throws IOException, JPEG2KException {
        IJPEG2KImageEncoder iJPEG2KImageEncoder = JPEG2KCodec.createJPEG2KEncoder(string2);
        CoreUtilities.logInfo("Debug - Buffer Image source: " + string);
        iJPEG2KImageEncoder.encode(string);
    }

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length == 0) {
            JPEG2KCompress.showHelp();
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equalsIgnoreCase("-h") && !stringArray[n].equalsIgnoreCase("-help")) continue;
            JPEG2KCompress.showHelp();
        }
        int n2 = DEBUG_MODE;
        JPEG2KCompress.setDebugLevel(n2);
        String string = "InsightJPEG2Compression.dat";
        String string2 = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("-installdir")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                string2 = stringArray[++n];
                CoreUtilities.logInfo("Setting Installation directory to " + string2);
                string = CoreUtilities.concatFilepath(string2, string);
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("-debug") || stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
            ++n;
            try {
                n2 = Integer.parseInt(stringArray[n]);
                JPEG2KCompress.setDebugLevel(n2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                CoreUtilities.logAlways("Error parsing <-debug>; Ignored. " + numberFormatException);
            }
        }
        JPEG2KCodec.configure(string);
        InsightLicenseClientManager insightLicenseClientManager = new InsightLicenseClientManager(JPEG2KCodec.getLicenseFilePath(string2));
        boolean bl = insightLicenseClientManager.checkInsightJp2kEncoderLicense(false);
        if (!bl) {
            CoreUtilities.logAlways("\nExiting due to invalid Jpeg2000 Encoder license\n");
            System.exit(0);
        }
        String string3 = null;
        String string4 = "result.jp2";
        IJPEG2KEncodeParam iJPEG2KEncodeParam = JPEG2KCodec.getDefaultJPEG2KEncodeParam();
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("-h") || stringArray[n].equalsIgnoreCase("-help")) {
                JPEG2KCompress.showHelp();
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-i")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                string3 = stringArray[++n];
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-o")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                string4 = stringArray[++n];
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-rate")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                iJPEG2KEncodeParam.setRate(stringArray[++n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-slope")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                iJPEG2KEncodeParam.setSlope(stringArray[++n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-Clayers")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                ++n;
                try {
                    int n3 = Integer.parseInt(stringArray[n]);
                    iJPEG2KEncodeParam.setLayers(n3);
                }
                catch (NumberFormatException numberFormatException) {
                    CoreUtilities.logAlways("Error parsing <-Clayers>; Ignored. " + numberFormatException);
                }
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-Clevels")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                ++n;
                try {
                    int n4 = Integer.parseInt(stringArray[n]);
                    iJPEG2KEncodeParam.setLevels(n4);
                }
                catch (NumberFormatException numberFormatException) {
                    CoreUtilities.logAlways("Error parsing <-Clevels>; Ignored. " + numberFormatException);
                }
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-Creversible")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                if (stringArray[++n].equalsIgnoreCase("yes")) {
                    iJPEG2KEncodeParam.setUseReversible(true);
                    continue;
                }
                iJPEG2KEncodeParam.setUseReversible(false);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-Cprecincts")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                iJPEG2KEncodeParam.setPrecincts(stringArray[++n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-Corder")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                iJPEG2KEncodeParam.setProgressionOrder(stringArray[++n]);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-ORGgen_plt")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                if (stringArray[++n].equalsIgnoreCase("yes")) {
                    iJPEG2KEncodeParam.setInsertPLT(true);
                    continue;
                }
                iJPEG2KEncodeParam.setInsertPLT(false);
                continue;
            }
            if (stringArray[n].equalsIgnoreCase("-ORGtparts")) {
                if (stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
                iJPEG2KEncodeParam.setPacketDivision(stringArray[++n]);
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("-Cblk") || stringArray.length <= n + 1 || stringArray[n + 1] == null) continue;
            iJPEG2KEncodeParam.setCodeBlockSize(stringArray[++n]);
        }
        if (string3 == null) {
            try {
                JFrame jFrame = new JFrame();
                FileDialog fileDialog = new FileDialog((Frame)jFrame, "Select an image file to convert..");
                fileDialog.setMode(0);
                fileDialog.show();
                if (CoreUtilities.isEmpty(fileDialog.getFile())) {
                    System.exit(0);
                }
                File file = new File(fileDialog.getDirectory() + fileDialog.getFile());
                string3 = file.getAbsolutePath();
                CoreUtilities.logInfo("Chose file: " + string3);
            }
            catch (HeadlessException headlessException) {
                System.exit(0);
            }
        }
        try {
            long l = System.currentTimeMillis();
            JPEG2KCompress.compressImage(string3, string4, iJPEG2KEncodeParam);
            long l2 = System.currentTimeMillis();
            CoreUtilities.logInfo("Total Time to Compress:            " + (double)(l2 - l) / 1000.0 + " seconds");
        }
        catch (Exception exception) {
            CoreUtilities.logError("Error in CompressImage " + exception);
            exception.printStackTrace();
        }
        System.exit(0);
    }
}

