/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.jpeg2000;

import com.luna.insight.core.jpeg2000.IJPEG2KDecodeParam;
import com.luna.insight.core.jpeg2000.IJPEG2KEncodeParam;
import com.luna.insight.core.jpeg2000.IJPEG2KImageDecoder;
import com.luna.insight.core.jpeg2000.IJPEG2KImageEncoder;
import com.luna.insight.core.jpeg2000.JPEG2KDecodeParam;
import com.luna.insight.core.jpeg2000.JPEG2KEncodeParam;
import com.luna.insight.core.jpeg2000.JPEG2KImageDecoderKDU;
import com.luna.insight.core.jpeg2000.JPEG2KImageEncoderKDU;
import com.luna.insight.core.util.CoreConstants;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.EnhancedProperties;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.process.ImageProcessor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.sf.ij.jaiio.JAIReader;

public class JPEG2KCodec {
    private static EnhancedProperties properties = null;

    private JPEG2KCodec() {
    }

    public static void debugMemory(String string) {
        CoreUtilities.logInfo("Memory Usage: " + string + " = " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1000000L + "Mb");
    }

    public static void configure() {
        JPEG2KCodec.configure("InsightJPEG2Compression.dat");
    }

    public static void configure(String string) {
        properties = JPEG2KCodec.loadProperties(string);
        if (!CoreConstants.EXECUTING_ON_MAC_OS_X) {
            try {
                System.loadLibrary("kdu_v45R");
                System.loadLibrary("kdu_jni");
            }
            catch (Exception exception) {
                CoreUtilities.logError("Unable to load libraries: kdu_v45R and kdu_jni");
            }
        }
    }

    protected static EnhancedProperties loadProperties(String string) {
        EnhancedProperties enhancedProperties = new EnhancedProperties();
        try {
            CoreUtilities.logInfo("propsfile: " + string);
            FileInputStream fileInputStream = new FileInputStream(string);
            enhancedProperties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            CoreUtilities.logError("Using default properties since could not find a configuration file: " + string);
        }
        return enhancedProperties;
    }

    protected static String getLicenseFilePath(String string) {
        return properties != null ? properties.getProperty("LicenseFilePath", CoreUtilities.concatFilepath(string, "License-Files")) : CoreUtilities.concatFilepath(string, "License-Files");
    }

    public static BufferedImage openImageAsBufferedImage(String string) throws IOException {
        ImagePlus imagePlus = JPEG2KCodec.openImageJ(string);
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        BufferedImage bufferedImage = new BufferedImage(imageProcessor.getWidth(), imageProcessor.getHeight(), 1);
        imagePlus.flush();
        imagePlus = null;
        imageProcessor = null;
        return bufferedImage;
    }

    public static ImagePlus openImageJ(String string) throws IOException {
        Opener opener = new Opener();
        ImagePlus imagePlus = opener.openImage(string);
        if (imagePlus == null) {
            CoreUtilities.logInfo("Attempting to use JAI to open the file, ImagePlus Failed");
            try {
                File file = new File(string);
                ImagePlus[] imagePlusArray = JAIReader.read((File)file);
                imagePlus = imagePlusArray[0];
                if (imagePlus.getOriginalFileInfo() == null) {
                    FileInfo fileInfo = imagePlus.getFileInfo();
                    fileInfo.directory = file.getParent();
                    fileInfo.fileName = file.getName();
                    imagePlus.setFileInfo(fileInfo);
                }
            }
            catch (Exception exception) {
                throw new IOException("Could not open the image as ImagePlus or in JAI");
            }
        }
        if (imagePlus == null) {
            throw new IOException("Could not open the image as ImagePlus");
        }
        return imagePlus;
    }

    public static BufferedImage openImageAsComplexBufferedImage(String string) throws IOException {
        ImagePlus imagePlus = JPEG2KCodec.openImageJ(string);
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        Image image = imageProcessor.createImage();
        imagePlus.flush();
        imagePlus = null;
        imageProcessor = null;
        JPEG2KCodec.debugMemory("Before BufferedImage + Graphic Creation");
        BufferedImage bufferedImage = new BufferedImage(n, n2, 5);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image, 0, 0, null);
        JPEG2KCodec.debugMemory("After Image + BufferedImage + Graphic Creation");
        image.flush();
        image = null;
        graphics.dispose();
        graphics = null;
        System.gc();
        return bufferedImage;
    }

    public static IJPEG2KImageDecoder createJPEG2KDecoder(String string) {
        return new JPEG2KImageDecoderKDU(string);
    }

    public static IJPEG2KImageDecoder createJPEG2KDecoder(String string, IJPEG2KDecodeParam iJPEG2KDecodeParam) {
        return new JPEG2KImageDecoderKDU(string, iJPEG2KDecodeParam);
    }

    public static IJPEG2KImageEncoder createJPEG2KEncoder(String string) {
        return new JPEG2KImageEncoderKDU(string);
    }

    public static IJPEG2KImageEncoder createJPEG2KEncoder(String string, IJPEG2KEncodeParam iJPEG2KEncodeParam) {
        return new JPEG2KImageEncoderKDU(string, iJPEG2KEncodeParam);
    }

    public static IJPEG2KEncodeParam getDefaultJPEG2KEncodeParam(BufferedImage bufferedImage) {
        JPEG2KEncodeParam jPEG2KEncodeParam = new JPEG2KEncodeParam(properties);
        jPEG2KEncodeParam.setLevels(JPEG2KCodec.determineResolution(bufferedImage.getWidth(), bufferedImage.getHeight()));
        return jPEG2KEncodeParam;
    }

    public static IJPEG2KEncodeParam getDefaultJPEG2KEncodeParam(String string) throws IOException, IOException {
        BufferedImage bufferedImage = JPEG2KCodec.openImageAsBufferedImage(string);
        IJPEG2KEncodeParam iJPEG2KEncodeParam = JPEG2KCodec.getDefaultJPEG2KEncodeParam(bufferedImage);
        bufferedImage.flush();
        bufferedImage = null;
        return iJPEG2KEncodeParam;
    }

    public static IJPEG2KEncodeParam getDefaultJPEG2KEncodeParam() {
        return new JPEG2KEncodeParam(properties);
    }

    public static IJPEG2KDecodeParam getDefaultJPEG2KDecodeParam() {
        return new JPEG2KDecodeParam(properties);
    }

    protected static int determineResolution(int n, int n2) {
        int n3;
        int n4 = 96;
        int n5 = 0;
        if (n3 > 0) {
            int n6 = 1;
            for (n3 = (var2_2 = n2) > (var3_3 = n) ? var2_2 : var3_3; n3 >= n4; n3 /= 2) {
                n5 = n6++;
            }
        } else {
            CoreUtilities.logError("determineResolution received incorrect criteria: width=" + n + " height=" + n2);
        }
        return n5;
    }
}

