/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog.iface;

import com.luna.insight.core.catalog.edit.BaseTemplateEdit;
import com.luna.insight.core.catalog.edit.CatalogEdit;
import com.luna.insight.core.catalog.edit.EntityFieldEdit;
import com.luna.insight.core.catalog.edit.EntityTypeEdit;
import com.luna.insight.core.catalog.iface.BaseEntityField;
import com.luna.insight.core.catalog.iface.BaseEntityType;
import com.luna.insight.core.catalog.iface.BaseTemplateElement;
import com.luna.insight.core.catalog.iface.ITemplate;
import com.luna.insight.core.catalog.utils.TemplateCompareException;
import com.luna.insight.core.util.CoreUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public abstract class BaseTemplate
implements Serializable,
ITemplate {
    protected int templateID;
    protected String templateName;
    protected String version = null;
    protected String versionInfo = null;
    protected String descriptionURL = null;
    protected int creatorID;
    protected boolean isPublished;
    protected boolean isPersonalCollectionTemplate;
    protected transient boolean isModified = false;
    protected Date createdDate;
    private BaseEntityType entityType = null;
    boolean displayOrdersUpToDate = false;
    private transient Object TEMPLATE_STRUCTURE_LOCK = new Object();
    protected final Set templateTypes = new HashSet();
    protected final Set templateFields = new HashSet();
    protected final Set linkedTypes = new HashSet();
    protected final Set linkedFields = new HashSet();
    protected BaseEntityField[] thumbFields = null;
    protected BaseEntityField[] sortFields = null;
    protected transient boolean isNewTemplate = false;

    protected BaseTemplate(int n, String string) {
        this.templateID = n;
        this.templateName = string;
    }

    public int getTemplateID() {
        return this.templateID;
    }

    public void setTemplateID(int n) {
        this.templateID = n;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String string) {
        this.templateName = string;
    }

    public boolean isNewTemplate() {
        return this.isNewTemplate;
    }

    public void setNewTemplate(boolean bl) {
        this.isNewTemplate = bl;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean bl) {
        this.isModified = bl;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersionInfo() {
        return this.versionInfo == null ? "" : this.versionInfo;
    }

    public void setVersionInfo(String string) {
        this.versionInfo = string;
    }

    public String getDescriptionURL() {
        return this.descriptionURL == null ? "" : this.descriptionURL;
    }

    public void setDescriptionURL(String string) {
        this.descriptionURL = string;
    }

    public int getCreatorID() {
        return this.creatorID;
    }

    public void setCreatorID(int n) {
        this.creatorID = n;
    }

    public boolean isPublished() {
        return this.isPublished;
    }

    public void setPublished(boolean bl) {
        this.isPublished = bl;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date date) {
        this.createdDate = date;
    }

    public boolean isTemporary() {
        return this.templateID == -1;
    }

    public void setPersonalCollectionTemplate(boolean bl) {
        this.isPersonalCollectionTemplate = bl;
    }

    public boolean isPersonalCollectionTemplate() {
        return this.isPersonalCollectionTemplate;
    }

    public final BaseEntityType getPrimaryEntityType() {
        return this.entityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setPrimaryEntityType(BaseEntityType baseEntityType) {
        if (this.entityType != null) {
            return 2;
        }
        if (baseEntityType == null || baseEntityType.template != this || baseEntityType.isDependent()) {
            return 1;
        }
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            this.entityType = baseEntityType;
            this.linkedTypes.add(this.entityType);
            return 0;
        }
    }

    final Object getTemplateStructureLock() {
        return this.TEMPLATE_STRUCTURE_LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set getTemplateTypes() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            return this.templateTypes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set getTemplateFields() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            return this.templateFields;
        }
    }

    public final void calculateDisplayOrders() {
        if (!this.displayOrdersUpToDate) {
            this.entityType.calculateDisplayOrders(0);
            this.displayOrdersUpToDate = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set getLinkedTypes() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            return this.linkedTypes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set getLinkedFields() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            return this.linkedFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLinkedFieldList() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            if (!this.displayOrdersUpToDate) {
                this.calculateDisplayOrders();
            }
            ArrayList arrayList = new ArrayList();
            this.getLinkedFieldList(arrayList, this.entityType);
            return Collections.unmodifiableList(arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getLinkedElementList() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            ArrayList arrayList = new ArrayList();
            this.getLinkedEntityList(arrayList, this.entityType);
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    BaseTemplateElement baseTemplateElement = (BaseTemplateElement)object;
                    BaseTemplateElement baseTemplateElement2 = (BaseTemplateElement)object2;
                    return baseTemplateElement.getDisplayOrder() - baseTemplateElement2.getDisplayOrder();
                }

                public boolean equals(Object object) {
                    return object.hashCode() == this.hashCode();
                }
            });
            return Collections.unmodifiableList(arrayList);
        }
    }

    private void getLinkedFieldList(List list, BaseEntityType baseEntityType) {
        Iterator iterator = baseEntityType.getElements().iterator();
        while (iterator.hasNext()) {
            BaseTemplateElement baseTemplateElement = (BaseTemplateElement)iterator.next();
            if (baseTemplateElement instanceof BaseEntityField) {
                list.add(baseTemplateElement);
                continue;
            }
            this.getLinkedFieldList(list, (BaseEntityType)baseTemplateElement);
        }
    }

    private void getLinkedEntityList(List list, BaseEntityType baseEntityType) {
        Iterator iterator = baseEntityType.getElements().iterator();
        while (iterator.hasNext()) {
            BaseTemplateElement baseTemplateElement = (BaseTemplateElement)iterator.next();
            list.add(baseTemplateElement);
            if (!(baseTemplateElement instanceof BaseEntityType)) continue;
            this.getLinkedEntityList(list, (BaseEntityType)baseTemplateElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set getLinkedElements() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            HashSet hashSet = new HashSet(this.linkedTypes);
            hashSet.addAll(this.linkedFields);
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeElement(BaseTemplateElement baseTemplateElement) {
        if (!baseTemplateElement.template.getClass().equals(this.getClass())) {
            return false;
        }
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            if (baseTemplateElement instanceof BaseEntityType && (((BaseEntityType)baseTemplateElement).isPrimaryType() || ((BaseEntityType)baseTemplateElement).getSize() > 0)) {
                return false;
            }
            boolean bl = false;
            if (baseTemplateElement.parentType != null) {
                bl = true;
                baseTemplateElement.parentType.removeElement(baseTemplateElement);
            }
            if (baseTemplateElement instanceof BaseEntityType) {
                if (bl) {
                    this.linkedTypes.remove(baseTemplateElement);
                }
                this.templateTypes.remove(baseTemplateElement);
            } else if (baseTemplateElement instanceof BaseEntityField) {
                if (bl) {
                    int n;
                    this.linkedFields.remove(baseTemplateElement);
                    if (this.thumbFields != null) {
                        for (n = 0; n < this.thumbFields.length; ++n) {
                            if (this.thumbFields[n] == null || !this.thumbFields[n].equals(baseTemplateElement)) continue;
                            this.thumbFields[n] = null;
                        }
                    }
                    if (this.sortFields != null) {
                        for (n = 0; n < this.sortFields.length; ++n) {
                            if (this.sortFields[n] == null || !this.sortFields[n].equals(baseTemplateElement)) continue;
                            this.sortFields[n] = null;
                        }
                    }
                }
                this.templateFields.remove(baseTemplateElement);
            }
            return true;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.TEMPLATE_STRUCTURE_LOCK = new Object();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TEMPLATE (" + this.templateName + ")");
        if (this.entityType != null) {
            stringBuffer.append("\n" + this.entityType);
        } else {
            stringBuffer.append("\n*** NO ENTITY TYPES ***\n");
        }
        return stringBuffer.append("END TEMPLATE (" + this.templateName + ")\n").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getThumbnailOptionEntityFields() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            HashSet<BaseEntityField> hashSet = new HashSet<BaseEntityField>();
            Iterator iterator = this.linkedFields.iterator();
            while (iterator.hasNext()) {
                BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
                if (!baseEntityField.isThumbnailOption()) continue;
                hashSet.add(baseEntityField);
            }
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getSortOptionEntityFields() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            HashSet<BaseEntityField> hashSet = new HashSet<BaseEntityField>();
            Iterator iterator = this.linkedFields.iterator();
            while (iterator.hasNext()) {
                BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
                if (!baseEntityField.isSortOption()) continue;
                hashSet.add(baseEntityField);
            }
            return hashSet;
        }
    }

    public BaseEntityField getEntityFieldByName(String string) {
        Iterator iterator = this.templateFields.iterator();
        while (iterator.hasNext()) {
            BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
            if (!baseEntityField.getName().equals(string)) continue;
            return baseEntityField;
        }
        return null;
    }

    public BaseEntityField getEntityFieldByDisplayName(String string) {
        Iterator iterator = this.templateFields.iterator();
        while (iterator.hasNext()) {
            BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
            if (!baseEntityField.getDisplayName().equals(string)) continue;
            return baseEntityField;
        }
        return null;
    }

    public BaseEntityType getEntityTypeByName(String string) {
        Iterator iterator = this.templateTypes.iterator();
        while (iterator.hasNext()) {
            BaseEntityType baseEntityType = (BaseEntityType)iterator.next();
            if (!baseEntityType.getName().equals(string)) continue;
            return baseEntityType;
        }
        return null;
    }

    public BaseEntityType getEntityTypeByDisplayName(String string) {
        Iterator iterator = this.templateTypes.iterator();
        while (iterator.hasNext()) {
            BaseEntityType baseEntityType = (BaseEntityType)iterator.next();
            if (!baseEntityType.getDisplayName().equals(string)) continue;
            return baseEntityType;
        }
        return null;
    }

    public BaseEntityType getEntityTypeByID(int n) {
        Iterator iterator = this.templateTypes.iterator();
        while (iterator.hasNext()) {
            BaseEntityType baseEntityType = (BaseEntityType)iterator.next();
            if (baseEntityType.getID() != n) continue;
            return baseEntityType;
        }
        return null;
    }

    public BaseEntityField getLinkedEntityFieldByName(String string) {
        Iterator iterator = this.linkedFields.iterator();
        while (iterator.hasNext()) {
            BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
            if (!baseEntityField.getName().equals(string)) continue;
            return baseEntityField;
        }
        return null;
    }

    public BaseEntityField getLinkedEntityFieldByDisplayName(String string) {
        Iterator iterator = this.linkedFields.iterator();
        while (iterator.hasNext()) {
            BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
            if (!baseEntityField.getDisplayName().equals(string)) continue;
            return baseEntityField;
        }
        return null;
    }

    public BaseEntityField getEntityFieldByID(int n) {
        Iterator iterator = this.linkedFields.iterator();
        while (iterator.hasNext()) {
            BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
            if (baseEntityField.getID() != n) continue;
            return baseEntityField;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseEntityField[] getThumbnailFields() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            if (this.thumbFields != null) {
                return this.thumbFields;
            }
            return this.getDefaultFields(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseEntityField[] getSortFields() {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            if (this.sortFields != null) {
                return this.sortFields;
            }
            return this.getDefaultFields(false);
        }
    }

    private BaseEntityField[] getDefaultFields(boolean bl) {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((BaseEntityField)object).getDisplayName().compareTo(((BaseEntityField)object2).getDisplayName());
            }
        };
        TreeSet treeSet = new TreeSet(comparator);
        treeSet.addAll(this.linkedFields);
        BaseEntityField[] baseEntityFieldArray = new BaseEntityField[4];
        int n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext() && n < baseEntityFieldArray.length) {
            BaseEntityField baseEntityField = (BaseEntityField)iterator.next();
            if ((!bl || !baseEntityField.isThumbnailOption()) && (bl || !baseEntityField.isSortOption())) continue;
            baseEntityFieldArray[n++] = baseEntityField;
        }
        return baseEntityFieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setThumbnailFields(BaseEntityField[] baseEntityFieldArray) throws IllegalArgumentException {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            int n;
            if (baseEntityFieldArray == null) {
                this.thumbFields = null;
            }
            if (baseEntityFieldArray.length != 4) {
                throw new IllegalArgumentException("fields argument must be 4 elements long");
            }
            for (n = 0; n < baseEntityFieldArray.length; ++n) {
                if (baseEntityFieldArray[n] == null) continue;
                if (!baseEntityFieldArray[n].isThumbnailOption()) {
                    throw new IllegalArgumentException("fields[" + n + "] not thumbnail option.");
                }
                if (this.linkedFields.contains(baseEntityFieldArray[n])) continue;
                throw new IllegalArgumentException("fields[" + n + "] not a linked field in this template");
            }
            this.thumbFields = new BaseEntityField[4];
            for (n = 0; n < baseEntityFieldArray.length; ++n) {
                this.thumbFields[n] = baseEntityFieldArray[n];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSortFields(BaseEntityField[] baseEntityFieldArray) throws IllegalArgumentException {
        Object object = this.TEMPLATE_STRUCTURE_LOCK;
        synchronized (object) {
            int n;
            if (baseEntityFieldArray == null) {
                this.sortFields = null;
            }
            if (baseEntityFieldArray.length != 4) {
                throw new IllegalArgumentException("fields argument must be 4 elements long");
            }
            Object[] objectArray = this.linkedFields.toArray();
            for (n = 0; n < baseEntityFieldArray.length; ++n) {
                if (baseEntityFieldArray[n] == null) continue;
                if (!baseEntityFieldArray[n].isSortOption()) {
                    throw new IllegalArgumentException("fields[" + n + "] not sort option.");
                }
                if (this.linkedFields.contains(baseEntityFieldArray[n])) continue;
                throw new IllegalArgumentException("fields[" + n + "] not a linked field in this template");
            }
            this.sortFields = new BaseEntityField[4];
            for (n = 0; n < baseEntityFieldArray.length; ++n) {
                this.sortFields[n] = baseEntityFieldArray[n];
            }
        }
    }

    public List getChangedValues(ITemplate iTemplate, boolean bl) throws TemplateCompareException {
        BaseTemplateElement baseTemplateElement;
        ArrayList<BaseTemplateEdit> arrayList = new ArrayList<BaseTemplateEdit>();
        if (iTemplate == null || iTemplate.getClass().hashCode() != this.getClass().hashCode() || iTemplate.getTemplateID() != this.getTemplateID()) {
            throw new TemplateCompareException("invalid source object");
        }
        BaseTemplate baseTemplate = (BaseTemplate)iTemplate;
        BaseTemplateEdit baseTemplateEdit = new CatalogEdit(9, baseTemplate, this);
        BaseEntityType baseEntityType = baseTemplate.getPrimaryEntityType();
        BaseEntityType baseEntityType2 = this.entityType;
        EntityTypeEdit entityTypeEdit = new EntityTypeEdit(8, baseEntityType, baseEntityType2);
        if (!CoreUtilities.isEqual(baseEntityType2.getName(), baseEntityType.getName())) {
            entityTypeEdit.addChange(2, baseEntityType2.getName());
        }
        if (!CoreUtilities.isEqual(baseEntityType2.getDisplayName(), baseEntityType.getDisplayName())) {
            entityTypeEdit.addChange(1, baseEntityType2.getDisplayName());
        }
        if (baseEntityType2.getFieldGroupType() != baseEntityType.getFieldGroupType()) {
            entityTypeEdit.addChange(201, baseEntityType2.getFieldGroupType());
        }
        if (entityTypeEdit.getPropertyChanges() != null) {
            arrayList.add(entityTypeEdit);
        }
        if (!CoreUtilities.isEqual(this.templateName, baseTemplate.templateName)) {
            baseTemplateEdit.addChange(1, this.templateName);
        }
        if (!CoreUtilities.isEqual(this.version, baseTemplate.version)) {
            baseTemplateEdit.addChange(3, this.version);
        }
        if (!CoreUtilities.isEqual(this.versionInfo, baseTemplate.versionInfo)) {
            baseTemplateEdit.addChange(4, this.versionInfo);
        }
        if (!CoreUtilities.isEqual(this.descriptionURL, baseTemplate.descriptionURL)) {
            baseTemplateEdit.addChange(8, this.descriptionURL);
        }
        if (this.isPublished != baseTemplate.isPublished) {
            baseTemplateEdit.addChange(5, this.isPublished);
        }
        if (this.isPersonalCollectionTemplate != baseTemplate.isPersonalCollectionTemplate) {
            baseTemplateEdit.addChange(6, this.isPersonalCollectionTemplate);
        }
        if (this.creatorID != baseTemplate.creatorID) {
            baseTemplateEdit.addChange(7, this.creatorID);
        }
        if (baseTemplateEdit.getPropertyChanges() != null) {
            arrayList.add(baseTemplateEdit);
        }
        ArrayList arrayList2 = new ArrayList(this.getLinkedElementList());
        ArrayList arrayList3 = new ArrayList(baseTemplate.getLinkedElementList());
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            baseTemplateElement = (BaseTemplateElement)iterator.next();
            if (baseTemplateElement.getID() == -1) {
                baseTemplateEdit = baseTemplateElement instanceof BaseEntityField ? new EntityFieldEdit(4, null, (BaseEntityField)baseTemplateElement) : new EntityTypeEdit(3, null, (BaseEntityType)baseTemplateElement);
                arrayList.add(baseTemplateEdit);
                continue;
            }
            BaseTemplateElement baseTemplateElement2 = null;
            baseTemplateElement2 = baseTemplateElement instanceof BaseEntityField ? baseTemplate.getEntityFieldByID(baseTemplateElement.getID()) : baseTemplate.getEntityTypeByID(baseTemplateElement.getID());
            arrayList.addAll(baseTemplateElement.getChangedValues(this, baseTemplate, bl, baseTemplateElement2));
            arrayList3.remove(baseTemplateElement2);
        }
        iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            baseTemplateElement = (BaseTemplateElement)iterator.next();
            baseTemplateEdit = baseTemplateElement instanceof BaseEntityField ? new EntityFieldEdit(1, null, (BaseEntityField)baseTemplateElement) : new EntityTypeEdit(2, null, (BaseEntityType)baseTemplateElement);
            arrayList.add(baseTemplateEdit);
        }
        arrayList2.clear();
        arrayList3.clear();
        return arrayList;
    }
}

