/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog.edit;

import com.luna.insight.core.catalog.iface.ITemplateEdit;
import com.luna.insight.core.util.IntegerRange;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseTemplateEdit
implements ITemplateEdit {
    protected int changeType;
    protected List propertyChangeList;
    protected Object sourceObject;
    protected Object targetObject;

    protected BaseTemplateEdit(int n, Object object, Object object2) {
        this.changeType = n;
        this.propertyChangeList = null;
        this.sourceObject = object;
        this.targetObject = object2;
    }

    public List getPropertyChanges() {
        return this.propertyChangeList;
    }

    public int getChangeType() {
        return this.changeType;
    }

    protected void addChange(ITemplateEdit.ITemplatePropertyChange iTemplatePropertyChange) {
        if (this.propertyChangeList == null) {
            this.propertyChangeList = new ArrayList();
        }
        this.propertyChangeList.add(iTemplatePropertyChange);
    }

    public void addChange(int n, int n2) {
        this.addChange(new BaseEditProperty(n, n2));
    }

    public void addChange(int n, String string) {
        this.addChange(new BaseEditProperty(n, string));
    }

    public void addChange(int n, boolean bl) {
        this.addChange(new BaseEditProperty(n, bl));
    }

    public void addChange(int n, IntegerRange integerRange) {
        this.addChange(new BaseEditProperty(n, integerRange));
    }

    protected void finalize() {
        if (this.propertyChangeList != null) {
            this.propertyChangeList.clear();
            this.propertyChangeList = null;
        }
        this.sourceObject = null;
        this.targetObject = null;
    }

    private class BaseEditProperty
    implements ITemplateEdit.ITemplatePropertyChange {
        private int propertyID;
        private IntegerRange rangeValue;
        private String stringValue;
        private boolean booleanValue;
        private int intValue;

        private BaseEditProperty(int n, int n2) {
            this.propertyID = n;
            this.intValue = n2;
        }

        private BaseEditProperty(int n, boolean bl) {
            this.propertyID = n;
            this.booleanValue = bl;
        }

        private BaseEditProperty(int n, String string) {
            this.propertyID = n;
            this.stringValue = string;
        }

        private BaseEditProperty(int n, IntegerRange integerRange) {
            this.propertyID = n;
            this.rangeValue = integerRange;
        }

        public int getPropertyID() {
            return this.propertyID;
        }

        public boolean getBooleanValue() {
            return this.booleanValue;
        }

        public int getBooleanAsIntValue() {
            return this.booleanValue ? 1 : 0;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public IntegerRange getIntegerRange() {
            return this.rangeValue;
        }
    }
}

