/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog;

import com.luna.insight.core.catalog.CatalogTemplate;
import com.luna.insight.core.catalog.TemplateEntityField;
import com.luna.insight.core.catalog.iface.BaseEntityType;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.BaseTemplateElement;
import com.luna.insight.core.catalog.iface.IEntityField;
import com.luna.insight.core.catalog.iface.IEntityType;
import com.luna.insight.core.catalog.iface.ImportExportConsts;
import com.luna.insight.core.util.XMLWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

public class TemplateEntityType
extends BaseEntityType
implements Serializable,
ImportExportConsts {
    private boolean nameFromDisplayName = false;

    static IEntityType createInstance(CatalogTemplate catalogTemplate, HashMap hashMap) {
        TemplateEntityType templateEntityType = TemplateEntityType.createTemplateEntityType(catalogTemplate, -1, (String)hashMap.get("name"), (String)hashMap.get("display_name"));
        templateEntityType.updateProperties(hashMap);
        return templateEntityType;
    }

    private TemplateEntityType(CatalogTemplate catalogTemplate, int n, String string, String string2) {
        super(catalogTemplate, n, string, string2);
    }

    public static TemplateEntityType createTemplateEntityType(CatalogTemplate catalogTemplate, String string, String string2) {
        return TemplateEntityType.createTemplateEntityType(catalogTemplate, -1, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateEntityType createTemplateEntityType(CatalogTemplate catalogTemplate, int n, String string, String string2) {
        if (catalogTemplate == null || string == null || string.equals("") || string2 == null || string2.equals("")) {
            return null;
        }
        TemplateEntityType templateEntityType = new TemplateEntityType(catalogTemplate, n, string, string2);
        templateEntityType.nameFromDisplayName = true;
        Object object = templateEntityType.getTemplateStructureLock();
        synchronized (object) {
            if (templateEntityType.getTemplateTypes().contains(templateEntityType)) {
                return null;
            }
            templateEntityType.getTemplateTypes().add(templateEntityType);
            return templateEntityType;
        }
    }

    public static TemplateEntityType createTemplateEntityType(CatalogTemplate catalogTemplate, String string) {
        String string2 = TemplateEntityType.calculateNameFromDisplayName(string);
        TemplateEntityType templateEntityType = TemplateEntityType.createTemplateEntityType(catalogTemplate, -1, string2, string);
        if (templateEntityType != null) {
            templateEntityType.nameFromDisplayName = true;
            return templateEntityType;
        }
        return null;
    }

    private static String calculateNameFromDisplayName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (-1 != (n = stringBuffer.indexOf(" ", n))) {
            stringBuffer.setCharAt(n, '_');
        }
        return stringBuffer.toString();
    }

    public boolean setDisplayName(String string) {
        if (string.trim().equals(this.name)) {
            return true;
        }
        if (this.nameFromDisplayName) {
            String string2 = TemplateEntityType.calculateNameFromDisplayName(string);
            if (this.template.getEntityTypeByName(string2) == null && super.setDisplayName(string)) {
                this.template.getTemplateTypes().remove(this);
                this.template.getLinkedTypes().remove(this);
                this.name = string2;
                this.template.getTemplateTypes().add(this);
                this.template.getLinkedTypes().add(this);
                return true;
            }
            return false;
        }
        return super.setDisplayName(string);
    }

    public BaseTemplateElement copyInto(BaseTemplate baseTemplate, boolean bl) {
        return this.copyInto(baseTemplate, null, bl);
    }

    private BaseTemplateElement copyInto(BaseTemplate baseTemplate, TemplateEntityType templateEntityType, boolean bl) {
        try {
            TemplateEntityType templateEntityType2;
            CatalogTemplate catalogTemplate = (CatalogTemplate)baseTemplate;
            TemplateEntityType templateEntityType3 = templateEntityType2 = bl ? TemplateEntityType.createTemplateEntityType(catalogTemplate, this.getName(), this.getDisplayName()) : TemplateEntityType.createTemplateEntityType(catalogTemplate, this.getDisplayName());
            if (templateEntityType2 == null) {
                return null;
            }
            if (templateEntityType == null && this.isPrimaryType()) {
                if (catalogTemplate.setPrimaryEntityType(templateEntityType2) != 0) {
                    return null;
                }
            } else if (templateEntityType != null) {
                templateEntityType2.setParentEntityType(templateEntityType);
            }
            Iterator iterator = this.getElements().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof TemplateEntityType ? ((TemplateEntityType)e).copyInto(baseTemplate, templateEntityType2, bl) == null : e instanceof TemplateEntityField && ((TemplateEntityField)e).copyInto(baseTemplate, templateEntityType2, bl) == null)) continue;
                return null;
            }
            templateEntityType2.setUnvalidatedAttribute(0, new Boolean(this.isDependent()));
            templateEntityType2.setDupeCheckEnabled(this.isDupeCheckEnabled());
            templateEntityType2.setFieldGroupType(this.getFieldGroupType());
            templateEntityType2.setRefCheckEnabled(this.isRefCheckEnabled());
            templateEntityType2.setRestrictionLevel(this.getRestrictionLevel());
            templateEntityType2.setUnvalidatedAttribute(1, new Boolean(this.isVocabulary()));
            return templateEntityType2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public XMLWriter toXML(XMLWriter xMLWriter, String string) throws IOException {
        xMLWriter.appendElement("entity", new String[]{"id"}, new String[]{string}, null, false);
        xMLWriter.appendAndCloseElement("name", this.getName());
        xMLWriter.appendAndCloseElement("display_name", this.getDisplayName());
        xMLWriter.appendAndCloseElement("display_order", this.getDisplayOrder());
        xMLWriter.appendAndCloseElement("is_dependent", this.isDependent());
        xMLWriter.appendAndCloseElement("is_dupcheck_enabled", this.isDupeCheckEnabled());
        xMLWriter.appendAndCloseElement("is_primary", this.isPrimaryType());
        xMLWriter.appendAndCloseElement("field_group_type", TemplateEntityType.getGroupTypeEnumString(this.getFieldGroupType()));
        xMLWriter.appendAndCloseElement("restriction_level", this.getRestrictionLevel());
        xMLWriter.appendAndCloseElement("is_vocabulary", this.isVocabulary());
        xMLWriter.appendAndCloseElement("is_refcheck_enabled", this.isRefCheckEnabled());
        xMLWriter.appendAndCloseElement("table_id", this.getTableID());
        xMLWriter.appendAndCloseElement("entity_id_column_name", this.getEntityIDColumnName());
        xMLWriter.appendElement("elements");
        Iterator iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            String string2;
            Object e = iterator.next();
            if (e instanceof IEntityField) {
                string2 = "f" + e.hashCode();
                xMLWriter.appendAndCloseElement("field", new String[]{"ref"}, new String[]{string2});
                continue;
            }
            string2 = "e" + e.hashCode();
            xMLWriter.appendAndCloseElement("entity", new String[]{"ref"}, new String[]{string2});
        }
        xMLWriter.closeElement("elements");
        xMLWriter.closeElement("entity");
        return xMLWriter;
    }

    protected static String getGroupTypeEnumString(int n) {
        switch (n) {
            case 1: {
                return "GROUP_TYPE_SINGLE";
            }
            case 2: {
                return "GROUP_TYPE_FIELDS";
            }
            case 3: {
                return "GROUP_TYPE_GROUPS";
            }
            case 4: {
                return "GROUP_TYPE_FIELDS_AND_GROUPS";
            }
        }
        return "GROUP_TYPE_SINGLE";
    }

    protected static int getGroupTypeEnum(String string) {
        if (string.equals("GROUP_TYPE_SINGLE")) {
            return 1;
        }
        if (string.equals("GROUP_TYPE_FIELDS")) {
            return 2;
        }
        if (string.equals("GROUP_TYPE_GROUPS")) {
            return 3;
        }
        if (string.equals("GROUP_TYPE_FIELDS_AND_GROUPS")) {
            return 4;
        }
        return 1;
    }

    protected void updateProperties(HashMap hashMap) {
        this.setEntityIDColumnName((String)hashMap.get("entity_id_column_name"));
        this.setFieldGroupType(TemplateEntityType.getGroupTypeEnum((String)hashMap.get("field_group_type")));
        this.setRestrictionLevel(Integer.parseInt((String)hashMap.get("restriction_level")));
        this.setDisplayOrder(Integer.parseInt((String)hashMap.get("display_order")));
        this.setTableID(Integer.parseInt((String)hashMap.get("table_id")));
        this.setDependentImport(new Boolean((String)hashMap.get("is_dependent")));
        this.setDupeCheckEnabled(new Boolean((String)hashMap.get("is_dupcheck_enabled")));
        this.setVocabulary(new Boolean((String)hashMap.get("is_vocabulary")));
        this.setRefCheckEnabled(new Boolean((String)hashMap.get("is_refcheck_enabled")));
    }
}

