/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog;

import com.luna.insight.core.catalog.CatalogTemplate;
import com.luna.insight.core.catalog.TemplateEntityType;
import com.luna.insight.core.catalog.iface.BaseEntityField;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.BaseTemplateElement;
import com.luna.insight.core.catalog.iface.IEntityField;
import com.luna.insight.core.catalog.iface.IFieldProfile;
import com.luna.insight.core.catalog.iface.ImportExportConsts;
import com.luna.insight.core.util.XMLWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TemplateEntityField
extends BaseEntityField
implements Serializable,
ImportExportConsts {
    private boolean nameFromDisplayName = false;

    static IEntityField createInstance(CatalogTemplate catalogTemplate, HashMap hashMap, Map map) {
        TemplateEntityField templateEntityField = TemplateEntityField.createTemplateEntityField(catalogTemplate, SHORT_TEXT, -1, (String)hashMap.get("name"), (String)hashMap.get("display_name"));
        templateEntityField.updateProperties(hashMap, map);
        return templateEntityField;
    }

    private TemplateEntityField(CatalogTemplate catalogTemplate, IFieldProfile iFieldProfile, int n, String string, String string2) {
        super(catalogTemplate, n, iFieldProfile, string, string2);
    }

    public static TemplateEntityField createTemplateEntityField(CatalogTemplate catalogTemplate, IFieldProfile iFieldProfile, String string, String string2) {
        return TemplateEntityField.createTemplateEntityField(catalogTemplate, iFieldProfile, -1, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TemplateEntityField createTemplateEntityField(CatalogTemplate catalogTemplate, IFieldProfile iFieldProfile, int n, String string, String string2) {
        if (catalogTemplate == null || string == null || string.equals("") || string2 == null || string2.equals("")) {
            return null;
        }
        TemplateEntityField templateEntityField = new TemplateEntityField(catalogTemplate, iFieldProfile, n, string, string2);
        Object object = templateEntityField.getTemplateStructureLock();
        synchronized (object) {
            if (templateEntityField.getTemplateFields().contains(templateEntityField)) {
                return null;
            }
            templateEntityField.getTemplateFields().add(templateEntityField);
            return templateEntityField;
        }
    }

    public static TemplateEntityField createTemplateEntityfield(CatalogTemplate catalogTemplate, IFieldProfile iFieldProfile, String string) {
        String string2 = TemplateEntityField.calculateNameFromDisplayName(string);
        TemplateEntityField templateEntityField = TemplateEntityField.createTemplateEntityField(catalogTemplate, iFieldProfile, -1, string2, string);
        if (templateEntityField != null) {
            templateEntityField.nameFromDisplayName = true;
            return templateEntityField;
        }
        return null;
    }

    private static String calculateNameFromDisplayName(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (-1 != (n = stringBuffer.indexOf(" ", n))) {
            stringBuffer.setCharAt(n, '_');
        }
        return stringBuffer.toString();
    }

    public boolean setDisplayName(String string) {
        if (this.nameFromDisplayName) {
            String string2 = TemplateEntityField.calculateNameFromDisplayName(string);
            if (this.template.getEntityFieldByName(string2) == null && super.setDisplayName(string)) {
                this.template.getTemplateFields().remove(this);
                this.template.getLinkedFields().remove(this);
                this.name = string2;
                this.template.getTemplateFields().add(this);
                this.template.getLinkedFields().add(this);
                return true;
            }
            return false;
        }
        return super.setDisplayName(string);
    }

    public BaseTemplateElement copyInto(BaseTemplate baseTemplate, boolean bl) {
        return this.copyInto(baseTemplate, null, bl);
    }

    public BaseTemplateElement copyInto(BaseTemplate baseTemplate, TemplateEntityType templateEntityType, boolean bl) {
        TemplateEntityField templateEntityField;
        CatalogTemplate catalogTemplate = (CatalogTemplate)baseTemplate;
        TemplateEntityField templateEntityField2 = templateEntityField = bl ? TemplateEntityField.createTemplateEntityField(catalogTemplate, this.getFieldProfile(), this.getName(), this.getDisplayName()) : TemplateEntityField.createTemplateEntityfield(catalogTemplate, this.getFieldProfile(), this.getDisplayName());
        if (templateEntityField == null) {
            return null;
        }
        if (templateEntityType != null && templateEntityField.setParentEntityType(templateEntityType) != 0) {
            return null;
        }
        templateEntityField.setAllowRepeatingValues(this.isAllowRepeatingValues());
        templateEntityField.setDataDisplayType(this.getDataDisplayType());
        templateEntityField.setDataFieldSearchable(this.isDataFieldSearchable());
        templateEntityField.setDelimiterType(this.getDelimiterType());
        templateEntityField.setDescriptionUrl(this.getDescriptionUrl());
        templateEntityField.setDisplayedInData(this.isDisplayedInData());
        templateEntityField.setDisplayInRelatedEntities(this.isDisplayInRelatedEntities());
        templateEntityField.setFieldType(this.getFieldType());
        templateEntityField.setFuzzyDate(this.isFuzzyDate());
        templateEntityField.setHierarchy(this.getHierarchy());
        templateEntityField.setHierarchyMode(this.getHierarchyMode());
        templateEntityField.setIntegerRange(this.getIntegerRange());
        templateEntityField.setKeywordSearchable(this.isKeywordSearchable());
        templateEntityField.setMaxValueLength(this.getMaxValueLength());
        templateEntityField.setMinApprovalToAddValue(this.getMinApprovalToAddValue());
        templateEntityField.setPickable(this.isPickable());
        templateEntityField.setRequired(this.isRequired());
        templateEntityField.setReadOnly(this.isReadOnly());
        templateEntityField.setRestrictionLevel(this.getRestrictionLevel());
        templateEntityField.setSelectListBehavior(this.getSelectListBehavior());
        templateEntityField.setSortOption(this.isSortOption());
        templateEntityField.setThumbnailOption(this.isThumbnailOption());
        templateEntityField.setUseUniqueValues(this.isUseUniqueValues());
        templateEntityField.setValueListAllowed(this.isValueListAllowed());
        templateEntityField.mappingFieldsMap = new HashMap(this.mappingFieldsMap);
        return templateEntityField;
    }

    public XMLWriter toXML(XMLWriter xMLWriter, String string) throws IOException {
        xMLWriter.appendElement("field", new String[]{"id"}, new String[]{string}, null, false);
        xMLWriter.appendAndCloseElement("name", this.getName());
        xMLWriter.appendAndCloseElement("display_name", this.getDisplayName());
        xMLWriter.appendAndCloseElement("display_order", this.getDisplayOrder());
        xMLWriter.appendAndCloseElement("description_url", this.getDescriptionUrl());
        xMLWriter.appendAndCloseElement("is_repeating", this.isAllowRepeatingValues());
        xMLWriter.appendAndCloseElement("display_type", TemplateEntityField.getDataDisplayTypeEnumString(this.getDataDisplayType()));
        xMLWriter.appendAndCloseElement("is_df_searchable", this.isDataFieldSearchable());
        xMLWriter.appendAndCloseElement("delimiter_type", TemplateEntityField.getDelimiterTypeEnumString(this.getDelimiterType()));
        xMLWriter.appendAndCloseElement("is_data_display", this.isDisplayedInData());
        xMLWriter.appendAndCloseElement("display_in_related", this.isDisplayInRelatedEntities());
        xMLWriter.appendAndCloseElement("field_type", this.getFieldType() == 2 ? "TYPE_INTEGER" : "TYPE_STRING");
        xMLWriter.appendAndCloseElement("is_fuzzy", this.isFuzzyDate());
        xMLWriter.appendAndCloseElement("hierarchy_name", this.getHierarchy());
        xMLWriter.appendAndCloseElement("hierarchy_type", TemplateEntityField.getHierarchyModeEnumString(this.getHierarchyMode()));
        if (this.getIntegerRange() != null) {
            xMLWriter.appendAndCloseElement("integer_range", new String[]{"min_value", "max_value"}, new String[]{"" + this.getIntegerRange().getMinValue(), "" + this.getIntegerRange().getMaxValue()});
        }
        xMLWriter.appendAndCloseElement("is_kw_searchable", this.isKeywordSearchable());
        xMLWriter.appendAndCloseElement("max_value_length", this.getMaxValueLength());
        xMLWriter.appendAndCloseElement("min_approval_level", this.getMinApprovalToAddValue());
        xMLWriter.appendAndCloseElement("is_pickable", this.isPickable());
        xMLWriter.appendAndCloseElement("is_required", this.isRequired());
        xMLWriter.appendAndCloseElement("is_read_only", this.isReadOnly());
        xMLWriter.appendAndCloseElement("restriction_level", this.getRestrictionLevel());
        xMLWriter.appendAndCloseElement("select_list_type", TemplateEntityField.getSelectListBehaviorEnumString(this.getSelectListBehavior()));
        xMLWriter.appendAndCloseElement("sort_option", this.isSortOption());
        xMLWriter.appendAndCloseElement("thumbnail_option", this.isThumbnailOption());
        xMLWriter.appendAndCloseElement("is_use_unique", this.isUseUniqueValues());
        xMLWriter.appendAndCloseElement("is_value_list", this.isValueListAllowed());
        int[] nArray = this.getStandardsWithMappings();
        for (int i = 0; i < nArray.length; ++i) {
            List list = this.getFieldMappings(nArray[i]);
            xMLWriter.appendElement("field_mappings");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                xMLWriter.appendAndCloseElement("standard_name", "CDWA");
                xMLWriter.appendAndCloseElement("field_name", iterator.next().toString());
            }
            xMLWriter.closeElement("field_mappings");
        }
        xMLWriter.closeElement("field");
        return xMLWriter;
    }

    protected static String getDataDisplayTypeEnumString(int n) {
        switch (n) {
            case 2: {
                return "NONEXPANDABLE_SHORT_STRING";
            }
            case 1: {
                return "LONG_STRING";
            }
            case 0: {
                return "EXPANDABLE_SHORT_STRING";
            }
        }
        return "NONEXPANDABLE_SHORT_STRING";
    }

    protected static int getDataDisplayTypeEnum(String string) {
        if (string.equals("NONEXPANDABLE_SHORT_STRING")) {
            return 2;
        }
        if (string.equals("LONG_STRING")) {
            return 1;
        }
        if (string.equals("EXPANDABLE_SHORT_STRING")) {
            return 0;
        }
        return 2;
    }

    protected static String getDelimiterTypeEnumString(int n) {
        switch (n) {
            case 4: {
                return "DELIMITER_TYPE_SEMI_COLON";
            }
            case 3: {
                return "DELIMITER_TYPE_COMMA";
            }
            case 1: {
                return "DELIMITER_TYPE_MULTI_FIELD_NAME";
            }
            case 2: {
                return "DELIMITER_TYPE_SINGLE_FIELD_NAME";
            }
        }
        return "DELIMITER_TYPE_COMMA";
    }

    protected static int getDelimiterTypeEnum(String string) {
        if (string.equals("DELIMITER_TYPE_SEMI_COLON")) {
            return 4;
        }
        if (string.equals("DELIMITER_TYPE_COMMA")) {
            return 3;
        }
        if (string.equals("DELIMITER_TYPE_MULTI_FIELD_NAME")) {
            return 1;
        }
        if (string.equals("DELIMITER_TYPE_SINGLE_FIELD_NAME")) {
            return 2;
        }
        return 3;
    }

    protected static String getHierarchyModeEnumString(int n) {
        switch (n) {
            case 3: {
                return "HIERARCHY_MODE_INSCRIBE_ONLY";
            }
            case 1: {
                return "HIERARCHY_MODE_CURRENT_ONLY";
            }
            case 2: {
                return "HIERARCHY_MODE_INCLUDE_CHILDREN";
            }
            case 0: {
                return "HIERARCHY_MODE_NONE";
            }
        }
        return "HIERARCHY_MODE_NONE";
    }

    protected static int getHierarchyModeEnum(String string) {
        if (string.equals("HIERARCHY_MODE_INSCRIBE_ONLY")) {
            return 3;
        }
        if (string.equals("HIERARCHY_MODE_CURRENT_ONLY")) {
            return 1;
        }
        if (string.equals("HIERARCHY_MODE_INCLUDE_CHILDREN")) {
            return 2;
        }
        if (string.equals("HIERARCHY_MODE_NONE")) {
            return 0;
        }
        return 0;
    }

    protected static String getSelectListBehaviorEnumString(int n) {
        switch (n) {
            case 1: {
                return "LIST_ALL";
            }
            case 2: {
                return "LIST_ALL_AUTO";
            }
            case 0: {
                return "NO_LIST_ALL";
            }
        }
        return "NO_LIST_ALL";
    }

    protected int getSelectListBehaviorEnum(String string) {
        if (string.equals("LIST_ALL")) {
            return 1;
        }
        if (string.equals("LIST_ALL_AUTO")) {
            return 2;
        }
        if (string.equals("NO_LIST_ALL")) {
            return 0;
        }
        return 0;
    }

    protected void updateProperties(HashMap hashMap, Map map) {
        this.setDescriptionUrl((String)hashMap.get("description_url"));
        this.setHierarchy((String)hashMap.get("hierarchy_name"));
        this.setDisplayOrder(Integer.parseInt((String)hashMap.get("display_order")));
        this.setRestrictionLevel(Integer.parseInt((String)hashMap.get("restriction_level")));
        this.setMaxValueLength(Integer.parseInt((String)hashMap.get("max_value_length")));
        this.setMinApprovalToAddValue(Integer.parseInt((String)hashMap.get("min_approval_level")));
        this.setDataDisplayType(TemplateEntityField.getDataDisplayTypeEnum((String)hashMap.get("display_type")));
        this.setDelimiterType(TemplateEntityField.getDelimiterTypeEnum((String)hashMap.get("delimiter_type")));
        this.setHierarchyMode(TemplateEntityField.getHierarchyModeEnum((String)hashMap.get("hierarchy_type")));
        this.setSelectListBehavior(this.getSelectListBehaviorEnum((String)hashMap.get("select_list_type")));
        this.setFieldType(hashMap.get("field_type").equals("TYPE_STRING") ? 1 : 2);
        this.setAllowRepeatingValues(new Boolean((String)hashMap.get("is_repeating")));
        this.setDataFieldSearchable(new Boolean((String)hashMap.get("is_df_searchable")));
        this.setDisplayedInData(new Boolean((String)hashMap.get("is_data_display")));
        this.setDisplayInRelatedEntities(new Boolean((String)hashMap.get("display_in_related")));
        this.setFuzzyDate(new Boolean((String)hashMap.get("is_fuzzy")));
        this.setKeywordSearchable(new Boolean((String)hashMap.get("is_kw_searchable")));
        this.setPickable(new Boolean((String)hashMap.get("is_pickable")));
        this.setRequired(new Boolean((String)hashMap.get("is_required")));
        this.setReadOnly(new Boolean((String)hashMap.get("is_read_only")));
        this.setSortOption(new Boolean((String)hashMap.get("sort_option")));
        this.setThumbnailOption(new Boolean((String)hashMap.get("thumbnail_option")));
        this.setUseUniqueValues(new Boolean((String)hashMap.get("is_use_unique")));
        this.setValueListAllowed(new Boolean((String)hashMap.get("is_value_list")));
        if (hashMap.get("field_name") != null) {
            List list = (List)hashMap.get("field_name");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                this.addFieldMapping(0, map.get(string));
            }
        }
    }
}

