/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.core.catalog;

import com.luna.insight.core.catalog.iface.BaseEntityField;
import com.luna.insight.core.catalog.iface.BaseTemplate;
import com.luna.insight.core.catalog.iface.BaseTemplateElement;
import com.luna.insight.core.catalog.iface.IEntityField;
import com.luna.insight.core.catalog.iface.ITemplateElement;
import com.luna.insight.core.catalog.iface.ImportExportConsts;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.core.util.XMLWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;

public class CatalogTemplate
extends BaseTemplate
implements Serializable,
ImportExportConsts {
    public CatalogTemplate(int n, String string) {
        super(n, string);
    }

    public CatalogTemplate(String string) {
        this(-1, string);
    }

    private CatalogTemplate(BaseTemplate baseTemplate, String string) {
        this(string);
        this.version = baseTemplate.getVersion();
        this.versionInfo = baseTemplate.getVersionInfo();
        this.descriptionURL = baseTemplate.getDescriptionURL();
        this.isPublished = baseTemplate.isPublished();
        this.isPersonalCollectionTemplate = baseTemplate.isPersonalCollectionTemplate();
    }

    public static CatalogTemplate createCatalogTemplate(String string) {
        return new CatalogTemplate(string);
    }

    public static CatalogTemplate createCatalogTemplate(BaseTemplate baseTemplate, String string, boolean bl) {
        CatalogTemplate catalogTemplate = new CatalogTemplate(string);
        return CatalogTemplate.updateTemplateProperties(catalogTemplate, baseTemplate, bl) ? catalogTemplate : null;
    }

    protected static boolean updateTemplateProperties(CatalogTemplate catalogTemplate, BaseTemplate baseTemplate, boolean bl) {
        catalogTemplate.setVersion(baseTemplate.getVersion());
        catalogTemplate.setVersionInfo(baseTemplate.getVersionInfo());
        catalogTemplate.setDescriptionURL(baseTemplate.getDescriptionURL());
        catalogTemplate.setPublished(baseTemplate.isPublished());
        catalogTemplate.setPersonalCollectionTemplate(baseTemplate.isPersonalCollectionTemplate());
        return baseTemplate.getPrimaryEntityType().copyInto(catalogTemplate, bl) != null;
    }

    public XMLWriter toXML(Writer writer) throws IOException {
        XMLWriter xMLWriter = new XMLWriter(writer, null, null, "");
        xMLWriter.appendHeader();
        xMLWriter.appendElement("p:template", new String[]{"xmlns:p", "xmlns:xsi", "xsi:schemaLocation"}, new String[]{"http://www.lunaimaging.com/xsd", "http://www.w3.org/2001/XMLSchema-instance", "http://www.lunaimaging.com/xsd http://www.lunaimaging.com/xsd/catalog-template-1.0.xsd"}, null, false);
        xMLWriter.appendAndCloseElement("name", this.getTemplateName());
        xMLWriter.appendAndCloseElement("version", this.getVersion());
        xMLWriter.appendAndCloseElement("version_info", this.getVersionInfo());
        xMLWriter.appendAndCloseElement("description_url", this.getDescriptionURL());
        xMLWriter.appendAndCloseElement("creator_id", this.getCreatorID());
        xMLWriter.appendAndCloseElement("is_published", this.isPublished());
        xMLWriter.appendAndCloseElement("is_pccollections", this.isPersonalCollectionTemplate());
        xMLWriter.appendAndCloseElement("creation_date", this.getCreatedDate() != null ? CoreUtilities.formatUTCDate(this.getCreatedDate().getTime()) : CoreUtilities.formatUTCDate(System.currentTimeMillis()));
        xMLWriter.appendAndCloseElement("primary", new String[]{"ref"}, new String[]{"e" + this.getPrimaryEntityType().hashCode()});
        this.writeFieldReferenceArray(xMLWriter, "thumb_fields", this.getThumbnailFields());
        this.writeFieldReferenceArray(xMLWriter, "sort_fields", this.getSortFields());
        this.writeTemplateElements(xMLWriter);
        xMLWriter.closeElement("p:template");
        return xMLWriter;
    }

    protected void writeFieldReferenceArray(XMLWriter xMLWriter, String string, BaseEntityField[] baseEntityFieldArray) {
        xMLWriter.appendElement(string);
        BaseTemplateElement baseTemplateElement = null;
        for (int i = 0; i < 4; ++i) {
            if (i <= 4 && baseEntityFieldArray[i] != null) {
                xMLWriter.appendAndCloseElement("field" + (i + 1), new String[]{"ref"}, new String[]{"f" + baseEntityFieldArray[i].hashCode()});
                baseTemplateElement = baseEntityFieldArray[i];
                continue;
            }
            if (baseTemplateElement != null) {
                xMLWriter.appendAndCloseElement("field" + (i + 1), new String[]{"ref"}, new String[]{"f" + baseTemplateElement.hashCode()});
                continue;
            }
            xMLWriter.appendAndCloseElement("field" + (i + 1), new String[]{"ref"}, new String[]{"<!-- error value substituted -->\n", "f00000000"});
        }
        xMLWriter.closeElement(string);
    }

    protected void writeTemplateElements(XMLWriter xMLWriter) throws IOException {
        Iterator iterator = this.getLinkedElementList().iterator();
        xMLWriter.appendElement("entities");
        ITemplateElement iTemplateElement = this.getPrimaryEntityType();
        if (iTemplateElement != null) {
            iTemplateElement.toXML(xMLWriter, "e" + iTemplateElement.hashCode());
        }
        while (iterator.hasNext()) {
            iTemplateElement = (ITemplateElement)iterator.next();
            String string = (iTemplateElement instanceof IEntityField ? "f" : "e") + iTemplateElement.hashCode();
            iTemplateElement.toXML(xMLWriter, string);
        }
        xMLWriter.closeElement("entities");
    }
}

