/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.client.media;

import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import quicktime.QTSession;
import quicktime.std.movies.Movie;
import quicktime.std.movies.media.DataRef;

public class MediaFileMetadata {
    public static final String[] AUDIO_FILE_EXTS;
    public static final String QUICKTIME_EXT = ".mov";
    public static final String FLASH_EXT = ".swf";
    public static final String[] VIDEO_FILE_EXTS;
    public static final String QTVR_FILE_EXT = ".mov";
    public static List NON_IMAGE_FILE_EXTS;
    protected String mediaFilepath;
    protected int mediaType = 1;
    protected int mediaFormat = 0;
    protected int mediaWidth = 0;
    protected int mediaHeight = 0;

    public static void main(String[] stringArray) {
        Debug.setDebugLevel(3);
        String string = "H:\\estate\\qtvr\\VR_Cave.mov";
        MediaFileMetadata.debugOut("isQtvrFile(" + string + "): " + MediaFileMetadata.isQtvrFile(string));
        string = "H:\\estate\\qtvr\\VR_StatueObj.mov";
        MediaFileMetadata.debugOut("isQtvrFile(" + string + "): " + MediaFileMetadata.isQtvrFile(string));
        string = "H:\\estate\\svq1\\SVQ1_Menace.mov";
        MediaFileMetadata.debugOut("isQtvrFile(" + string + "): " + MediaFileMetadata.isQtvrFile(string));
        string = "H:\\estate\\qtvr\\VR_GrandCentral.mov";
        MediaFileMetadata.debugOut("isQtvrFile(" + string + "): " + MediaFileMetadata.isQtvrFile(string));
    }

    public static void debugOut(String string) {
        MediaFileMetadata.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("MediaFileMetadata: " + string, n);
    }

    public static String getMediaTypeName(int n) {
        if (n == 2) {
            return "AUDIO";
        }
        if (n == 3) {
            return "VIDEO";
        }
        if (n == 4) {
            return "QTVR";
        }
        return "IMAGE";
    }

    public static boolean isAudioFile(String string) {
        boolean bl = false;
        for (int i = 0; string != null && i < AUDIO_FILE_EXTS.length; ++i) {
            if (!string.toLowerCase().endsWith(AUDIO_FILE_EXTS[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isVideoFile(String string) {
        boolean bl = false;
        for (int i = 0; string != null && i < VIDEO_FILE_EXTS.length; ++i) {
            if (!string.toLowerCase().endsWith(VIDEO_FILE_EXTS[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isQtvrFile(String string) {
        URL uRL;
        boolean bl = false;
        if (string != null && string.endsWith(".mov") && (uRL = InsightUtilities.getUrl(string)) != null) {
            try {
                QTSession.open();
                QTSession.initializeVR();
                MediaFileMetadata.debugOut("Using QuickTime version: " + QTSession.getQTMajorVersion() + "." + QTSession.getQTMinorVersion());
                String string2 = MediaFileMetadata.qtMassageUrl(uRL.toString());
                DataRef dataRef = new DataRef(string2);
                Movie movie = Movie.fromDataRef((DataRef)dataRef, (int)1);
                int n = movie.getTrackCount();
                for (int i = 1; i <= n; ++i) {
                    try {
                        if (movie.getQTVRTrack(i) == null) continue;
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                QTSession.close();
            }
            catch (Exception exception) {
                MediaFileMetadata.debugOut("Exeception in isQtvrFile() exc:\n" + InsightUtilities.getStackTrace(exception));
            }
            catch (Error error) {
                MediaFileMetadata.debugOut("Error in isQtvrFile() exc:\n" + InsightUtilities.getStackTrace(error));
            }
        }
        return bl;
    }

    protected static String qtMassageUrl(String string) {
        String string2 = string;
        if (string2.startsWith("file:") && string2.length() > 6) {
            String string3 = "/";
            string2 = string2.substring(0, 6) + string3 + string2.substring(6);
        }
        return string2;
    }

    public MediaFileMetadata(String string) {
        this.mediaFilepath = string == null ? "" : string.toLowerCase();
    }

    public void getMetadata() {
        if (MediaFileMetadata.isAudioFile(this.mediaFilepath)) {
            this.mediaType = 2;
            this.mediaFormat = 3;
        } else if (MediaFileMetadata.isVideoFile(this.mediaFilepath)) {
            this.mediaType = 3;
            this.mediaFormat = 7;
            if (MediaFileMetadata.isQtvrFile(this.mediaFilepath)) {
                this.mediaType = 4;
                this.mediaFormat = 12;
            }
        } else {
            this.mediaType = 1;
            this.mediaFormat = 0;
        }
    }

    public String getMediaTypeName() {
        return MediaFileMetadata.getMediaTypeName(this.getMediaType());
    }

    public String getFileFormatExtension() {
        if (this.mediaType == 2 && MediaFileMetadata.isAudioFile(this.mediaFilepath)) {
            return this.mediaFilepath.substring(this.mediaFilepath.lastIndexOf(46) + 1).toUpperCase();
        }
        if (this.mediaType == 3 && MediaFileMetadata.isVideoFile(this.mediaFilepath)) {
            return this.mediaFilepath.substring(this.mediaFilepath.lastIndexOf(46) + 1).toUpperCase();
        }
        if (this.mediaType == 4 && this.mediaFilepath.toLowerCase().endsWith(".mov")) {
            return this.mediaFilepath.substring(this.mediaFilepath.lastIndexOf(46) + 1).toUpperCase();
        }
        return "N/A";
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public int getMediaFormat() {
        return this.mediaFormat;
    }

    public int getMediaWidth() {
        return this.mediaWidth;
    }

    public int getMediaHeight() {
        return this.mediaHeight;
    }

    static {
        int n;
        AUDIO_FILE_EXTS = new String[]{".aiff", ".mp2", ".mp3", ".gsm", ".au", ".wav", ".mid"};
        VIDEO_FILE_EXTS = new String[]{".avi", ".mpg", ".mpeg", FLASH_EXT, ".spl", ".mvr", ".mov"};
        NON_IMAGE_FILE_EXTS = new Vector(AUDIO_FILE_EXTS.length + VIDEO_FILE_EXTS.length);
        for (n = 0; n < AUDIO_FILE_EXTS.length; ++n) {
            NON_IMAGE_FILE_EXTS.add(AUDIO_FILE_EXTS[n].toLowerCase());
        }
        for (n = 0; n < VIDEO_FILE_EXTS.length; ++n) {
            NON_IMAGE_FILE_EXTS.add(VIDEO_FILE_EXTS[n].toLowerCase());
        }
    }
}

