/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.verifier;

import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.verifier.AdminComponentVerifier;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class IntegerRangeJTextComponentVerifier
extends AdminComponentVerifier {
    private Integer min = null;
    private Integer max = null;
    private boolean allowEmpty = false;

    public IntegerRangeJTextComponentVerifier(Integer n, Integer n2) {
        this(n, n2, false);
    }

    public IntegerRangeJTextComponentVerifier(Integer n, Integer n2, boolean bl) {
        this.min = n;
        this.max = n2;
        this.allowEmpty = bl;
    }

    public boolean verify(JComponent jComponent) {
        if (this.acceptAll) {
            return true;
        }
        try {
            String string = ((JTextComponent)jComponent).getText();
            if (this.allowEmpty && (string == null || string.trim().equals(""))) {
                return true;
            }
            int n = Integer.parseInt(string);
            if (this.min != null && n < this.min) {
                return this.verifyFailed(jComponent);
            }
            if (this.max != null && n > this.max) {
                return this.verifyFailed(jComponent);
            }
            return true;
        }
        catch (Exception exception) {
            return this.verifyFailed(jComponent);
        }
    }

    private boolean verifyFailed(JComponent jComponent) {
        String string = this.min == null && this.max == null ? "This field must be given an integer value." : (this.min != null && this.max != null ? "This field must be given an integer value between " + this.min + " and " + this.max + "." : (this.min != null ? "This field must be given an integer value greater than or equal to " + this.min + "." : "This field must be given an integer value lesser than or equal to " + this.max + "."));
        InsightAdministrator.showWarningDialog(jComponent, string, "Form Validation Warning");
        return false;
    }
}

