/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.verifier;

import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.verifier.AdminComponentVerifier;
import com.luna.insight.admin.verifier.CustomVerificationChecker;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class CustomJComboBoxComponentVerifier
extends AdminComponentVerifier {
    public static final int NO_DATATYPE_CHECK = 0;
    public static final int ALLOW_INT_ONLY = 1;
    public static final int ALLOW_LONG_ONLY = 2;
    private boolean allowEmpty = false;
    private int dataTypeAllowed = 0;
    private CustomVerificationChecker customChecker = null;

    public CustomJComboBoxComponentVerifier(CustomVerificationChecker customVerificationChecker) {
        this(customVerificationChecker, 0, false);
    }

    public CustomJComboBoxComponentVerifier(CustomVerificationChecker customVerificationChecker, int n) {
        this(customVerificationChecker, n, false);
    }

    public CustomJComboBoxComponentVerifier(CustomVerificationChecker customVerificationChecker, int n, boolean bl) {
        this.customChecker = customVerificationChecker;
        this.dataTypeAllowed = n;
        this.allowEmpty = bl;
    }

    public boolean verify(JComponent jComponent) {
        if (this.acceptAll) {
            return true;
        }
        String string = (String)((JComboBox)jComponent).getSelectedItem();
        if (this.allowEmpty && (string == null || string.equals(""))) {
            return true;
        }
        switch (this.dataTypeAllowed) {
            case 1: {
                try {
                    int n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    InsightAdministrator.showWarningDialog(jComponent, "An integer value must be selected from this field.", "Form Validation Warning");
                    return false;
                }
            }
            case 2: {
                try {
                    long l = Long.parseLong(string);
                    break;
                }
                catch (Exception exception) {
                    InsightAdministrator.showWarningDialog(jComponent, "A long value must be selected from this field.", "Form Validation Warning");
                    return false;
                }
            }
        }
        boolean bl = false;
        try {
            bl = this.customChecker.verify(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            InsightAdministrator.showWarningDialog(jComponent, this.customChecker.getFailedMessage(), "Form Validation Warning");
            return false;
        }
        return true;
    }
}

