/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.usergroup;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.admin.userserver.usergroup.UserServerUser;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class UserServerUsersNode
extends TableDisplayControlPanelNode {
    protected UserServerNode userServerNode = null;

    public UserServerUsersNode(UserServerNode userServerNode) {
        super(userServerNode.getUserServer().getInsightAdministrator(), "Users", false);
        this.userServerNode = userServerNode;
        this.columnNames = new Object[]{"User Name", "Password", "Organization", "Email", "Phone", "Address", "City", "State", "Postal Code", "Country", "First Name", "Last Name", "Created"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.userServerNode.getUserServer().getUsers()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            UserServerUser userServerUser = (UserServerUser)vector.elementAt(i);
            objectArray[i][0] = userServerUser;
            objectArray[i][1] = userServerUser.password;
            objectArray[i][2] = userServerUser.organization;
            objectArray[i][3] = userServerUser.email;
            objectArray[i][4] = userServerUser.phone;
            objectArray[i][5] = userServerUser.address;
            objectArray[i][6] = userServerUser.city;
            objectArray[i][7] = userServerUser.state;
            objectArray[i][8] = userServerUser.postalCode;
            objectArray[i][9] = userServerUser.country;
            objectArray[i][10] = userServerUser.firstName;
            objectArray[i][11] = userServerUser.lastName;
            objectArray[i][12] = new SimpleDate(userServerUser.createdTimestamp).getFull();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.userServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New User Command", this.userServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.userServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-users-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.userServerNode.getAdminAccount(), "New User Command", "Edit User Command", "Delete User Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New User Command")) {
            this.userServerNode.createNewUser();
        } else if (string.equals("Delete User Command")) {
            if (vector != null && vector.size() > 0) {
                this.userServerNode.removeUsers(vector);
            }
        } else if (string.equals("Edit User Command") && vector != null && vector.size() == 1) {
            this.userServerNode.editUser((UserServerUser)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.userServerNode.editUser((UserServerUser)object);
        }
    }

    public static void debugOut(String string) {
        UserServerUsersNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerUsersNode: " + string, n);
    }
}

