/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.usergroup;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.userserver.usergroup.UserServerUserGroup;
import com.luna.insight.admin.userserver.usergroup.UserServerUserProfile;
import com.luna.insight.admin.userserver.usergroup.UserServerUserProfileGroupEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class UserServerUserProfileGroup
extends EditableDataObject
implements IndexedObject {
    protected UserServerUserProfile userProfile;
    protected UserServerUserGroup userGroup;
    protected boolean savePriv = false;
    protected boolean deletePriv = false;
    protected UserServerUserProfileGroupEditComponent editComponent = null;
    protected boolean removed = false;

    public UserServerUserProfileGroup(UserServerUserProfile userServerUserProfile, UserServerUserGroup userServerUserGroup, boolean bl, boolean bl2) {
        this.userProfile = userServerUserProfile;
        this.userGroup = userServerUserGroup;
        this.savePriv = bl;
        this.deletePriv = bl2;
    }

    public UserServerUserProfileGroup(UserServerUserProfileGroup userServerUserProfileGroup) {
        this.userProfile = userServerUserProfileGroup.userProfile;
        this.userGroup = userServerUserProfileGroup.userGroup;
        this.savePriv = userServerUserProfileGroup.savePriv;
        this.deletePriv = userServerUserProfileGroup.deletePriv;
    }

    public UserServerUserProfileGroup(UserServerUserProfile userServerUserProfile) {
        this.userProfile = userServerUserProfile;
    }

    public String toString() {
        return "USUPG " + this.userGroup.getName();
    }

    public boolean isMarkedRemoved() {
        return this.removed;
    }

    public void markRemoved() {
        this.markRemoved(true);
    }

    public void markRemoved(boolean bl) {
        this.removed = bl;
    }

    public int getIndex() {
        return this.userGroup.groupID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new UserServerUserProfileGroupEditComponent(this.userGroup.groupID);
        this.editComponent.getGroupNameField().setText(this.userGroup.getName());
        this.editComponent.getSavePrivCheckBox().setSelected(this.savePriv);
        this.editComponent.getDeletePrivCheckBox().setSelected(this.deletePriv);
        return this.editComponent;
    }

    public void save() {
        this.requiresCommit = false;
        if (this.hasChanged(this.savePriv, this.editComponent.getSavePrivCheckBox().isSelected())) {
            this.savePriv = this.editComponent.getSavePrivCheckBox().isSelected();
        }
        if (this.hasChanged(this.deletePriv, this.editComponent.getDeletePrivCheckBox().isSelected())) {
            this.deletePriv = this.editComponent.getDeletePrivCheckBox().isSelected();
        }
        this.creationCompleted = true;
    }

    public void cancel() {
        this.editComponent = null;
    }

    public String getEditWindowTitle() {
        return this.toString();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-user-profiles-node-icon.gif");
    }

    public boolean equals(Object object) {
        if (object instanceof UserServerUserProfileGroup) {
            UserServerUserProfileGroup userServerUserProfileGroup = (UserServerUserProfileGroup)object;
            boolean bl = this.userGroup.equals(userServerUserProfileGroup.userGroup) && this.savePriv == userServerUserProfileGroup.savePriv && this.deletePriv == userServerUserProfileGroup.deletePriv;
            return bl;
        }
        return super.equals(object);
    }

    public static void debugOut(String string) {
        UserServerUserProfileGroup.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerUserProfileGroup: " + string, n);
    }
}

