/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.usergroup;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.usergroup.UserServerUserGroup;
import com.luna.insight.admin.userserver.usergroup.UserServerUserProfileEditComponent;
import com.luna.insight.admin.userserver.usergroup.UserServerUserProfileGroup;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class UserServerUserProfile
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected int profileID;
    protected UserServer userServer;
    protected String profileName = "";
    protected int loginGroupID;
    protected Hashtable profileGroups = new Hashtable();
    protected UserServerUserProfileEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;

    public UserServerUserProfile(UserServer userServer, int n, String string) {
        this.userServer = userServer;
        this.profileID = n;
        this.profileName = string == null ? "" : string;
    }

    public UserServerUserProfile(UserServer userServer, int n) {
        this.userServer = userServer;
        this.profileID = n;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.profileName;
    }

    public void setLoginGroup(int n) {
        this.loginGroupID = n;
    }

    public void addProfileGroup(int n, boolean bl, boolean bl2) {
        Vector vector = this.userServer.getUserGroups(false);
        UserServerUserGroup userServerUserGroup = null;
        for (int i = 0; i < vector.size(); ++i) {
            UserServerUserGroup userServerUserGroup2 = (UserServerUserGroup)vector.elementAt(i);
            if (userServerUserGroup2.groupID != n) continue;
            userServerUserGroup = userServerUserGroup2;
            break;
        }
        if (userServerUserGroup != null) {
            this.profileGroups.put(new Integer(userServerUserGroup.getIndex()), new UserServerUserProfileGroup(this, userServerUserGroup, bl, bl2));
        }
    }

    public int getIndex() {
        return this.profileID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new UserServerUserProfileEditComponent();
        this.editComponent.getProfileNameField().setText(this.profileName);
        this.editComponent.getProfileNameField().selectAll();
        Vector vector = this.userServer.getUserGroups();
        this.itemSelector = new ListItemSelector("Available Groups:", "Assigned Groups:", vector, this.profileGroups);
        this.editComponent.getGroupSelectionPanel().add(this.itemSelector);
        this.editComponent.setListenerListModel(this.itemSelector.getToListModel(), this.profileGroups, this);
        return this.editComponent;
    }

    public void save() {
        UserServerUserProfile.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.profileName, this.editComponent.getProfileNameField().getText())) {
            this.profileName = this.editComponent.getProfileNameField().getText();
        }
        Hashtable hashtable = this.editComponent.getProfileGroups();
        Hashtable<Integer, UserServerUserProfileGroup> hashtable2 = new Hashtable<Integer, UserServerUserProfileGroup>();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            UserServerUserProfileGroup userServerUserProfileGroup = (UserServerUserProfileGroup)enumeration.nextElement();
            if (userServerUserProfileGroup.isMarkedRemoved()) continue;
            userServerUserProfileGroup.save();
            hashtable2.put(new Integer(userServerUserProfileGroup.getIndex()), userServerUserProfileGroup);
        }
        if (this.hasChanged(this.profileGroups, hashtable2)) {
            this.profileGroups = hashtable2;
        }
        if (this.hasChanged(this.loginGroupID, this.editComponent.getLoginGroupID())) {
            this.loginGroupID = this.editComponent.getLoginGroupID();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.userServer.commitDataObject(this);
        } else {
            this.userServer.cancelEdit(this);
        }
    }

    public void cancel() {
        UserServerUserProfile.debugOut("Cancel...", 3);
        Hashtable hashtable = this.editComponent.getProfileGroups();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((UserServerUserProfileGroup)enumeration.nextElement()).cancel();
        }
        this.editComponent = null;
        this.userServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit User Profile - " + this.profileName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-user-profiles-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof UserServerUserProfile) {
            UserServerUserProfile userServerUserProfile = (UserServerUserProfile)object;
            return this.profileID == userServerUserProfile.profileID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof UserServerUserProfile) {
            UserServerUserProfile userServerUserProfile = (UserServerUserProfile)databaseRecord;
            return this.profileID == userServerUserProfile.profileID && UserServerUserProfile.stringsAreEqual(this.profileName, userServerUserProfile.profileName) && this.loginGroupID == userServerUserProfile.loginGroupID && this.profileGroups.equals(userServerUserProfile.profileGroups);
        }
        return false;
    }

    public static void debugOut(String string) {
        UserServerUserProfile.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerUserProfile: " + string, n);
    }
}

