/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.usergroup;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.usergroup.UserServerUserGroupEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.ImageIcon;

public class UserServerUserGroup
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected int groupID;
    protected UserServer userServer;
    protected String groupName = "";
    protected String groupCodeKey = null;
    protected String displayName = null;
    protected String createdTimestamp = "";
    protected String modifiedTimestamp = "";
    protected Vector collections = new Vector();
    protected Set users = new HashSet();
    protected UserServerUserGroupEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;

    public UserServerUserGroup(UserServer userServer, int n, String string, String string2, String string3, String string4, String string5) {
        this.userServer = userServer;
        this.groupID = n;
        this.groupName = string == null ? "" : string;
        this.groupCodeKey = string2 == null ? "" : string2;
        this.displayName = string3 == null ? "" : string3;
        String string6 = new SimpleDate().get();
        this.createdTimestamp = string4 == null ? string6 : string4;
        this.modifiedTimestamp = string5 == null ? string6 : string5;
    }

    public UserServerUserGroup(int n, UserServer userServer) {
        String string;
        this.groupID = n;
        this.userServer = userServer;
        this.createdTimestamp = string = new SimpleDate().get();
        this.modifiedTimestamp = string;
    }

    public void addCollectionIndex(int n) {
        Integer n2 = new Integer(n);
        if (!this.collections.contains(n2)) {
            this.collections.addElement(n2);
        }
    }

    public void addUserIndex(int n) {
        this.users.add(new Integer(n));
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.groupName;
    }

    public String getCodeKey() {
        return this.groupCodeKey;
    }

    public int getIndex() {
        return this.groupID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new UserServerUserGroupEditComponent();
        this.editComponent.getGroupNameField().setText(this.groupName);
        this.editComponent.getGroupCodeKeyField().setText(this.groupCodeKey);
        this.editComponent.getGroupDisplayNameField().setText(this.displayName);
        this.editComponent.getGroupNameField().selectAll();
        this.itemSelector = new ListItemSelector("Available Collections:", "Assigned Collections:", this.userServer.getCollections(false), this.collections);
        this.editComponent.getServerSelectionPanel().add(this.itemSelector);
        return this.editComponent;
    }

    public void save() {
        UserServerUserGroup.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.groupName, this.editComponent.getGroupNameField().getText())) {
            this.groupName = this.editComponent.getGroupNameField().getText();
        }
        if (this.hasChanged(this.groupCodeKey, this.editComponent.getGroupCodeKeyField().getText())) {
            this.groupCodeKey = this.editComponent.getGroupCodeKeyField().getText();
        }
        if (this.hasChanged(this.displayName, this.editComponent.getGroupDisplayNameField().getText())) {
            this.displayName = this.editComponent.getGroupDisplayNameField().getText();
        }
        if (this.hasChanged(this.collections, this.itemSelector.getChosenItemIndices())) {
            this.collections = this.itemSelector.getChosenItemIndices();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.modifiedTimestamp = new SimpleDate().get();
            this.userServer.commitDataObject(this);
        } else {
            this.userServer.cancelEdit(this);
        }
    }

    public void cancel() {
        UserServerUserGroup.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.userServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit User Group - " + this.getName();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-user-groups-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof UserServerUserGroup) {
            UserServerUserGroup userServerUserGroup = (UserServerUserGroup)object;
            return this.groupID == userServerUserGroup.groupID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof UserServerUserGroup) {
            UserServerUserGroup userServerUserGroup = (UserServerUserGroup)databaseRecord;
            return this.groupID == userServerUserGroup.groupID && UserServerUserGroup.stringsAreEqual(this.groupName, userServerUserGroup.groupName) && UserServerUserGroup.stringsAreEqual(this.groupCodeKey, userServerUserGroup.groupCodeKey) && UserServerUserGroup.stringsAreEqual(this.displayName, userServerUserGroup.displayName) && UserServerUserGroup.stringsAreEqual(this.createdTimestamp, userServerUserGroup.createdTimestamp) && UserServerUserGroup.stringsAreEqual(this.modifiedTimestamp, userServerUserGroup.modifiedTimestamp) && this.collections.containsAll(userServerUserGroup.collections) && userServerUserGroup.collections.containsAll(this.collections);
        }
        return false;
    }

    public static void debugOut(String string) {
        UserServerUserGroup.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerUserGroup: " + string, n);
    }
}

