/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.usergroup;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.usergroup.ShareInUser;
import com.luna.insight.admin.userserver.usergroup.UserServerUserEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.util.Vector;
import javax.swing.ImageIcon;

public class UserServerUser
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
Comparable {
    protected int userID;
    protected UserServer userServer;
    protected String username = "";
    protected String password = "";
    protected String organization = "";
    protected String email = "";
    protected String phone = "";
    protected String address = "";
    protected String city = "";
    protected String state = "";
    protected String postalCode = "";
    protected String country = "";
    protected String firstName = "";
    protected String lastName = "";
    protected String createdTimestamp = "";
    protected Vector authGroups = new Vector();
    protected Vector shares = new Vector();
    protected UserServerUserEditComponent editComponent = null;
    protected ListItemSelector itemSelector = null;

    public UserServerUser(UserServer userServer, int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13) {
        this.userServer = userServer;
        this.userID = n;
        this.username = string == null ? "" : string;
        this.password = string2 == null ? "" : string2;
        this.organization = string3 == null ? "" : string3;
        this.email = string4 == null ? "" : string4;
        this.phone = string5 == null ? "" : string5;
        this.address = string6 == null ? "" : string6;
        this.city = string7 == null ? "" : string7;
        this.state = string8 == null ? "" : string8;
        this.postalCode = string9 == null ? "" : string9;
        this.country = string10 == null ? "" : string10;
        this.firstName = string11 == null ? "" : string11;
        this.lastName = string12 == null ? "" : string12;
        this.createdTimestamp = string13 == null ? new SimpleDate().get() : string13;
    }

    public UserServerUser(int n, UserServer userServer) {
        this.userID = n;
        this.userServer = userServer;
        this.createdTimestamp = new SimpleDate().get();
    }

    public void addAuthenticationGroupIndex(int n) {
        Integer n2 = new Integer(n);
        if (!this.authGroups.contains(n2)) {
            this.authGroups.add(n2);
        }
    }

    public void addShareInUser(ShareInUser shareInUser) {
        if (!this.shares.contains(shareInUser)) {
            this.shares.add(shareInUser);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.username;
    }

    public int getIndex() {
        return this.userID;
    }

    public int getUserId() {
        return this.userID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new UserServerUserEditComponent();
        this.editComponent.getUsernameField().setText(this.username);
        this.editComponent.getPasswordField().setText(this.password);
        this.editComponent.getOrganizationField().setText(this.organization);
        this.editComponent.getEmailField().setText(this.email);
        this.editComponent.getPhoneField().setText(this.phone);
        this.editComponent.getAddressField().setText(this.address);
        this.editComponent.getFirstNameField().setText(this.firstName);
        this.editComponent.getLastNameField().setText(this.lastName);
        this.editComponent.getCityField().setText(this.city);
        this.editComponent.getStateField().setText(this.state);
        this.editComponent.getPostalCodeField().setText(this.postalCode);
        this.editComponent.getCountryField().setText(this.country);
        this.editComponent.getUsernameField().selectAll();
        this.itemSelector = new ListItemSelector("Available Authentication Groups", "Assigned Authentication Groups", this.userServer.getUserGroups(), this.authGroups);
        this.editComponent.getAuthenticationGroupsSelectionPanel().add(this.itemSelector);
        return this.editComponent;
    }

    public void save() {
        UserServerUser.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.username, this.editComponent.getUsernameField().getText())) {
            this.username = this.editComponent.getUsernameField().getText();
        }
        if (this.hasChanged(this.password, this.editComponent.getPasswordField().getText())) {
            this.password = this.editComponent.getPasswordField().getText();
        }
        if (this.hasChanged(this.organization, this.editComponent.getOrganizationField().getText())) {
            this.organization = this.editComponent.getOrganizationField().getText();
        }
        if (this.hasChanged(this.email, this.editComponent.getEmailField().getText())) {
            this.email = this.editComponent.getEmailField().getText();
        }
        if (this.hasChanged(this.phone, this.editComponent.getPhoneField().getText())) {
            this.phone = this.editComponent.getPhoneField().getText();
        }
        if (this.hasChanged(this.address, this.editComponent.getAddressField().getText())) {
            this.address = this.editComponent.getAddressField().getText();
        }
        if (this.hasChanged(this.firstName, this.editComponent.getFirstNameField().getText())) {
            this.firstName = this.editComponent.getFirstNameField().getText();
        }
        if (this.hasChanged(this.lastName, this.editComponent.getLastNameField().getText())) {
            this.lastName = this.editComponent.getLastNameField().getText();
        }
        if (this.hasChanged(this.city, this.editComponent.getCityField().getText())) {
            this.city = this.editComponent.getCityField().getText();
        }
        if (this.hasChanged(this.state, this.editComponent.getStateField().getText())) {
            this.state = this.editComponent.getStateField().getText();
        }
        if (this.hasChanged(this.postalCode, this.editComponent.getPostalCodeField().getText())) {
            this.postalCode = this.editComponent.getPostalCodeField().getText();
        }
        if (this.hasChanged(this.country, this.editComponent.getCountryField().getText())) {
            this.country = this.editComponent.getCountryField().getText();
        }
        if (this.hasChanged(this.authGroups, this.itemSelector.getChosenItemIndices())) {
            this.authGroups = this.itemSelector.getChosenItemIndices();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.userServer.commitDataObject(this);
        } else {
            this.userServer.cancelEdit(this);
        }
    }

    public void cancel() {
        UserServerUser.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.userServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit User - " + this.username;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-users-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof UserServerUser) {
            UserServerUser userServerUser = (UserServerUser)object;
            return this.userID == userServerUser.userID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof UserServerUser) {
            UserServerUser userServerUser = (UserServerUser)databaseRecord;
            return this.userID == userServerUser.userID && UserServerUser.stringsAreEqual(this.username, userServerUser.username) && UserServerUser.stringsAreEqual(this.password, userServerUser.password) && UserServerUser.stringsAreEqual(this.organization, userServerUser.organization) && UserServerUser.stringsAreEqual(this.email, userServerUser.email) && UserServerUser.stringsAreEqual(this.phone, userServerUser.phone) && UserServerUser.stringsAreEqual(this.address, userServerUser.address) && UserServerUser.stringsAreEqual(this.firstName, userServerUser.firstName) && UserServerUser.stringsAreEqual(this.lastName, userServerUser.lastName) && UserServerUser.stringsAreEqual(this.city, userServerUser.city) && UserServerUser.stringsAreEqual(this.state, userServerUser.state) && UserServerUser.stringsAreEqual(this.postalCode, userServerUser.postalCode) && UserServerUser.stringsAreEqual(this.country, userServerUser.country) && UserServerUser.stringsAreEqual(this.createdTimestamp, userServerUser.createdTimestamp) && this.authGroups.containsAll(userServerUser.authGroups) && userServerUser.authGroups.containsAll(this.authGroups);
        }
        return false;
    }

    public static void debugOut(String string) {
        UserServerUser.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerUser: " + string, n);
    }

    public int compareTo(Object object) {
        return this.username.compareTo(((UserServerUser)object).username);
    }
}

